/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.registry.registrar;

import com.legacy.structure_gel.core.util.Internal;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.data.loading.DatagenModLoader;
import net.neoforged.neoforge.registries.RegisterEvent;

public abstract class Registrar<T> {
    protected final ResourceKey<T> key;

    public Registrar(ResourceKey<T> key) {
        this.key = key;
    }

    public static <T, V extends T> Pointer<V> createPointer(ResourceKey<T> key, Supplier<V> value) {
        return Registrar.createPointer(key, (BootstrapContext<?> c) -> value.get());
    }

    public static <T, V extends T> Pointer<V> createPointer(ResourceKey<T> key, Function<BootstrapContext<?>, V> value) {
        return DatagenModLoader.isRunningDataGen() ? new DataGenPointer<T>(key, value) : new Pointer<T>(key);
    }

    public static <T, V extends T> Static<V> createStatic(ResourceKey<T> key) {
        return new Static<T>(key);
    }

    public static <T, V extends Block> BlockRef<V> createBlockRef(ResourceKey<T> key) {
        return new BlockRef<T>(key);
    }

    public static <T, V extends Item> ItemRef<V> createItemRef(ResourceKey<T> key) {
        return new ItemRef<T>(key);
    }

    @Nullable
    public T get(RegistryAccess registryAccess) {
        return this.get(registryAccess.lookupOrThrow(this.getRegistryKey()));
    }

    @Nullable
    public T get(CommonLevelAccessor level) {
        return this.get(level.registryAccess());
    }

    @Nullable
    public T get(Registry<?> registry) {
        return (T)registry.get(this.getKey());
    }

    @Nullable
    public T orElseGet(Registry<?> registry, Supplier<T> orElse) {
        T val = this.get(registry);
        return val != null ? val : orElse.get();
    }

    public boolean isPresent(Registry<?> registry) {
        return registry.containsKey(this.getName());
    }

    @Nullable
    public <R> R map(Registry<?> registry, Function<T, R> mapFunc) {
        if (this.isPresent(registry)) {
            return mapFunc.apply(this.get(registry));
        }
        return null;
    }

    public Optional<Holder<T>> getHolder(RegistryAccess registryAccess) {
        return this.getHolder(registryAccess.lookupOrThrow(this.getRegistryKey()));
    }

    public Optional<Holder<T>> getHolder(CommonLevelAccessor level) {
        return this.getHolder(level.registryAccess());
    }

    public Optional<Holder<T>> getHolder(Registry<?> registry) {
        return registry.get(this.getKey());
    }

    public Optional<Holder.Reference<T>> getHolder(BootstrapContext<?> bootstrapContext) {
        return this.getHolder(bootstrapContext.lookup(this.getRegistryKey()));
    }

    public Optional<Holder.Reference<T>> getHolder(HolderGetter<?> holderGetter) {
        return holderGetter.get(this.getKey());
    }

    public ResourceKey<T> getKey() {
        return this.key;
    }

    public ResourceKey<? extends Registry<?>> getRegistryKey() {
        return this.getKey().registryKey();
    }

    public ResourceLocation getName() {
        return this.getKey().location();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[key=" + String.valueOf(this.getKey()) + "]";
    }

    public static class Pointer<T>
    extends Registrar<T> {
        protected Pointer(ResourceKey<T> key) {
            super(key);
        }
    }

    @Internal
    protected static class DataGenPointer<T>
    extends Pointer<T> {
        protected final Function<BootstrapContext<?>, T> valueFactory;

        protected DataGenPointer(ResourceKey<T> key, Function<BootstrapContext<?>, T> valueFactory) {
            super(key);
            this.valueFactory = valueFactory;
        }

        public void registerData(BootstrapContext<?> context) {
            context.register(this.getKey(), this.valueFactory.apply(context));
        }
    }

    public static class Static<T>
    extends Registrar<T>
    implements Supplier<T> {
        @Nullable
        protected Holder.Reference<T> holder;

        protected Static(ResourceKey<T> key) {
            super(key);
        }

        protected void register(RegisterEvent event, Supplier<T> valueSupplier) {
            Registry registry;
            if (this.holder == null && (registry = event.getRegistry(this.getKey().registryKey())) != null) {
                if (valueSupplier != null) {
                    this.holder = Registry.registerForHolder((Registry)registry, this.getKey(), valueSupplier.get());
                } else {
                    throw new IllegalStateException("The Static Registrar for " + String.valueOf(this.key) + " was not assigned a value");
                }
            }
        }

        @Override
        public ResourceKey<T> getKey() {
            return this.key;
        }

        public <R> ResourceKey<R> getKey(ResourceKey<Registry<R>> registryKey) {
            return this.key;
        }

        @Override
        @Nullable
        public T get() {
            return (T)this.getHolder().value();
        }

        @Nullable
        public Holder.Reference<T> getHolder() {
            if (this.holder == null) {
                throw new IllegalStateException("Attempted to get a holder before it was registered.");
            }
            return this.holder;
        }

        public T orElseGet(Supplier<T> orElse) {
            return this.isPresent() ? this.get() : orElse.get();
        }

        public boolean isPresent() {
            return this.holder != null;
        }

        @Nullable
        public <R> R map(Function<T, R> mapFunc) {
            if (this.isPresent()) {
                return mapFunc.apply(this.get());
            }
            return null;
        }
    }

    public static class BlockRef<T extends Block>
    extends Static<T>
    implements ItemLike {
        protected BlockRef(ResourceKey<T> key) {
            super(key);
        }

        public Item asItem() {
            return ((Block)this.get()).asItem();
        }

        public BlockState defaultBlockState() {
            return ((Block)this.get()).defaultBlockState();
        }
    }

    public static class ItemRef<T extends Item>
    extends Static<T>
    implements ItemLike {
        protected ItemRef(ResourceKey<T> key) {
            super(key);
        }

        public Item asItem() {
            return (Item)this.get();
        }

        public ItemStack getDefaultInstance() {
            return ((Item)this.get()).getDefaultInstance();
        }
    }
}

