/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.registry.registrar;

import com.google.common.collect.ImmutableSet;
import com.legacy.structure_gel.api.registry.registrar.Registrar;
import com.legacy.structure_gel.core.StructureGelMod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.RegisterEvent;

public class RegistrarHandler<T> {
    private static final Map<String, Map<ResourceKey<Registry<?>>, RegistrarHandler<?>>> HANDLERS = new HashMap();
    protected final ResourceKey<Registry<T>> registry;
    protected final String modID;
    private boolean registeredToBus = false;
    protected final LinkedHashMap<ResourceKey<T>, FutureRegister<T>> needsRegistered = new LinkedHashMap();
    private final List<Consumer<RegisterEvent.RegisterHelper<T>>> registerEventListeners = new ArrayList<Consumer<RegisterEvent.RegisterHelper<T>>>();
    private final List<Consumer<RegistrarHandler<T>>> handlerListeners = new ArrayList<Consumer<RegistrarHandler<T>>>();
    protected final List<Registrar.DataGenPointer<?>> needsGenerated = new ArrayList(0);
    private final List<BootstrapInit<T>> bootstraps = new ArrayList<BootstrapInit<T>>(0);

    protected RegistrarHandler(ResourceKey<Registry<T>> registry, String modID) {
        this.registry = registry;
        this.modID = modID;
    }

    public String getModID() {
        return this.modID;
    }

    public ResourceKey<? extends Registry<?>> getRegistry() {
        return this.registry;
    }

    public static <T> RegistrarHandler<T> getOrCreate(ResourceKey<Registry<T>> registry, String modID) {
        return RegistrarHandler.getOrCreate(registry, modID, r -> {
            if (r.equals(Registries.BLOCK)) {
                return new BlockHandler(modID);
            }
            if (r.equals(Registries.ITEM)) {
                return new ItemHandler(modID);
            }
            if (r.equals(Registries.DATA_COMPONENT_TYPE)) {
                return new DataComponentHandler(modID);
            }
            if (r.equals(Registries.POINT_OF_INTEREST_TYPE)) {
                return new PoiTypeHandler(modID);
            }
            return new RegistrarHandler(r, modID);
        });
    }

    public static BlockHandler getOrCreateBlocks(String modID) throws ClassCastException {
        RegistrarHandler handler = RegistrarHandler.getOrCreate(Registries.BLOCK, modID, r -> new BlockHandler(modID));
        if (handler instanceof BlockHandler) {
            return (BlockHandler)handler;
        }
        throw new ClassCastException("[Structure Gel] Cannot get a " + BlockHandler.class.getSimpleName() + " for " + modID + " because it already owns one as a " + handler.getClass().getSimpleName());
    }

    public static ItemHandler getOrCreateItems(String modID) throws ClassCastException {
        RegistrarHandler handler = RegistrarHandler.getOrCreate(Registries.ITEM, modID, r -> new ItemHandler(modID));
        if (handler instanceof ItemHandler) {
            return (ItemHandler)handler;
        }
        throw new ClassCastException("[Structure Gel] Cannot get a " + ItemHandler.class.getSimpleName() + " for " + modID + " because it already owns one as a " + handler.getClass().getSimpleName());
    }

    public static DataComponentHandler getOrCreateDataComponents(String modID) throws ClassCastException {
        RegistrarHandler handler = RegistrarHandler.getOrCreate(Registries.DATA_COMPONENT_TYPE, modID, r -> new DataComponentHandler(modID));
        if (handler instanceof DataComponentHandler) {
            return (DataComponentHandler)handler;
        }
        throw new ClassCastException("[Structure Gel] Cannot get a " + DataComponentHandler.class.getSimpleName() + " for " + modID + " because it already owns one as a " + handler.getClass().getSimpleName());
    }

    public static PoiTypeHandler getOrCreatePoi(String modID) throws ClassCastException {
        RegistrarHandler handler = RegistrarHandler.getOrCreate(Registries.POINT_OF_INTEREST_TYPE, modID, r -> new PoiTypeHandler(modID));
        if (handler instanceof PoiTypeHandler) {
            return (PoiTypeHandler)handler;
        }
        throw new ClassCastException("[Structure Gel] Cannot get a " + PoiTypeHandler.class.getSimpleName() + " for " + modID + " because it already owns one as a " + handler.getClass().getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> RegistrarHandler<T> getOrCreate(ResourceKey<Registry<T>> registry, String modID, Function<ResourceKey<Registry<?>>, RegistrarHandler<?>> handlerFactory) {
        Map<String, Map<ResourceKey<Registry<?>>, RegistrarHandler<?>>> map = HANDLERS;
        synchronized (map) {
            return HANDLERS.computeIfAbsent(modID, s -> new HashMap()).computeIfAbsent(registry, handlerFactory);
        }
    }

    public Registrar.Static<T> createStatic(String key) {
        return this.createStatic(key, null);
    }

    public <R extends T, V extends R> void register(Registrar.Static<R> registrar, Supplier<V> value) {
        FutureRegister<T> future = this.needsRegistered.get(registrar.key);
        if (future != null) {
            future.value = value;
        }
    }

    public <V extends T> Registrar.Static<V> createStatic(String name, Supplier<V> value) {
        return this.createStatic(this.key(name), value);
    }

    public <V extends T> Registrar.Static<V> createStatic(ResourceKey<T> name, Supplier<V> value) {
        Registrar.Static ret = Registrar.createStatic(name);
        this.needsRegistered.put(name, new FutureRegister(ret, value));
        return ret;
    }

    public <V extends T> Registrar.Pointer<V> createPointer(String name, Supplier<V> value) {
        return this.createPointer(name, (BootstrapContext<?> c) -> value.get());
    }

    public <V extends T> Registrar.Pointer<V> createPointer(String name, Function<BootstrapContext<?>, V> value) {
        return this.createPointer(this.key(name), value);
    }

    public <V extends T> Registrar.Pointer<V> createPointer(ResourceKey<T> name, Function<BootstrapContext<?>, V> value) {
        Registrar.Pointer<V> ret = Registrar.createPointer(name, value);
        if (ret instanceof Registrar.DataGenPointer) {
            this.needsGenerated.add((Registrar.DataGenPointer)ret);
        }
        return ret;
    }

    public RegistrarHandler<T> bootstrap(BootstrapInit<T> bootstrap) {
        this.bootstraps.add(bootstrap);
        return this;
    }

    public RegistrarHandler<T> addListener(Consumer<RegisterEvent.RegisterHelper<T>> registerHelper) {
        this.registerEventListeners.add(registerHelper);
        return this;
    }

    public <R extends RegistrarHandler<T>> R addHandlerListener(Consumer<R> handlerListener) {
        this.handlerListeners.add(handlerListener);
        return (R)this;
    }

    public ResourceKey<T> key(String name) {
        return ResourceKey.create(this.registry, (ResourceLocation)ResourceLocation.tryBuild((String)this.modID, (String)name));
    }

    public TagKey<T> tagKey(String name) {
        return TagKey.create(this.registry, (ResourceLocation)ResourceLocation.tryBuild((String)this.modID, (String)name));
    }

    public static void registerHandlers(String modID, IEventBus modBus, RegistrarHandler<?> ... handlers) {
        RegistrarHandler.registerHandlers(modID, modBus, List.of(handlers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerHandlers(String modID, IEventBus modBus, Collection<RegistrarHandler<?>> handlers) {
        GroupedRegistryListener grouped = new GroupedRegistryListener();
        Map<String, Map<ResourceKey<Registry<?>>, RegistrarHandler<?>>> map = HANDLERS;
        synchronized (map) {
            HANDLERS.getOrDefault(modID, Map.of()).values().forEach(grouped::add);
        }
        handlers.forEach(grouped::add);
        modBus.addListener(EventPriority.NORMAL, grouped::onRegister);
    }

    public void register(IEventBus modBus) {
        if (!this.registeredToBus) {
            modBus.addListener(EventPriority.NORMAL, this::registerValues);
            this.registeredToBus = true;
        }
    }

    public void registerValues(RegisterEvent event) {
        if (this.registry.equals((Object)event.getRegistryKey())) {
            this.handlerListeners.forEach(h -> h.accept(this));
            this.registerEventListeners.forEach(c -> event.register(this.registry, c));
            this.needsRegistered.values().forEach(f -> f.registrar.register(event, f.value));
            this.needsRegistered.clear();
        }
    }

    public static RegistrySetBuilder injectRegistries(RegistrySetBuilder builder) {
        return RegistrarHandler.injectRegistries(builder, HANDLERS.keySet());
    }

    public static RegistrySetBuilder injectRegistries(RegistrySetBuilder builder, Set<String> mods) {
        HashMap<ResourceKey, List> registrars = new HashMap<ResourceKey, List>();
        for (String string : mods) {
            Map<ResourceKey<Registry<?>>, RegistrarHandler<?>> handlers = HANDLERS.get(string);
            if (handlers == null) continue;
            for (Map.Entry<ResourceKey<Registry<?>>, RegistrarHandler<?>> entry : handlers.entrySet()) {
                RegistrarHandler<?> handler = entry.getValue();
                if (handler.isBuiltIn()) continue;
                registrars.computeIfAbsent(entry.getKey(), r -> new ArrayList()).add(handler);
            }
        }
        for (Map.Entry entry : registrars.entrySet()) {
            builder.add((ResourceKey)entry.getKey(), c -> ((List)entry.getValue()).forEach(r -> r.registerForDatagen(c)));
        }
        return builder;
    }

    public boolean isBuiltIn() {
        return BuiltInRegistries.REGISTRY.containsKey(this.registry.location());
    }

    private void registerForDatagen(BootstrapContext<T> context) {
        StructureGelMod.LOGGER.info("Registering {} ({})", this.registry.location(), this.modID);
        this.bootstraps.forEach(b -> b.run(context));
        int s = this.needsGenerated.size();
        for (int i = 0; i < s; ++i) {
            this.needsGenerated.get(i).registerData(context);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[owner = " + this.modID + ", registry = " + String.valueOf(this.registry.location()) + "]";
    }

    public static final class BlockHandler
    extends RegistrarHandler<Block> {
        protected BlockHandler(String modID) {
            super(Registries.BLOCK, modID);
        }

        public <V extends Block> Registrar.BlockRef<V> blockOnly(String name, Function<BlockBehaviour.Properties, V> blockFactory, Supplier<BlockBehaviour.Properties> properties) {
            ResourceKey key = this.key(name);
            Registrar.BlockRef ret = Registrar.createBlockRef(key);
            this.needsRegistered.put(key, new FutureRegister<Block>(ret, () -> (Block)blockFactory.apply(((BlockBehaviour.Properties)properties.get()).setId(key))));
            return ret;
        }

        public <V extends Block> Registrar.BlockRef<V> block(String key, Function<BlockBehaviour.Properties, V> blockFactory, Supplier<BlockBehaviour.Properties> properties) {
            return this.block(key, blockFactory, properties, () -> new Item.Properties());
        }

        public <V extends Block> Registrar.BlockRef<V> block(String key, Function<BlockBehaviour.Properties, V> blockFactory, Supplier<BlockBehaviour.Properties> properties, Supplier<Item.Properties> itemProperties) {
            return this.block(key, blockFactory, properties, BlockItem::new, itemProperties);
        }

        public <V extends Block, I extends Item> Registrar.BlockRef<V> block(String name, Function<BlockBehaviour.Properties, V> blockFactory, Supplier<BlockBehaviour.Properties> properties, BiFunction<V, Item.Properties, I> itemFactory, Supplier<Item.Properties> itemProperties) {
            Registrar.BlockRef ret = this.blockOnly(name, blockFactory, properties);
            BlockHandler.getOrCreateItems(this.modID).item(name, p -> (Item)itemFactory.apply((Object)((Block)ret.get()), (Item.Properties)p), () -> ((Item.Properties)itemProperties.get()).useBlockDescriptionPrefix());
            return ret;
        }

        public <V extends Block> Registrar.BlockRef<V> block(String name) {
            ResourceKey key = this.key(name);
            Registrar.BlockRef ret = Registrar.createBlockRef(key);
            this.needsRegistered.put(key, new FutureRegister(ret, null));
            return ret;
        }

        public <V extends Block> void registerBlockOnly(Registrar.Static<V> registrar, Function<BlockBehaviour.Properties, V> blockFactory, Supplier<BlockBehaviour.Properties> properties) {
            super.register(registrar, () -> (Block)blockFactory.apply(((BlockBehaviour.Properties)properties.get()).setId(registrar.getKey(this.registry))));
        }

        public <V extends Block> void registerBlock(Registrar.Static<V> registrar, Function<BlockBehaviour.Properties, V> blockFactory, Supplier<BlockBehaviour.Properties> properties) {
            this.registerBlock(registrar, blockFactory, properties, () -> new Item.Properties());
        }

        public <V extends Block> void registerBlock(Registrar.Static<V> registrar, Function<BlockBehaviour.Properties, V> blockFactory, Supplier<BlockBehaviour.Properties> properties, Supplier<Item.Properties> itemProperties) {
            this.registerBlock(registrar, blockFactory, properties, BlockItem::new, itemProperties);
        }

        public <V extends Block, I extends Item> void registerBlock(Registrar.Static<V> registrar, Function<BlockBehaviour.Properties, V> blockFactory, Supplier<BlockBehaviour.Properties> properties, BiFunction<V, Item.Properties, I> itemFactory, Supplier<Item.Properties> itemProperties) {
            this.registerBlockOnly(registrar, blockFactory, properties);
            BlockHandler.getOrCreateItems(this.modID).item(registrar.key.location().getPath(), p -> (Item)itemFactory.apply((Object)((Block)registrar.get()), (Item.Properties)p), () -> ((Item.Properties)itemProperties.get()).useBlockDescriptionPrefix());
        }
    }

    public static final class ItemHandler
    extends RegistrarHandler<Item> {
        protected ItemHandler(String modID) {
            super(Registries.ITEM, modID);
        }

        public <V extends Item> Registrar.ItemRef<V> item(String name, Function<Item.Properties, V> itemFactory, Supplier<Item.Properties> properties) {
            ResourceKey key = this.key(name);
            Registrar.ItemRef ret = Registrar.createItemRef(key);
            this.needsRegistered.put(key, new FutureRegister<Item>(ret, () -> (Item)itemFactory.apply(((Item.Properties)properties.get()).setId(key))));
            return ret;
        }

        public <V extends Item> Registrar.ItemRef<V> registerItem(String name) {
            ResourceKey key = this.key(name);
            Registrar.ItemRef ret = Registrar.createItemRef(key);
            this.needsRegistered.put(key, new FutureRegister(ret, null));
            return ret;
        }

        public <V extends Item> void registerItem(Registrar.Static<V> registrar, Function<Item.Properties, V> itemFactory, Supplier<Item.Properties> properties) {
            super.register(registrar, () -> (Item)itemFactory.apply(((Item.Properties)properties.get()).setId(registrar.getKey(this.registry))));
        }
    }

    public static final class DataComponentHandler
    extends RegistrarHandler<DataComponentType<?>> {
        protected DataComponentHandler(String modID) {
            super(Registries.DATA_COMPONENT_TYPE, modID);
        }

        public <T> Registrar.Static<DataComponentType<T>> component(String key, UnaryOperator<DataComponentType.Builder<T>> builder) {
            return this.createStatic(key, () -> ((DataComponentType.Builder)((DataComponentType.Builder)builder.apply(DataComponentType.builder()))).build());
        }
    }

    public static final class PoiTypeHandler
    extends RegistrarHandler<PoiType> {
        protected PoiTypeHandler(String modID) {
            super(Registries.POINT_OF_INTEREST_TYPE, modID);
        }

        public Registrar.Static<PoiType> poi(String key, UnaryOperator<PoiBuilder> value) {
            return this.createStatic(key, () -> ((PoiBuilder)value.apply(new PoiBuilder())).build());
        }

        public static class PoiBuilder {
            final Set<BlockState> states = new HashSet<BlockState>();
            int maxTickets = 0;
            int validRange = 1;

            public PoiBuilder states(Block ... blocks) {
                Stream.of(blocks).flatMap(b -> b.getStateDefinition().getPossibleStates().stream()).forEach(this.states::add);
                return this;
            }

            public PoiBuilder maxTickets(int maxTickets) {
                this.maxTickets = maxTickets;
                return this;
            }

            public PoiBuilder validRange(int validRange) {
                this.validRange = validRange;
                return this;
            }

            private PoiType build() {
                return new PoiType((Set)ImmutableSet.copyOf(this.states), this.maxTickets, this.validRange);
            }
        }
    }

    private static class FutureRegister<T> {
        final Registrar.Static<? extends T> registrar;
        Supplier<? extends T> value;

        FutureRegister(Registrar.Static<? extends T> registrar, Supplier<? extends T> value) {
            this.registrar = registrar;
            this.value = value;
        }
    }

    private static class GroupedRegistryListener {
        public final Map<ResourceKey<? extends Registry<?>>, List<Consumer<RegisterEvent>>> registerListeners = new HashMap();

        private GroupedRegistryListener() {
        }

        public void add(RegistrarHandler<?> handler) {
            if (!handler.registeredToBus) {
                this.registerListeners.computeIfAbsent(handler.getRegistry(), r -> new ArrayList(1)).add(handler::registerValues);
                handler.registeredToBus = true;
            }
        }

        public void onRegister(RegisterEvent event) {
            List<Consumer<RegisterEvent>> listeners = this.registerListeners.get(event.getRegistryKey());
            if (listeners != null) {
                for (Consumer<RegisterEvent> listener : listeners) {
                    listener.accept(event);
                }
            }
        }
    }

    public static interface BootstrapInit<T> {
        public void run(BootstrapContext<T> var1);
    }
}

