/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.structure;

import com.legacy.structure_gel.api.registry.StructureGelRegistries;
import com.legacy.structure_gel.api.structure.base.IPieceBuilderModifier;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawCapability;
import com.legacy.structure_gel.core.registry.SGRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasBinding;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;

public class ExtendedJigsawStructure
extends JigsawStructure
implements IPieceBuilderModifier {
    public static final MapCodec<ExtendedJigsawStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtendedJigsawStructure.settingsCodec((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(jigsaw -> jigsaw.startPool), (App)ResourceLocation.CODEC.optionalFieldOf("start_jigsaw_name").forGetter(jigsaw -> jigsaw.startJigsawName), (App)Codec.intRange((int)0, (int)32).fieldOf("size").forGetter(jigsaw -> jigsaw.maxDepth), (App)HeightProvider.CODEC.fieldOf("start_height").forGetter(jigsaw -> jigsaw.startHeight), (App)Codec.BOOL.fieldOf("use_expansion_hack").forGetter(jigsaw -> jigsaw.useExpansionHack), (App)Heightmap.Types.CODEC.optionalFieldOf("project_start_to_heightmap").forGetter(jigsaw -> jigsaw.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(jigsaw -> jigsaw.maxDistanceFromCenter), (App)Codec.list((Codec)PoolAliasBinding.CODEC).optionalFieldOf("pool_aliases", List.of()).forGetter(jigsaw -> jigsaw.poolAliases), (App)DimensionPadding.CODEC.optionalFieldOf("dimension_padding", (Object)DEFAULT_DIMENSION_PADDING).forGetter(jigsaw -> jigsaw.dimensionPadding), (App)LiquidSettings.CODEC.optionalFieldOf("liquid_settings", (Object)DEFAULT_LIQUID_SETTINGS).forGetter(jigsaw -> jigsaw.liquidSettings), (App)JigsawCapability.CODEC.optionalFieldOf("capability").forGetter(jigsaw -> jigsaw.capability)).apply((Applicative)instance, ExtendedJigsawStructure::new)).flatXmap(ExtendedJigsawStructure::verifyRange, ExtendedJigsawStructure::verifyRange);
    protected final Optional<JigsawCapability> capability;

    protected DataResult<ExtendedJigsawStructure> verifyRange() {
        byte dist = switch (this.terrainAdaptation()) {
            case TerrainAdjustment.NONE -> 0;
            case TerrainAdjustment.BURY, TerrainAdjustment.BEARD_THIN, TerrainAdjustment.BEARD_BOX -> 12;
            default -> throw new IncompatibleClassChangeError();
        };
        return this.maxDistanceFromCenter + dist > 128 ? DataResult.error(() -> "Structure size including terrain adaptation must not exceed 128. Terrain adaptation dist: " + dist + ", Size: " + this.maxDistanceFromCenter) : DataResult.success((Object)this);
    }

    protected ExtendedJigsawStructure(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int maxDepth, HeightProvider startHeight, boolean useExpansionHack, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, List<PoolAliasBinding> poolAliases, DimensionPadding dimensionPadding, LiquidSettings liquidSettings, Optional<JigsawCapability> capability) {
        super(settings, startPool, startJigsawName, maxDepth, startHeight, useExpansionHack, projectStartToHeightmap, maxDistanceFromCenter, poolAliases, dimensionPadding, liquidSettings);
        this.capability = capability;
    }

    public static Builder builder(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool) {
        return new Builder(settings, startPool);
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        return super.findGenerationPoint(context);
    }

    public StructureType<?> type() {
        return SGRegistry.StructureTypes.EXTENDED_JIGSAW.get();
    }

    @Override
    public void modifyPieceBuilder(StructurePiecesBuilder pieceBuilder, Structure.GenerationContext context) {
        if (this.capability.isPresent()) {
            this.capability.get().modifyPieceBuilder(pieceBuilder, context);
        }
    }

    public Optional<JigsawCapability> getCapability() {
        return this.capability;
    }

    public <T extends JigsawCapability> Optional<T> getCapability(Class<T> expectedClass) {
        return this.getCapability().map(cap -> expectedClass.isInstance(cap) ? (JigsawCapability)expectedClass.cast(cap) : null);
    }

    public static class Builder {
        final Structure.StructureSettings settings;
        final Holder<StructureTemplatePool> startPool;
        Optional<ResourceLocation> startJigsawName = Optional.empty();
        int maxDepth = 7;
        HeightProvider startHeight = ConstantHeight.ZERO;
        boolean useExpansionHack = false;
        Optional<Heightmap.Types> projectStartToHeightmap = Optional.empty();
        int maxDistanceFromCenter = 80;
        List<PoolAliasBinding> poolAliases = new ArrayList<PoolAliasBinding>();
        DimensionPadding dimensionPadding = JigsawStructure.DEFAULT_DIMENSION_PADDING;
        LiquidSettings liquidSettings = JigsawStructure.DEFAULT_LIQUID_SETTINGS;
        Optional<JigsawCapability> capability = Optional.empty();

        private Builder(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool) {
            this.settings = settings;
            this.startPool = startPool;
        }

        public Builder startJigsaw(ResourceLocation startJigsawName) {
            this.startJigsawName = Optional.ofNullable(startJigsawName);
            return this;
        }

        public Builder maxDepth(int maxDepth) {
            this.maxDepth = maxDepth;
            return this;
        }

        public Builder startHeight(HeightProvider startHeight) {
            this.startHeight = startHeight;
            return this;
        }

        public Builder startHeight(int startHeight) {
            return this.startHeight((HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)startHeight)));
        }

        public Builder startHeight(int minHeight, int maxHeight) {
            return this.startHeight((HeightProvider)UniformHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)minHeight), (VerticalAnchor)VerticalAnchor.absolute((int)maxHeight)));
        }

        public Builder useExpansionHack() {
            this.useExpansionHack = true;
            return this;
        }

        public Builder heightmap(Heightmap.Types heightmap) {
            this.projectStartToHeightmap = Optional.ofNullable(heightmap);
            return this;
        }

        public Builder onSurface() {
            return this.heightmap(Heightmap.Types.WORLD_SURFACE_WG);
        }

        public Builder onOceanFloor() {
            return this.heightmap(Heightmap.Types.OCEAN_FLOOR_WG);
        }

        public Builder maxDistanceFromCenter(int maxDistanceFromCenter) {
            this.maxDistanceFromCenter = maxDistanceFromCenter;
            return this;
        }

        public Builder poolAlias(PoolAliasBinding alias) {
            this.poolAliases.add(alias);
            return this;
        }

        public Builder poolAlias(List<PoolAliasBinding> aliases) {
            this.poolAliases.addAll(aliases);
            return this;
        }

        public Builder dimensionPadding(DimensionPadding padding) {
            this.dimensionPadding = padding;
            return this;
        }

        public Builder liquidSettings(LiquidSettings liquidSettings) {
            this.liquidSettings = liquidSettings;
            return this;
        }

        public Builder capability(JigsawCapability capability) {
            this.capability = Optional.ofNullable(capability);
            return this;
        }

        public ExtendedJigsawStructure build() {
            if (this.capability.isPresent() && !StructureGelRegistries.JIGSAW_TYPE.containsValue(this.capability.get().getType())) {
                throw new IllegalStateException("JigsawCapabilityType not registered for " + String.valueOf(this.capability.get()) + ". Be sure to register it to StructureGelRegistries.Keys.JIGSAW_TYPE");
            }
            return new ExtendedJigsawStructure(this.settings, this.startPool, this.startJigsawName, this.maxDepth, this.startHeight, this.useExpansionHack, this.projectStartToHeightmap, this.maxDistanceFromCenter, this.poolAliases, this.dimensionPadding, this.liquidSettings, this.capability);
        }
    }

    public record PlaceContext(Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int maxDepth, boolean useExpansionHack, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, DimensionPadding padding, LiquidSettings liquidSettings, Optional<JigsawCapability> capability) {
    }
}

