/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.structure;

import com.legacy.structure_gel.api.registry.registrar.StructureRegistrar;
import com.legacy.structure_gel.api.structure.StructureAccessHelper;
import com.legacy.structure_gel.core.registry.SGRegistry;
import com.legacy.structure_gel.core.util.Internal;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;

public class GridStructurePlacement
extends StructurePlacement {
    public static final MapCodec<GridStructurePlacement> CODEC = RecordCodecBuilder.mapCodec(instance -> {
        Products.P5 placement = GridStructurePlacement.placementCodec((RecordCodecBuilder.Instance)instance);
        return instance.group((App)ResourceLocation.CODEC.fieldOf("structure").forGetter(o -> o.structureName), placement.t1(), (App)TaggedExclusionZone.CODEC.optionalFieldOf("exclusion_zone").forGetter(o -> o.taggedExclusionZone), (App)Codec.intRange((int)0, (int)4096).fieldOf("spacing").forGetter(GridStructurePlacement::spacing), (App)Codec.intRange((int)0, (int)4096).fieldOf("offset").forGetter(GridStructurePlacement::offset), placement.t3(), placement.t4(), (App)Codec.BOOL.fieldOf("allowed_near_spawn").forGetter(GridStructurePlacement::allowedNearSpawn)).apply((Applicative)instance, GridStructurePlacement::new);
    });
    private final ResourceLocation structureName;
    private final float probability;
    private final int seed;
    private final int spacing;
    private final int offset;
    private final boolean allowedNearSpawn;
    private final Optional<TaggedExclusionZone> taggedExclusionZone;

    private GridStructurePlacement(ResourceLocation structureName, Vec3i locateOffset, Optional<TaggedExclusionZone> exclusionZone, int spacing, int offset, float probability, int seed, boolean allowedNearSpawn) {
        super(locateOffset, StructurePlacement.FrequencyReductionMethod.DEFAULT, probability, seed, Optional.empty());
        this.structureName = structureName;
        this.probability = probability;
        this.seed = seed;
        this.spacing = spacing;
        this.offset = Mth.clamp((int)offset, (int)0, (int)spacing);
        this.allowedNearSpawn = allowedNearSpawn;
        this.taggedExclusionZone = exclusionZone;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(int spacing, float probability) {
        return GridStructurePlacement.builder().spacing(spacing).offset(spacing - 1).probability(probability);
    }

    public static Builder builder(int spacing, int offset, float probability) {
        return GridStructurePlacement.builder(spacing, probability).offset(offset);
    }

    public boolean isStructureChunk(ChunkGeneratorStructureState chunkGenState, int chunkX, int chunkZ) {
        return this.isPlacementChunk(chunkGenState, chunkX, chunkZ) && (!this.taggedExclusionZone.isPresent() || !this.taggedExclusionZone.get().isPlacementForbidden(chunkGenState, chunkX, chunkZ));
    }

    protected boolean isPlacementChunk(ChunkGeneratorStructureState chunkGenState, int chunkX, int chunkZ) {
        Optional<ChunkPos> opGenPos = this.getFeatureChunk(chunkGenState, chunkX, chunkZ);
        if (opGenPos.isPresent()) {
            ChunkPos genPos = opGenPos.get();
            return genPos.x == chunkX && genPos.z == chunkZ;
        }
        return false;
    }

    public Optional<ChunkPos> getFeatureChunk(ChunkGeneratorStructureState chunkGenState, int chunkX, int chunkZ) {
        if (this.frequency() > 0.0f) {
            long levelSeed = chunkGenState.getLevelSeed();
            int spacing = this.spacing();
            int gridX = (int)Math.floor((float)chunkX / (float)spacing) * spacing;
            int gridZ = (int)Math.floor((float)chunkZ / (float)spacing) * spacing;
            int offset = this.offset() + 1;
            WorldgenRandom rand = new WorldgenRandom((RandomSource)new LegacyRandomSource(levelSeed));
            rand.setLargeFeatureWithSalt(levelSeed, gridX, gridZ, this.salt());
            ChunkPos genPos = new ChunkPos(gridX + rand.nextInt(offset), gridZ + rand.nextInt(offset));
            if ((this.allowedNearSpawn() || !this.isNearSpawn(genPos)) && (this.frequency() >= 1.0f || this.probabilityTest(genPos, levelSeed))) {
                return Optional.of(genPos);
            }
        }
        return Optional.empty();
    }

    protected boolean isNearSpawn(ChunkPos genPos) {
        int range = 12;
        return genPos.x < range && genPos.x > -range && genPos.z < range && genPos.z > -range;
    }

    protected boolean probabilityTest(ChunkPos genPos, long levelSeed) {
        WorldgenRandom rand = new WorldgenRandom((RandomSource)new LegacyRandomSource(levelSeed));
        rand.setLargeFeatureWithSalt(levelSeed, genPos.x, genPos.z, this.salt());
        return rand.nextFloat() < this.frequency();
    }

    protected float frequency() {
        return this.probability;
    }

    protected int salt() {
        return this.seed;
    }

    protected int spacing() {
        return this.spacing;
    }

    protected int offset() {
        return this.offset;
    }

    protected boolean allowedNearSpawn() {
        return this.allowedNearSpawn;
    }

    public StructurePlacementType<?> type() {
        return SGRegistry.StructurePlacementTypes.GRID_PLACEMENT.get();
    }

    @Nullable
    @Internal
    private Pair<BlockPos, Holder<Structure>> findNearest(Set<Holder<Structure>> structures, ServerLevel level, ChunkGeneratorStructureState chunkGenState, StructureManager structureManager, int x, int z, int radius, boolean skipKnown) {
        int spacing = this.spacing();
        for (int dx = -radius; dx <= radius; ++dx) {
            boolean flag = dx == -radius || dx == radius;
            for (int dz = -radius; dz <= radius; ++dz) {
                int cz;
                int cx;
                Optional<ChunkPos> opGenPos;
                boolean flag1;
                boolean bl = flag1 = dz == -radius || dz == radius;
                if (!flag && !flag1 || !(opGenPos = this.getFeatureChunk(chunkGenState, cx = x + spacing * dx, cz = z + spacing * dz)).isPresent()) continue;
                ChunkPos genPos = opGenPos.get();
                for (Holder<Structure> holder : structures) {
                    StructureCheckResult result = structureManager.checkStructurePresence(genPos, (Structure)holder.value(), (StructurePlacement)this, skipKnown);
                    if (result == StructureCheckResult.START_NOT_PRESENT) continue;
                    if (!skipKnown && result == StructureCheckResult.START_PRESENT) {
                        return Pair.of((Object)this.getLocatePos(genPos), holder);
                    }
                    ChunkAccess chunkAccess = level.getChunk(genPos.x, genPos.z, ChunkStatus.STRUCTURE_STARTS);
                    StructureStart start = structureManager.getStartForStructure(SectionPos.bottomOf((ChunkAccess)chunkAccess), (Structure)holder.value(), (StructureAccess)chunkAccess);
                    if (start == null || !start.isValid()) continue;
                    if (skipKnown) {
                        if (!start.canBeReferenced()) continue;
                        structureManager.addReference(start);
                        return Pair.of((Object)this.getLocatePos(start.getChunkPos()), holder);
                    }
                    return Pair.of((Object)this.getLocatePos(start.getChunkPos()), holder);
                }
            }
        }
        return null;
    }

    @Nullable
    @Internal
    public static Pair<BlockPos, Holder<Structure>> findNearesStructure(ServerLevel level, HolderSet<Structure> structureHolders, BlockPos origin, int radius, boolean skipKnown, ChunkGenerator chunkGen, @Nullable Pair<BlockPos, Holder<Structure>> oldNearest) {
        Set biomeSourceBiomes;
        Set structureBiomes = structureHolders.stream().flatMap(csf -> ((Structure)csf.value()).biomes().stream()).collect(Collectors.toSet());
        if (!structureBiomes.isEmpty() && !Collections.disjoint(biomeSourceBiomes = chunkGen.getBiomeSource().possibleBiomes(), structureBiomes)) {
            Pair<BlockPos, Holder<Structure>> newNearest = null;
            Object2ObjectArrayMap structuresByPlacement = new Object2ObjectArrayMap();
            ChunkGeneratorStructureState chunkGenState = level.getChunkSource().getGeneratorState();
            for (Holder holder : structureHolders) {
                if (biomeSourceBiomes.stream().noneMatch(arg_0 -> ((HolderSet)((Structure)holder.value()).biomes()).contains(arg_0))) continue;
                for (StructurePlacement structureplacement : chunkGenState.getPlacementsForStructure(holder)) {
                    structuresByPlacement.computeIfAbsent(structureplacement, placement -> new ObjectArraySet()).add(holder);
                }
            }
            block2: for (Map.Entry entry : structuresByPlacement.entrySet()) {
                StructurePlacement placement2 = (StructurePlacement)entry.getKey();
                if (!(placement2 instanceof GridStructurePlacement)) continue;
                GridStructurePlacement gelPlacement = (GridStructurePlacement)placement2;
                int originCX = SectionPos.blockToSectionCoord((int)origin.getX());
                int originCZ = SectionPos.blockToSectionCoord((int)origin.getZ());
                for (int r = 0; r <= radius; ++r) {
                    Pair<BlockPos, Holder<Structure>> found = gelPlacement.findNearest((Set)entry.getValue(), level, chunkGenState, level.structureManager(), originCX, originCZ, r, skipKnown);
                    if (found == null) continue;
                    newNearest = found;
                    continue block2;
                }
            }
            if (oldNearest == null) {
                return newNearest;
            }
            if (newNearest != null) {
                double oldDist = origin.distSqr((Vec3i)oldNearest.getFirst());
                double newDist = origin.distSqr((Vec3i)newNearest.getFirst());
                if (newDist < oldDist) {
                    return newNearest;
                }
            }
        }
        return oldNearest;
    }

    public static class Builder {
        private Vec3i locateOffset = Vec3i.ZERO;
        private float probability = 1.0f;
        private Optional<TaggedExclusionZone> exclusionZone = Optional.empty();
        private int spacing = 16;
        private int offset = 16;
        private boolean allowedNearSpawn = false;

        private Builder() {
        }

        public Builder locateOffset(Vec3i locateOffset) {
            this.locateOffset = locateOffset;
            return this;
        }

        public Builder exclusionZone(TaggedExclusionZone exclusionZone) {
            this.exclusionZone = Optional.of(exclusionZone);
            return this;
        }

        public Builder spacing(int spacing) {
            this.spacing = spacing;
            return this;
        }

        public Builder offset(int offset) {
            this.offset = offset;
            return this;
        }

        public Builder probability(float probability) {
            this.probability = probability;
            return this;
        }

        public Builder allowedNearSpawn(boolean allowedNearSpawn) {
            this.allowedNearSpawn = allowedNearSpawn;
            return this;
        }

        public GridStructurePlacement build(ResourceLocation structureName) {
            return new GridStructurePlacement(structureName, this.locateOffset, this.exclusionZone, this.spacing, this.offset, this.probability, Math.abs(structureName.toString().hashCode()), this.allowedNearSpawn);
        }

        public GridStructurePlacement build(StructureRegistrar<?> structureRegistrar) {
            return this.build(structureRegistrar.getRegistryName());
        }
    }

    public record TaggedExclusionZone(HolderSet<Structure> structures, int radius) {
        private static final Codec<TaggedExclusionZone> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.STRUCTURE).fieldOf("structures").forGetter(TaggedExclusionZone::structures), (App)Codec.intRange((int)1, (int)16).fieldOf("radius").forGetter(TaggedExclusionZone::radius)).apply((Applicative)instance, TaggedExclusionZone::new));

        boolean isPlacementForbidden(ChunkGeneratorStructureState chunkGenState, int chunkX, int chunkZ) {
            return StructureAccessHelper.hasStructureChunkInRange(chunkGenState, this.structures, new ChunkPos(chunkX, chunkZ), this.radius);
        }
    }
}

