/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.structure;

import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public interface IColoredBoundingBox {
    public static final int WHITE = IColoredBoundingBox.toRgbInt(255, 255, 255);
    public static final int RED = IColoredBoundingBox.toRgbInt(255, 0, 0);
    public static final int ORANGE = IColoredBoundingBox.toRgbInt(255, 106, 0);
    public static final int YELLOW = IColoredBoundingBox.toRgbInt(255, 216, 0);
    public static final int GREEN = IColoredBoundingBox.toRgbInt(0, 255, 0);
    public static final int BLUE = IColoredBoundingBox.toRgbInt(0, 0, 255);
    public static final int PURPLE = IColoredBoundingBox.toRgbInt(110, 7, 255);

    public int getBoundingBoxColor();

    public static int getBoundingBoxColor(StructurePiece piece) {
        PoolElementStructurePiece poolPiece;
        if (piece instanceof IColoredBoundingBox) {
            IColoredBoundingBox colored = (IColoredBoundingBox)piece;
            return colored.getBoundingBoxColor();
        }
        return piece instanceof PoolElementStructurePiece && (poolPiece = (PoolElementStructurePiece)piece).getElement().getProjection() == StructureTemplatePool.Projection.TERRAIN_MATCHING ? BLUE : GREEN;
    }

    public static int toRgbInt(int r, int g, int b) {
        int rgb = r;
        rgb = rgb << 8 | g;
        return rgb << 8 | b;
    }

    public static int toRgbInt(float r, float g, float b) {
        return IColoredBoundingBox.toRgbInt((int)(255.0f * r), (int)(255.0f * g), (int)(255.0f * b));
    }
}

