/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.structure.jigsaw;

import com.legacy.structure_gel.api.structure.base.IModifyState;
import com.legacy.structure_gel.api.structure.jigsaw.IPieceFactory;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawAccessHelper;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawCapability;
import com.legacy.structure_gel.core.StructureGelMod;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.neoforged.neoforge.common.util.Lazy;

public abstract class ExtendedJigsawStructurePiece
extends PoolElementStructurePiece
implements IModifyState {
    private static final String CAP_KEY = "capability";
    private Optional<JigsawCapability> jigsawCapability = Optional.empty();

    public ExtendedJigsawStructurePiece(IPieceFactory.Context context) {
        super(context.structureManager(), context.poolElement(), context.pos(), context.groundLevelDelta(), context.rotation(), context.bounds(), context.liquidSettings());
        this.setStructurePieceType(this.getType());
        this.jigsawCapability = context.jigsawCapability();
    }

    public ExtendedJigsawStructurePiece(StructurePieceSerializationContext context, CompoundTag nbt) {
        super(context, nbt);
        this.setStructurePieceType(this.getType());
        this.loadCapability(context, nbt);
    }

    protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag nbt) {
        super.addAdditionalSaveData(context, nbt);
        this.saveCapability(context, nbt);
    }

    private void loadCapability(StructurePieceSerializationContext context, CompoundTag nbt) {
        Optional result;
        if (nbt.contains(this.getCapabilityKey(), 10) && (result = JigsawCapability.CODEC.decode((DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)context.registryAccess()), (Object)nbt.getCompound(CAP_KEY)).result()).isPresent()) {
            JigsawCapability cap = (JigsawCapability)((Pair)result.get()).getFirst();
            this.attachCapability(Optional.ofNullable(cap));
        }
    }

    private void saveCapability(StructurePieceSerializationContext context, CompoundTag nbt) {
        Optional result;
        if (this.jigsawCapability.isPresent() && (result = JigsawCapability.CODEC.encodeStart((DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)context.registryAccess()), (Object)this.jigsawCapability.get()).result()).isPresent() && result.get() instanceof CompoundTag) {
            Tag tag = (Tag)result.get();
            nbt.put(this.getCapabilityKey(), tag);
        }
    }

    protected String getCapabilityKey() {
        return CAP_KEY;
    }

    public abstract void handleDataMarker(String var1, BlockPos var2, ServerLevelAccessor var3, RandomSource var4, BoundingBox var5);

    public abstract StructurePieceType getType();

    private void setStructurePieceType(StructurePieceType structurePieceType) {
        this.type = structurePieceType;
    }

    private final void attachCapability(@Nonnull Optional<JigsawCapability> jigsawCapability) {
        Objects.requireNonNull(jigsawCapability);
        this.jigsawCapability = jigsawCapability;
    }

    public Optional<JigsawCapability> getCapability() {
        return this.jigsawCapability;
    }

    public <C extends JigsawCapability> Optional<C> getCapability(Class<C> capabilityClass) {
        return this.getCapability().map(c -> capabilityClass.isInstance(c) ? (JigsawCapability)capabilityClass.cast(c) : null);
    }

    protected <C extends JigsawCapability, T> Lazy<T> getCapabilityValue(Class<C> capabilityClass, Function<C, T> getter, Supplier<T> errorFallback) {
        return Lazy.of(() -> this.getCapability(capabilityClass).map(getter).orElseGet(() -> ExtendedJigsawStructurePiece.lambda$getCapabilityValue$1(capabilityClass, (Supplier)errorFallback)));
    }

    @Override
    @Nullable
    public BlockState modifyState(ServerLevelAccessor level, RandomSource rand, BlockPos pos, BlockState originalState) {
        return originalState;
    }

    public <T extends Entity> T createEntity(EntityType<T> entityType, ServerLevelAccessor level, BlockPos pos, Rotation rotation) {
        Entity entity = entityType.create((Level)level.getLevel(), EntitySpawnReason.STRUCTURE);
        entity.moveTo((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, rotation.rotate(Direction.SOUTH).toYRot(), 0.0f);
        return (T)entity;
    }

    public ResourceLocation getLocation() {
        StructurePoolElement structurePoolElement = this.element;
        if (structurePoolElement instanceof SinglePoolElement) {
            SinglePoolElement singleElement = (SinglePoolElement)structurePoolElement;
            return JigsawAccessHelper.getSingleJigsawPieceLocation(singleElement);
        }
        return ResourceLocation.parse((String)"empty");
    }

    public StructureTemplateManager getStructureManager() {
        return this.structureTemplateManager;
    }

    public Vec3i getSize() {
        Optional optional = this.getStructureManager().get(this.getLocation());
        return optional.isPresent() ? ((StructureTemplate)optional.get()).getSize() : Vec3i.ZERO;
    }

    public void setAir(LevelAccessor level, BlockPos pos) {
        level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
    }

    public void extendDown(LevelAccessor level, BlockState state, BoundingBox bounds, Rotation rotation, RandomSource rand) {
        this.extendDown(level, (RandomSource random) -> state, bounds, rotation, rand);
    }

    public void extendDown(LevelAccessor level, Function<RandomSource, BlockState> randStateGetter, BoundingBox bounds, Rotation rotation, RandomSource rand) {
        int offsetX = rotation == Rotation.CLOCKWISE_180 || this.rotation == Rotation.CLOCKWISE_90 ? -(this.getSize().getX() - 1) : 0;
        int offsetZ = rotation == Rotation.CLOCKWISE_180 || this.rotation == Rotation.COUNTERCLOCKWISE_90 ? -(this.getSize().getZ() - 1) : 0;
        for (int x = 0; x < 13; ++x) {
            for (int z = 0; z < 13; ++z) {
                if (level.getBlockState(this.position.offset(x + offsetX, 0, z + offsetZ)).isAir()) continue;
                int offsetY = -1;
                while ((level.isEmptyBlock(this.position.offset(x + offsetX, offsetY, z + offsetZ)) || level.getBlockState(this.position.offset(x + offsetX, offsetY, z + offsetZ)).liquid()) && this.position.getY() + offsetY > 0) {
                    level.setBlock(this.position.offset(x + offsetX, offsetY, z + offsetZ), randStateGetter.apply(rand), 2);
                    --offsetY;
                }
            }
        }
    }

    private static /* synthetic */ Object lambda$getCapabilityValue$1(Class capabilityClass, Supplier errorFallback) {
        StructureGelMod.LOGGER.warn("The capability for a jigsaw piece did not match the expected class: " + String.valueOf(capabilityClass), new Object[0]);
        return errorFallback.get();
    }
}

