/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.structure.jigsaw;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawRegistryHelper;
import com.legacy.structure_gel.core.structure.jigsaw.GelSinglePoolElement;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class JigsawPoolBuilder {
    private final JigsawRegistryHelper jigsawRegistryHelper;
    private Map<ResourceLocation, Integer> names = ImmutableMap.of();
    private int weight = 1;
    private ResourceKey<StructureProcessorList> processors = ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)ResourceLocation.parse((String)"empty"));
    private Optional<LiquidSettings> overrideLiquidSettings = Optional.empty();

    public JigsawPoolBuilder(JigsawRegistryHelper jigsawRegistryHelper) {
        this.jigsawRegistryHelper = jigsawRegistryHelper;
    }

    public JigsawPoolBuilder names(Map<String, Integer> nameMap) {
        return this.namesR(nameMap.entrySet().stream().collect(Collectors.toMap(k -> this.jigsawRegistryHelper.locatePiece((String)k.getKey()), v -> (Integer)v.getValue())));
    }

    public JigsawPoolBuilder namesR(Map<ResourceLocation, Integer> nameMap) {
        this.names = nameMap;
        return this;
    }

    public JigsawPoolBuilder names(Collection<String> names) {
        return this.namesR(names.stream().collect(Collectors.toMap(k -> this.jigsawRegistryHelper.locatePiece((String)k), v -> this.weight)));
    }

    public JigsawPoolBuilder namesR(Collection<ResourceLocation> names) {
        return this.namesR(names.stream().collect(Collectors.toMap(k -> k, v -> this.weight)));
    }

    public JigsawPoolBuilder names(String ... names) {
        return this.names(Arrays.asList(names));
    }

    public JigsawPoolBuilder namesR(ResourceLocation ... names) {
        return this.namesR(Arrays.asList(names));
    }

    public JigsawPoolBuilder weight(int weight) {
        this.weight = weight;
        return this.namesR(this.names.keySet());
    }

    public JigsawPoolBuilder processors(ResourceKey<StructureProcessorList> processors) {
        this.processors = processors;
        return this;
    }

    public JigsawPoolBuilder maintainWater(boolean maintainWater) {
        return this.overrideLiquidSettings(maintainWater ? LiquidSettings.APPLY_WATERLOGGING : LiquidSettings.IGNORE_WATERLOGGING);
    }

    public JigsawPoolBuilder overrideLiquidSettings(LiquidSettings settings) {
        return this.overrideLiquidSettings(Optional.ofNullable(settings));
    }

    public JigsawPoolBuilder overrideLiquidSettings(Optional<LiquidSettings> settings) {
        this.overrideLiquidSettings = settings;
        return this;
    }

    public ImmutableList<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>> build() {
        ArrayList jigsawList = new ArrayList();
        this.names.forEach((rl, i) -> jigsawList.add(Pair.of(JigsawPoolBuilder.createGelPiece(rl, (Holder<StructureProcessorList>)this.jigsawRegistryHelper.processorLookup.getOrThrow(this.processors), this.overrideLiquidSettings, false), (Object)i)));
        return ImmutableList.copyOf(jigsawList);
    }

    public static ImmutableList<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>> build(Map<StructurePoolElement, Integer> pieceMap) {
        ArrayList jigsawList = new ArrayList();
        pieceMap.forEach((jp, i) -> jigsawList.add(Pair.of(placement -> jp, (Object)i)));
        return ImmutableList.copyOf(jigsawList);
    }

    public static ImmutableList<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>> build(StructurePoolElement ... pieces) {
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        for (StructurePoolElement p : pieces) {
            pairs.add(Pair.of(placement -> p, (Object)1));
        }
        return ImmutableList.copyOf(pairs);
    }

    public static ImmutableList<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>> collect(JigsawPoolBuilder ... builders) {
        return JigsawPoolBuilder.collect(Arrays.asList(builders));
    }

    public static ImmutableList<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>> collect(List<JigsawPoolBuilder> builders) {
        ArrayList<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>> pairs = new ArrayList<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>();
        for (JigsawPoolBuilder builder : builders) {
            pairs.addAll((Collection<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)builder.build());
        }
        return ImmutableList.copyOf(pairs);
    }

    public JigsawPoolBuilder clone() {
        return new JigsawPoolBuilder(this.jigsawRegistryHelper).weight(this.weight).namesR(this.names).overrideLiquidSettings(this.overrideLiquidSettings).processors(this.processors);
    }

    private static Function<StructureTemplatePool.Projection, GelSinglePoolElement> createGelPiece(ResourceLocation name, Holder<StructureProcessorList> processors, Optional<LiquidSettings> overrideLiquidSettings, boolean ignoreEntities) {
        return placement -> new GelSinglePoolElement((Either<ResourceLocation, StructureTemplate>)Either.left((Object)name), processors, (StructureTemplatePool.Projection)placement, overrideLiquidSettings, ignoreEntities);
    }
}

