/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.util;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeUtil {
    public static final List<Direction> HORIZONTAL_DIRS = List.of(Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST);

    public static Map<Direction, VoxelShape> createRotations(VoxelShape northFacingShape, Set<Direction> validDirections) {
        EnumMap<Direction, VoxelShape> shapes = new EnumMap<Direction, VoxelShape>(Direction.class);
        boolean up = validDirections.contains(Direction.UP);
        boolean down = validDirections.contains(Direction.DOWN);
        if (up || down) {
            VoxelShape[] verticalShapes = new VoxelShape[]{Shapes.empty(), Shapes.empty()};
            northFacingShape.forAllBoxes((x, y, z, a, b, c) -> {
                if (up) {
                    verticalShapes[0] = Shapes.or((VoxelShape)verticalShapes[0], (VoxelShape)Shapes.box((double)x, (double)(1.0 - c), (double)y, (double)a, (double)(1.0 - z), (double)b));
                }
                if (down) {
                    verticalShapes[1] = Shapes.or((VoxelShape)verticalShapes[1], (VoxelShape)Shapes.box((double)x, (double)z, (double)y, (double)a, (double)c, (double)b));
                }
            });
            if (up) {
                shapes.put(Direction.UP, verticalShapes[0]);
            }
            if (down) {
                shapes.put(Direction.DOWN, VoxelShapeUtil.mirror(verticalShapes[1], Direction.Axis.Z));
            }
        }
        for (Direction dir : HORIZONTAL_DIRS) {
            if (!validDirections.contains(dir)) continue;
            shapes.put(dir, VoxelShapeUtil.rotate(northFacingShape, dir));
        }
        return shapes;
    }

    public static Map<Direction, VoxelShape> createRotations(VoxelShape northFacingShape, Direction ... validDirections) {
        return VoxelShapeUtil.createRotations(northFacingShape, Set.of(validDirections));
    }

    public static Map<Direction, VoxelShape> createRotations(VoxelShape northFacingShape) {
        return VoxelShapeUtil.createRotations(northFacingShape, Direction.values());
    }

    public static VoxelShape rotate(VoxelShape shape, Direction newDir) {
        return VoxelShapeUtil.rotate(shape, Direction.NORTH, newDir);
    }

    public static VoxelShape rotate(VoxelShape shape, Direction originalDir, Direction newDir) {
        if (originalDir != newDir) {
            VoxelShape[] newShape = new VoxelShape[]{Shapes.empty()};
            shape.forAllBoxes((x, y, z, a, b, c) -> {
                double i = 1.0 - c;
                double j = 1.0 - z;
                newShape[0] = Shapes.or((VoxelShape)newShape[0], (VoxelShape)Shapes.box((double)Math.min(i, j), (double)y, (double)x, (double)Math.max(i, j), (double)b, (double)a));
            });
            return VoxelShapeUtil.rotate(newShape[0], originalDir.getClockWise(), newDir);
        }
        return shape;
    }

    public static VoxelShape mirror(VoxelShape shape, Direction facingProperty) {
        return VoxelShapeUtil.mirror(shape, facingProperty.getAxis());
    }

    public static VoxelShape mirror(VoxelShape shape, Mirror mirror) {
        return VoxelShapeUtil.mirror(shape, mirror == Mirror.FRONT_BACK ? Direction.Axis.X : Direction.Axis.Z);
    }

    public static VoxelShape mirror(VoxelShape shape, Direction.Axis axis) {
        VoxelShape[] newShape = new VoxelShape[]{Shapes.empty()};
        switch (axis) {
            case X: {
                shape.forAllBoxes((x, y, z, a, b, c) -> {
                    double i = 1.0 - x;
                    double j = 1.0 - a;
                    newShape[0] = Shapes.or((VoxelShape)newShape[0], (VoxelShape)Shapes.box((double)Math.min(i, j), (double)y, (double)z, (double)Math.max(i, j), (double)b, (double)c));
                });
                break;
            }
            case Z: {
                shape.forAllBoxes((x, y, z, a, b, c) -> {
                    double i = 1.0 - z;
                    double j = 1.0 - c;
                    newShape[0] = Shapes.or((VoxelShape)newShape[0], (VoxelShape)Shapes.box((double)x, (double)y, (double)Math.min(i, j), (double)a, (double)b, (double)Math.max(i, j)));
                });
                break;
            }
            case Y: {
                shape.forAllBoxes((x, y, z, a, b, c) -> {
                    double i = 1.0 - y;
                    double j = 1.0 - b;
                    newShape[0] = Shapes.or((VoxelShape)newShape[0], (VoxelShape)Shapes.box((double)x, (double)Math.min(i, j), (double)z, (double)a, (double)Math.max(i, j), (double)c));
                });
            }
        }
        return newShape[0];
    }
}

