/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.block;

import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.block_entity.DataHandlerBlockEntity;
import com.legacy.structure_gel.core.util.SGText;
import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DataHandlerBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock,
GameMasterBlock {
    public static final MapCodec<DataHandlerBlock> CODEC = DataHandlerBlock.simpleCodec(DataHandlerBlock::new);
    public static final EnumProperty<Direction> FACING = BlockStateProperties.FACING;
    public static final EnumProperty<Mirror> MIRROR = EnumProperty.create((String)"mirror", Mirror.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty CONNECT_TO_BLOCKS = BooleanProperty.create((String)"connect_to_blocks");

    public DataHandlerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(MIRROR, (Comparable)Mirror.NONE)).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)CONNECT_TO_BLOCKS, (Comparable)Boolean.valueOf(true)));
    }

    protected MapCodec<? extends Block> codec() {
        return CODEC;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean copyData) {
        ItemStack stack = new ItemStack((ItemLike)this);
        HashMap<String, String> props = new HashMap<String, String>();
        for (Property property : List.of(CONNECT_TO_BLOCKS, WATERLOGGED)) {
            BlockState defaultState = state.getBlock().defaultBlockState();
            Comparable val = state.getValue(property);
            if (defaultState.getValue(property).equals(val)) continue;
            props.put(property.getName(), property.getName(val));
        }
        if (!props.isEmpty()) {
            stack.set(DataComponents.BLOCK_STATE, (Object)new BlockItemStateProperties(props));
        }
        return stack;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DataHandlerBlockEntity(pos, state);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DataHandlerBlockEntity) {
            DataHandlerBlockEntity dataHandler = (DataHandlerBlockEntity)blockEntity;
            if (player.canUseGameMasterBlocks()) {
                boolean waterlogged = (Boolean)state.getValue((Property)WATERLOGGED);
                if (stack.is(Items.WATER_BUCKET) && !waterlogged || stack.is(Items.BUCKET) && waterlogged) {
                    return InteractionResult.PASS;
                }
                if (level.isClientSide) {
                    StructureGelMod.proxy.openDataHandlerScreen(dataHandler);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getNearestLookingDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        if (stack.has(DataComponents.CUSTOM_NAME) && (blockEntity = level.getBlockEntity(pos)) instanceof DataHandlerBlockEntity) {
            DataHandlerBlockEntity dataHandler = (DataHandlerBlockEntity)blockEntity;
            dataHandler.setCustomName(stack.getCustomName());
        }
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(true) : Fluids.EMPTY.defaultFluidState();
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource rand) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            tickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return state;
    }

    public VoxelShape getOcclusionShape(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Shapes.empty() : Shapes.block();
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)rotation.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)this.rotate(state, mirror.getRotation((Direction)state.getValue(FACING))).setValue(MIRROR, (Comparable)mirror);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{MIRROR, FACING, WATERLOGGED, CONNECT_TO_BLOCKS});
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lore, TooltipFlag showAdvanced) {
        if (Screen.hasShiftDown()) {
            lore.add((Component)Component.translatable((String)"info.structure_gel.data_handler_description").withStyle(ChatFormatting.GRAY));
        } else {
            CompoundTag beTag;
            lore.add(SGText.applyKeybindFilter((Component)Component.translatable((String)"info.structure_gel.hold_shift")));
            CustomData data = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
            if (data != null && (beTag = data.copyTag()).contains("handlers", 9)) {
                lore.add((Component)SGText.NEW_LINE);
                List handlers = DataHandlerBlockEntity.loadAllHandlers(beTag).unwrap();
                int size = handlers.size();
                for (int i = 0; i < size; ++i) {
                    DataHandlerBlockEntity.RawHandler handler;
                    ResourceLocation type;
                    if (i > 0) {
                        lore.add((Component)SGText.NEW_LINE);
                    }
                    if ((type = (handler = (DataHandlerBlockEntity.RawHandler)handlers.get(i)).typeName()).getPath().isEmpty()) continue;
                    lore.add((Component)Component.literal((String)type.toString()).withStyle(ChatFormatting.GRAY));
                    LinkedHashMap<String, String> dataEntries = handler.dataEntries();
                    if (size > 1) {
                        lore.add((Component)SGText.BULLET_POINT.copy().withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"info.structure_gel.building_tool.property.weight").withStyle(SGText.VALUE_LABEL_STYLE)).append((Component)Component.literal((String)(": " + handler.getWeight().asInt()))));
                    }
                    for (Map.Entry<String, String> entry : dataEntries.entrySet()) {
                        String value;
                        String key = entry.getKey();
                        String translationKey = "gui.structure_gel.data_handler." + String.valueOf(type) + "." + key + ".label";
                        MutableComponent propertyLabel = Component.translatable((String)translationKey);
                        if (propertyLabel.getString().equals(translationKey)) {
                            propertyLabel = Component.literal((String)key);
                        }
                        if ((value = entry.getValue()).isEmpty()) continue;
                        lore.add((Component)SGText.BULLET_POINT.copy().withStyle(ChatFormatting.GRAY).append((Component)propertyLabel.withStyle(SGText.VALUE_LABEL_STYLE)).append((Component)Component.literal((String)(": " + value))));
                    }
                }
            }
        }
    }
}

