/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.block;

import com.legacy.structure_gel.api.block.gel.StructureGelBlock;
import com.legacy.structure_gel.api.data.tags.SGTags;
import com.legacy.structure_gel.core.SGConfig;
import com.legacy.structure_gel.core.block_entity.GelSpreaderBlockEntity;
import com.legacy.structure_gel.core.registry.SGRegistry;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class GelSpreaderBlock
extends BaseEntityBlock {
    public static final MapCodec<GelSpreaderBlock> CODEC = GelSpreaderBlock.simpleCodec(GelSpreaderBlock::new);
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;
    public static final BooleanProperty DECAY = StructureGelBlock.DECAY;

    public GelSpreaderBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(AXIS, (Comparable)Direction.Axis.Y)).setValue((Property)DECAY, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS, DECAY});
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)DECAY)).booleanValue()) {
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)context.getNearestLookingDirection().getAxis());
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return SGRegistry.BlockEntities.GEL_SPREADER.get().create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : GelSpreaderBlock.createTickerHelper(blockEntityType, SGRegistry.BlockEntities.GEL_SPREADER.get(), GelSpreaderBlockEntity::serverTick);
    }

    public InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.isCreative() && stack.is(Items.GUNPOWDER)) {
            StructureGelBlock.scheduleRemoval(level, pos, state);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (SGConfig.COMMON.advancedGelBehavior()) {
            Player player;
            EntityCollisionContext eContext;
            Entity entity;
            if (context == CollisionContext.empty() || context instanceof EntityCollisionContext && (entity = (eContext = (EntityCollisionContext)context).getEntity()) instanceof Player && ((player = (Player)entity).isShiftKeyDown() || player.isHolding(stack -> stack.is(SGTags.ItemTags.GEL_INTERACTABLE)) || !player.isCreative())) {
                return Shapes.block();
            }
            return Shapes.empty();
        }
        return Shapes.block();
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        if (SGConfig.COMMON.advancedGelBehavior()) {
            Player player = context.getPlayer();
            return player == null || !player.isShiftKeyDown() && !context.getItemInHand().is(SGTags.ItemTags.GEL);
        }
        return false;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean skipRendering(BlockState state, BlockState adjacentState, Direction side) {
        return adjacentState.is(SGTags.BlockTags.GEL) || adjacentState.is((Block)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }
}

