/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.capability.level;

import com.legacy.structure_gel.core.SGConfig;
import com.legacy.structure_gel.core.capability.level.BuildingToolWorldData;
import com.legacy.structure_gel.core.item.building_tool.ActionHistory;
import com.legacy.structure_gel.core.item.building_tool.CapturedBlocks;
import com.legacy.structure_gel.core.network.SGPacketHandler;
import com.legacy.structure_gel.core.network.s_to_c.EditClipboardPacket;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.saveddata.SavedData;

public class BuildingToolPlayerData
extends SavedData {
    final ServerLevel level;
    final String playerName;
    final ActionHistory actionHistory;
    final Object2ObjectLinkedOpenHashMap<BoundingBox, CapturedBlocks> clipboard;
    private static final String PLAYER_KEY = "player";
    private static final String ACTION_HISTORY_KEY = "action_history";
    private static final String CLIPBOARD_KEY = "clipboard";
    private static final String BOUNDS_KEY = "bounds";
    private static final String CAPTURED_KEY = "captured";

    private BuildingToolPlayerData(ServerLevel level, String playerName) {
        this(level, playerName, new ActionHistory(playerName), (Object2ObjectLinkedOpenHashMap<BoundingBox, CapturedBlocks>)new Object2ObjectLinkedOpenHashMap());
    }

    private BuildingToolPlayerData(ServerLevel level, String playerName, ActionHistory actionHistory, Object2ObjectLinkedOpenHashMap<BoundingBox, CapturedBlocks> clipboard) {
        this.level = level;
        this.playerName = playerName;
        this.actionHistory = actionHistory;
        this.clipboard = clipboard;
    }

    public static String getID(String playerName) {
        return "structure_gel/building_tool/players/" + playerName;
    }

    private static SavedData.Factory<BuildingToolPlayerData> factory(ServerLevel level, String playerName) {
        return new SavedData.Factory(() -> new BuildingToolPlayerData(level, playerName), (tag, lookup) -> BuildingToolPlayerData.load(level, tag, lookup));
    }

    public static BuildingToolPlayerData get(ServerLevel level, String playerName) {
        BuildingToolPlayerData ret = (BuildingToolPlayerData)level.getDataStorage().computeIfAbsent(BuildingToolPlayerData.factory(level, playerName), BuildingToolPlayerData.getID(playerName));
        BuildingToolWorldData.get(level).addPlayer(playerName);
        return ret;
    }

    public Player getPlayer(Level level) {
        for (Player player : level.players()) {
            if (!player.getGameProfile().getName().equals(this.playerName)) continue;
            return player;
        }
        return null;
    }

    public ActionHistory getActionHistory() {
        return this.actionHistory;
    }

    @Nullable
    public CapturedBlocks getCapturedBlocks(BoundingBox bounds, String owner) {
        CapturedBlocks ret = (CapturedBlocks)this.clipboard.getAndMoveToFirst((Object)bounds);
        if (ret != null) {
            this.setDirty();
        }
        return ret;
    }

    public void addToClipboard(BoundingBox bounds, CapturedBlocks captured) {
        Player player;
        this.clipboard.putAndMoveToFirst((Object)bounds, (Object)captured);
        BoundingBox removeKey = BoundingBox.infinite();
        if (this.clipboard.size() > SGConfig.COMMON.getBuildingToolMaxClipboard()) {
            removeKey = (BoundingBox)this.clipboard.lastKey();
            this.clipboard.removeLast();
        }
        if ((player = this.getPlayer((Level)this.level)) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            SGPacketHandler.sendToClient(new EditClipboardPacket(player2.getGameProfile().getName(), bounds, captured, removeKey), player2);
        }
        this.setDirty();
    }

    public void addToClipboardDirect(BoundingBox bounds, CapturedBlocks captured, String owner) {
        if (!owner.equals(this.playerName)) {
            return;
        }
        this.clipboard.putAndMoveToFirst((Object)bounds, (Object)captured);
        this.setDirty();
    }

    public void removeFromClipboard(BoundingBox bounds, String owner) {
        if (!owner.equals(this.playerName)) {
            return;
        }
        this.clipboard.remove((Object)bounds);
        this.setDirty();
    }

    public void clearClipboard() {
        this.clipboard.clear();
        this.setDirty();
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider lookup) {
        tag.putString(PLAYER_KEY, this.playerName);
        if (!this.actionHistory.isExpired((Level)this.level)) {
            tag.put(ACTION_HISTORY_KEY, (Tag)ActionHistory.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.actionHistory).getOrThrow(s -> new IllegalStateException("couldn't serialize action history for " + this.playerName + ": " + s)));
        }
        if (!this.clipboard.isEmpty()) {
            ListTag clipboardList = new ListTag();
            for (Object2ObjectMap.Entry entry : this.clipboard.object2ObjectEntrySet()) {
                CompoundTag clipboardTag = new CompoundTag();
                BoundingBox b = (BoundingBox)entry.getKey();
                clipboardTag.putIntArray(BOUNDS_KEY, new int[]{b.minX(), b.minY(), b.minZ(), b.maxX(), b.maxY(), b.maxZ()});
                clipboardTag.put(CAPTURED_KEY, (Tag)((CapturedBlocks)entry.getValue()).toCompressedTag(lookup));
                clipboardList.add((Object)clipboardTag);
            }
            tag.put(CLIPBOARD_KEY, (Tag)clipboardList);
        }
        return tag;
    }

    private static BuildingToolPlayerData load(ServerLevel level, CompoundTag tag, HolderLookup.Provider lookup) {
        String playerName = tag.getString(PLAYER_KEY);
        ActionHistory actionHistory = tag.contains(ACTION_HISTORY_KEY, 10) ? (ActionHistory)((Pair)ActionHistory.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound(ACTION_HISTORY_KEY)).getOrThrow(s -> new IllegalStateException("couldn't deserialize action history: " + s))).getFirst() : new ActionHistory(playerName);
        Object2ObjectLinkedOpenHashMap clipboard = new Object2ObjectLinkedOpenHashMap();
        if (tag.contains(CLIPBOARD_KEY, 9)) {
            ListTag clipboardList = tag.getList(CLIPBOARD_KEY, 10);
            for (Tag t : clipboardList) {
                if (!(t instanceof CompoundTag)) continue;
                CompoundTag clipboardTag = (CompoundTag)t;
                int[] boundsArray = clipboardTag.getIntArray(BOUNDS_KEY);
                BoundingBox bounds = new BoundingBox(boundsArray[0], boundsArray[1], boundsArray[2], boundsArray[3], boundsArray[4], boundsArray[5]);
                CapturedBlocks captured = CapturedBlocks.fromCompressedTag(lookup, clipboardTag.getCompound(CAPTURED_KEY));
                clipboard.put((Object)bounds, (Object)captured);
            }
        }
        return new BuildingToolPlayerData(level, playerName, actionHistory, (Object2ObjectLinkedOpenHashMap<BoundingBox, CapturedBlocks>)clipboard);
    }

    public boolean isDirty() {
        return super.isDirty() || this.actionHistory.isDirty();
    }

    public CompoundTag save(HolderLookup.Provider lookup) {
        CompoundTag tag = super.save(lookup);
        this.actionHistory.setDirty(false);
        return tag;
    }

    public static class BuildingToolClientData
    extends BuildingToolPlayerData {
        final Object2ObjectLinkedOpenHashMap<String, Object2ObjectLinkedOpenHashMap<BoundingBox, CapturedBlocks>> otherPlayerClipboards = new Object2ObjectLinkedOpenHashMap();

        public BuildingToolClientData(String playerName) {
            super(null, playerName);
        }

        @Override
        @Nullable
        public CapturedBlocks getCapturedBlocks(BoundingBox bounds, String owner) {
            CapturedBlocks captured;
            Object2ObjectLinkedOpenHashMap other;
            if (!this.playerName.equals(owner) && (other = (Object2ObjectLinkedOpenHashMap)this.otherPlayerClipboards.get((Object)owner)) != null && (captured = (CapturedBlocks)other.get((Object)bounds)) != null) {
                return captured;
            }
            return super.getCapturedBlocks(bounds, owner);
        }

        @Override
        public void addToClipboardDirect(BoundingBox bounds, CapturedBlocks captured, String owner) {
            Object2ObjectLinkedOpenHashMap other;
            if (!this.playerName.equals(owner) && (other = (Object2ObjectLinkedOpenHashMap)this.otherPlayerClipboards.computeIfAbsent((Object)owner, s -> new Object2ObjectLinkedOpenHashMap())) != null) {
                other.putAndMoveToFirst((Object)bounds, (Object)captured);
            }
            super.addToClipboardDirect(bounds, captured, owner);
        }

        @Override
        public void removeFromClipboard(BoundingBox bounds, String owner) {
            Object2ObjectLinkedOpenHashMap other;
            if (!this.playerName.equals(owner) && (other = (Object2ObjectLinkedOpenHashMap)this.otherPlayerClipboards.get((Object)owner)) != null) {
                other.remove((Object)bounds);
            }
            super.removeFromClipboard(bounds, owner);
        }

        @Override
        public void clearClipboard() {
            this.otherPlayerClipboards.clear();
            super.clearClipboard();
        }

        @Override
        public CompoundTag save(CompoundTag tag, HolderLookup.Provider lookup) {
            return tag;
        }

        @Override
        public CompoundTag save(HolderLookup.Provider lookup) {
            return new CompoundTag();
        }
    }
}

