/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.client;

import com.legacy.structure_gel.api.block.GelPortalBlock;
import com.legacy.structure_gel.core.SGProxy;
import com.legacy.structure_gel.core.block_entity.DataHandlerBlockEntity;
import com.legacy.structure_gel.core.block_entity.DynamicSpawnerBlockEntity;
import com.legacy.structure_gel.core.capability.level.BuildingToolPlayerData;
import com.legacy.structure_gel.core.client.ClientUtil;
import com.legacy.structure_gel.core.client.renderers.BuildingToolRenderer;
import com.legacy.structure_gel.core.client.renderers.StructureBoundsRenderer;
import com.legacy.structure_gel.core.client.screen.DataHandlerScreen;
import com.legacy.structure_gel.core.client.screen.DynamicSpawnerScreen;
import com.legacy.structure_gel.core.client.screen.building_tool.BuildingToolScreen;
import com.legacy.structure_gel.core.data_components.CloneRegion;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.registry.SGRegistry;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;
import net.neoforged.neoforge.common.util.Lazy;

public class ClientProxy
extends SGProxy {
    private boolean shouldViewBounds = false;
    public static final List<Lazy<KeyMapping>> KEY_MAPPINGS = new ArrayList<Lazy<KeyMapping>>(5);
    public static final Lazy<KeyMapping> UNDO_KEY = ClientProxy.keyBind(() -> new KeyMapping("info.structure_gel.building_tool.undo", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.CONTROL, InputConstants.Type.KEYSYM.getOrCreate(90), ((BuildingToolItem)((Object)((Object)SGRegistry.Items.BUILDING_TOOL.get()))).getDescriptionId()));
    public static final Lazy<KeyMapping> REDO_KEY = ClientProxy.keyBind(() -> new KeyMapping("info.structure_gel.building_tool.redo", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.CONTROL, InputConstants.Type.KEYSYM.getOrCreate(89), ((BuildingToolItem)((Object)((Object)SGRegistry.Items.BUILDING_TOOL.get()))).getDescriptionId()));
    public static final Lazy<KeyMapping> COPY_KEY = ClientProxy.keyBind(() -> new KeyMapping("info.structure_gel.building_tool.copy", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.CONTROL, InputConstants.Type.KEYSYM.getOrCreate(67), ((BuildingToolItem)((Object)((Object)SGRegistry.Items.BUILDING_TOOL.get()))).getDescriptionId()));
    public static final Lazy<KeyMapping> PASTE_KEY = ClientProxy.keyBind(() -> new KeyMapping("info.structure_gel.building_tool.paste", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.CONTROL, InputConstants.Type.KEYSYM.getOrCreate(86), ((BuildingToolItem)((Object)((Object)SGRegistry.Items.BUILDING_TOOL.get()))).getDescriptionId()));
    public static final Lazy<KeyMapping> DELETE_KEY = ClientProxy.keyBind(() -> new KeyMapping("info.structure_gel.building_tool.delete", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.NONE, InputConstants.Type.KEYSYM.getOrCreate(261), ((BuildingToolItem)((Object)((Object)SGRegistry.Items.BUILDING_TOOL.get()))).getDescriptionId()));
    public static final Lazy<KeyMapping> BUILDING_TOOL_KEY = ClientProxy.keyBind(() -> new KeyMapping("key.structure_gel.open_building_tool_gui", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.NONE, InputConstants.Type.KEYSYM.getOrCreate(82), ((BuildingToolItem)((Object)((Object)SGRegistry.Items.BUILDING_TOOL.get()))).getDescriptionId()));
    public static GelPortalBlock lastPortal = null;
    private static BuildingToolPlayerData buildingToolClientData;

    private static Lazy<KeyMapping> keyBind(Supplier<KeyMapping> key) {
        Lazy mapping = Lazy.of(key);
        KEY_MAPPINGS.add((Lazy<KeyMapping>)mapping);
        return mapping;
    }

    @Override
    public void openDataHandlerScreen(DataHandlerBlockEntity dataHandler) {
        Minecraft.getInstance().setScreen((Screen)new DataHandlerScreen(dataHandler));
    }

    @Override
    public void openDynamicSpawnerScreen(DynamicSpawnerBlockEntity spawner) {
        Minecraft.getInstance().setScreen((Screen)new DynamicSpawnerScreen(spawner));
    }

    @Override
    public void openBuildingToolScreen(ItemStack stack, InteractionHand hand) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen == null) {
            mc.player.swing(hand);
            Minecraft.getInstance().setScreen((Screen)new BuildingToolScreen(stack, hand));
        }
    }

    @Override
    public void setViewBounds(boolean shouldViewBounds) {
        Minecraft mc = Minecraft.getInstance();
        ChatComponent chat = mc.gui.getChat();
        if (shouldViewBounds) {
            if (this.shouldViewBounds) {
                chat.addMessage((Component)Component.literal((String)"Refreshing structure bounding box rendering..."));
            } else {
                chat.addMessage((Component)Component.literal((String)"Enabled structure bounding box rendering"));
            }
        } else {
            StructureBoundsRenderer.clear();
            if (this.shouldViewBounds) {
                chat.addMessage((Component)Component.literal((String)"Disabled structure bounding box rendering"));
            }
        }
        this.shouldViewBounds = shouldViewBounds;
    }

    @Override
    public boolean shouldViewBounds() {
        return this.shouldViewBounds;
    }

    @Override
    public void clearToolRenderCache() {
        BuildingToolRenderer.clear();
    }

    @Override
    @Nullable
    public BuildingToolPlayerData getBuildingToolData(@Nullable ServerLevel level, String playerName) {
        BuildingToolPlayerData data = super.getBuildingToolData(level, playerName);
        return data != null ? data : this.clientBuildingToolData();
    }

    @Override
    @Nullable
    public BuildingToolPlayerData getBuildingToolData(@Nullable MinecraftServer server, CloneRegion cloneRegion) {
        BuildingToolPlayerData data = super.getBuildingToolData(server, cloneRegion);
        return data != null ? data : this.clientBuildingToolData();
    }

    private BuildingToolPlayerData clientBuildingToolData() {
        if (buildingToolClientData == null) {
            buildingToolClientData = new BuildingToolPlayerData.BuildingToolClientData(Minecraft.getInstance().player.getGameProfile().getName());
        }
        return buildingToolClientData;
    }

    @Override
    public void clearRegistryKeyCache() {
        ClientUtil.REGISTRY_KEYS.clear();
    }
}

