/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.client.renderers.block_entity;

import com.legacy.structure_gel.api.data_handler.handlers.DataHandler;
import com.legacy.structure_gel.core.SGConfig;
import com.legacy.structure_gel.core.block.DataHandlerBlock;
import com.legacy.structure_gel.core.block_entity.DataHandlerBlockEntity;
import com.legacy.structure_gel.core.client.ClientUtil;
import com.legacy.structure_gel.core.client.SGRenderType;
import com.legacy.structure_gel.core.client.renderers.IRenderBase;
import com.legacy.structure_gel.core.util.SGText;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DataHandlerRenderer
implements BlockEntityRenderer<DataHandlerBlockEntity> {
    public DataHandlerRenderer(BlockEntityRendererProvider.Context renderContext) {
    }

    public void render(DataHandlerBlockEntity dataHandler, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int overlay) {
        Vec3 offset;
        Minecraft mc = Minecraft.getInstance();
        if (SGConfig.CLIENT.showStructureBlockInfo() && dataHandler.getLevel() != null && mc.player != null && ClientUtil.rayTrace(dataHandler.getLevel(), (Player)mc.player).getBlockPos().equals((Object)dataHandler.getBlockPos())) {
            if (dataHandler.getCustomName() == null) {
                List handlers = dataHandler.getHandlers().unwrap();
                MutableComponent mode = SGText.TYPE_LABEL.copy().setStyle(SGText.VALUE_LABEL_STYLE).append(": ");
                MutableComponent text = handlers.size() == 0 ? Component.empty() : (handlers.size() == 1 ? Component.literal((String)((DataHandlerBlockEntity.RawHandler)handlers.get(0)).typeName().toString()) : Component.translatable((String)"gui.structure_gel.data_handler.compound"));
                ClientUtil.renderName((Component)Component.empty().append((Component)mode).append((Component)text), (BlockGetter)dataHandler.getLevel(), dataHandler.getBlockPos(), poseStack, buffer, 220);
            } else {
                ClientUtil.renderName(dataHandler.getCustomName(), (BlockGetter)dataHandler.getLevel(), dataHandler.getBlockPos(), poseStack, buffer, 220);
            }
        }
        if (!Vec3.ZERO.equals((Object)(offset = dataHandler.getOffset()))) {
            BlockState state = dataHandler.getBlockState();
            Vec3 exactPos = Vec3.atBottomCenterOf((Vec3i)BlockPos.ZERO).add(DataHandler.offsetPosition(offset, (Direction)state.getValue(DataHandlerBlock.FACING), (Mirror)state.getValue(DataHandlerBlock.MIRROR)));
            double r2 = 0.05;
            Vec3 rOffset2 = new Vec3(r2, r2, r2);
            IRenderBase.makeBox(poseStack, buffer.getBuffer(SGRenderType.worldWireframe(false, false)), exactPos.subtract(rOffset2), exactPos.add(rOffset2), 0.5f, 0.7f, 0.9f, 1.0f);
            new IRenderBase.LineBoxBuilder(BlockPos.containing((Position)exactPos)).rgb(0.0f, 0.3f, 0.7f).lineWidth(0.015).build(poseStack, buffer.getBuffer(SGRenderType.worldWireframe(false, false)));
        }
    }

    public boolean shouldRenderOffScreen(DataHandlerBlockEntity dataHandler) {
        return true;
    }

    public AABB getRenderBoundingBox(DataHandlerBlockEntity dataHandler) {
        Vec3 offset = dataHandler.getOffset();
        if (Vec3.ZERO.equals((Object)offset)) {
            return super.getRenderBoundingBox((BlockEntity)dataHandler);
        }
        double size = Math.max(Math.max(Math.abs(offset.x()), Math.abs(offset.y())), Math.abs(offset.z())) + 3.0;
        return AABB.ofSize((Vec3)Vec3.atCenterOf((Vec3i)dataHandler.getBlockPos()), (double)size, (double)size, (double)size);
    }
}

