/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.client.screen.building_tool;

import com.legacy.structure_gel.api.client.gui.LayeredScreen;
import com.legacy.structure_gel.core.client.ClientProxy;
import com.legacy.structure_gel.core.client.SGSprites;
import com.legacy.structure_gel.core.client.screen.building_tool.BuildingToolScreen;
import com.legacy.structure_gel.core.client.widget.PropertyEditBox;
import com.legacy.structure_gel.core.client.widget.TooltipSpriteButton;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.item.building_tool.SmartBoundingBox;
import com.legacy.structure_gel.core.item.building_tool.ToolModeProperty;
import com.legacy.structure_gel.core.registry.SGRegistry;
import com.legacy.structure_gel.core.util.SGText;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class EditSelectionScreen
extends LayeredScreen {
    protected static final Component CLEAR_SELECTION_TEXT = Component.translatable((String)"info.structure_gel.building_tool.clear_selection");
    protected static final String CLEAR_SELECTION_DESC = "info.structure_gel.building_tool.clear_selection.description";
    protected static final String EXPAND_FACING_DESC = "info.structure_gel.building_tool.expand_facing.description";
    protected static final String EXPAND_TEXT = "info.structure_gel.building_tool.expand";
    protected static final String EXPAND_DESC = "info.structure_gel.building_tool.expand.description";
    protected static final String SHRINK_TEXT = "info.structure_gel.building_tool.shrink";
    protected static final String SHRINK_DESC = "info.structure_gel.building_tool.shrink.description";
    protected static final Component FACING = Component.translatable((String)"info.structure_gel.building_tool.facing");
    protected static final Component FRONT = Component.translatable((String)"info.structure_gel.building_tool.front");
    protected static final Component BACK = Component.translatable((String)"info.structure_gel.building_tool.back");
    protected static final Component LEFT = Component.translatable((String)"info.structure_gel.building_tool.left");
    protected static final Component RIGHT = Component.translatable((String)"info.structure_gel.building_tool.right");
    protected static final Component TOP = Component.translatable((String)"info.structure_gel.building_tool.top");
    protected static final Component BOTTOM = Component.translatable((String)"info.structure_gel.building_tool.bottom");
    private final BuildingToolScreen parent;
    protected final List<Renderable> widgetsToRender = new ArrayList<Renderable>(2);
    private SmartBoundingBox bounds;
    private Vec3i negativePos;
    private Vec3i positivePos;
    private PropertyEditBox<Integer> xEditBox;
    private PropertyEditBox<Integer> yEditBox;
    private PropertyEditBox<Integer> zEditBox;
    private Optional<BuildingToolScreen.DescriptionRenderer> descriptionRenderer = Optional.empty();

    public EditSelectionScreen(BuildingToolScreen parent) {
        super((Component)Component.empty());
        this.parent = parent;
        Optional<BlockPos> posA = BuildingToolItem.getPos(this.parent.stack, 0);
        Optional<BlockPos> posB = BuildingToolItem.getPos(this.parent.stack, 1);
        if (posA.isPresent() && posB.isPresent()) {
            this.bounds = SmartBoundingBox.fromCorners((Vec3i)posA.get(), (Vec3i)posB.get());
        } else if (posA.isPresent() && posB.isEmpty()) {
            this.bounds = SmartBoundingBox.fromCorners((Vec3i)posA.get(), (Vec3i)posA.get());
        } else if (posA.isEmpty() && posB.isPresent()) {
            this.bounds = SmartBoundingBox.fromCorners((Vec3i)posB.get(), (Vec3i)posB.get());
        } else {
            BlockPos playerPos = Minecraft.getInstance().player.blockPosition();
            this.bounds = SmartBoundingBox.fromCorners((Vec3i)playerPos, (Vec3i)playerPos);
        }
        this.negativePos = this.bounds.getMin();
        this.positivePos = this.bounds.getMax();
    }

    protected void init() {
        this.widgetsToRender.clear();
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        int texX = centerX - 100;
        int texY = centerY - 100;
        int circleWidth = 40;
        int w = 16;
        String shiftKey = SGText.keybindString(this.minecraft.options.keyShift);
        this.widgetsToRender.add((Renderable)this.addWidget(new TooltipSpriteButton(texX + 21, texY + 21, circleWidth, circleWidth, SGSprites.EXIT_SELECTION_EDIT, b -> this.back()).onTooltip((button, poseStack, mouseX, mouseY) -> this.renderDescription((GuiEventListener)button, BuildingToolScreen.GO_BACK_TEXT, "info.structure_gel.building_tool.go_back.description", SGText.keybindString(this.minecraft.options.keyDrop)))));
        this.widgetsToRender.add((Renderable)this.addWidget(new TooltipSpriteButton(texX + 21, texY + 139, circleWidth, circleWidth, SGSprites.CLEAR_SELECTION, b -> this.clearSelection()).onTooltip((button, poseStack, mouseX, mouseY) -> this.renderDescription((GuiEventListener)button, CLEAR_SELECTION_TEXT, CLEAR_SELECTION_DESC, new Object[0]))));
        this.widgetsToRender.add((Renderable)this.addWidget(new TooltipSpriteButton(texX + 80, texY + 80, circleWidth, circleWidth, SGSprites.EXPAND_SELECTION, b -> this.expandFacing()).onTooltip((button, poseStack, mouseX, mouseY) -> this.renderDescription((GuiEventListener)button, this.component(EXPAND_TEXT, FACING), EXPAND_FACING_DESC, shiftKey))));
        this.widgetsToRender.add((Renderable)this.addWidget(new TooltipSpriteButton(texX + 92, texY + 14, w, w, SGSprites.ADD, b -> this.expand(Direction.NORTH)).onTooltip((button, poseStack, mouseX, mouseY) -> this.renderDescription((GuiEventListener)button, this.component(EXPAND_TEXT, FRONT), EXPAND_DESC, shiftKey))));
        this.widgetsToRender.add((Renderable)this.addWidget(new TooltipSpriteButton(texX + 92, texY + 34, w, w, SGSprites.SUBTRACT, b -> this.shrink(Direction.NORTH)).onTooltip((button, poseStack, mouseX, mouseY) -> this.renderDescription((GuiEventListener)button, this.component(SHRINK_TEXT, FRONT), SHRINK_DESC, shiftKey))));
        this.widgetsToRender.add((Renderable)this.addWidget(new TooltipSpriteButton(texX + 92, texY + 171, w, w, SGSprites.ADD, b -> this.expand(Direction.SOUTH)).onTooltip((button, poseStack, mouseX, mouseY) -> this.renderDescription((GuiEventListener)button, this.component(EXPAND_TEXT, BACK), EXPAND_DESC, shiftKey))));
        this.widgetsToRender.add((Renderable)this.addWidget(new TooltipSpriteButton(texX + 92, texY + 150, w, w, SGSprites.SUBTRACT, b -> this.shrink(Direction.SOUTH)).onTooltip((button, poseStack, mouseX, mouseY) -> this.renderDescription((GuiEventListener)button, this.component(SHRINK_TEXT, BACK), SHRINK_DESC, shiftKey))));
        this.widgetsToRender.add((Renderable)this.addWidget(new TooltipSpriteButton(texX + 171, texY + 92, w, w, SGSprites.ADD, b -> this.expand(Direction.EAST)).onTooltip((button, poseStack, mouseX, mouseY) -> this.renderDescription((GuiEventListener)button, this.component(EXPAND_TEXT, RIGHT), EXPAND_DESC, shiftKey))));
        this.widgetsToRender.add((Renderable)this.addWidget(new TooltipSpriteButton(texX + 150, texY + 92, w, w, SGSprites.SUBTRACT, b -> this.shrink(Direction.EAST)).onTooltip((button, poseStack, mouseX, mouseY) -> this.renderDescription((GuiEventListener)button, this.component(SHRINK_TEXT, RIGHT), SHRINK_DESC, shiftKey))));
        this.widgetsToRender.add((Renderable)this.addWidget(new TooltipSpriteButton(texX + 13, texY + 92, w, w, SGSprites.ADD, b -> this.expand(Direction.WEST)).onTooltip((button, poseStack, mouseX, mouseY) -> this.renderDescription((GuiEventListener)button, this.component(EXPAND_TEXT, LEFT), EXPAND_DESC, shiftKey))));
        this.widgetsToRender.add((Renderable)this.addWidget(new TooltipSpriteButton(texX + 34, texY + 92, w, w, SGSprites.SUBTRACT, b -> this.shrink(Direction.WEST)).onTooltip((button, poseStack, mouseX, mouseY) -> this.renderDescription((GuiEventListener)button, this.component(SHRINK_TEXT, LEFT), SHRINK_DESC, shiftKey))));
        this.widgetsToRender.add((Renderable)this.addWidget(new TooltipSpriteButton(texX + 151, texY + 136, w, w, SGSprites.ADD, b -> this.expand(Direction.UP)).onTooltip((button, poseStack, mouseX, mouseY) -> this.renderDescription((GuiEventListener)button, this.component(EXPAND_TEXT, TOP), EXPAND_DESC, shiftKey))));
        this.widgetsToRender.add((Renderable)this.addWidget(new TooltipSpriteButton(texX + 171, texY + 136, w, w, SGSprites.SUBTRACT, b -> this.shrink(Direction.UP)).onTooltip((button, poseStack, mouseX, mouseY) -> this.renderDescription((GuiEventListener)button, this.component(SHRINK_TEXT, TOP), SHRINK_DESC, shiftKey))));
        this.widgetsToRender.add((Renderable)this.addWidget(new TooltipSpriteButton(texX + 151, texY + 180, w, w, SGSprites.ADD, b -> this.expand(Direction.DOWN)).onTooltip((button, poseStack, mouseX, mouseY) -> this.renderDescription((GuiEventListener)button, this.component(EXPAND_TEXT, BOTTOM), EXPAND_DESC, shiftKey))));
        this.widgetsToRender.add((Renderable)this.addWidget(new TooltipSpriteButton(texX + 171, texY + 180, w, w, SGSprites.SUBTRACT, b -> this.shrink(Direction.DOWN)).onTooltip((button, poseStack, mouseX, mouseY) -> this.renderDescription((GuiEventListener)button, this.component(SHRINK_TEXT, BOTTOM), SHRINK_DESC, shiftKey))));
        int leftPropY = 80;
        ToolModeProperty.NumberProp<Integer> xProp = ToolModeProperty.X_SIZE;
        this.xEditBox = new PropertyEditBox<Integer>(this.minecraft.font, centerX - 210, centerY - leftPropY, xProp, 0);
        this.xEditBox.setValue(this.bounds.getXSpan());
        this.xEditBox.setResponder(s -> {
            if (xProp.canRead((String)s)) {
                this.positivePos = new Vec3i(this.negativePos.getX() + (Integer)xProp.read((String)s) - 1, this.positivePos.getY(), this.positivePos.getZ());
                this.updateBounds(false);
            }
        });
        this.widgetsToRender.add((Renderable)this.addWidget(this.xEditBox));
        ToolModeProperty.NumberProp<Integer> yProp = ToolModeProperty.Y_SIZE;
        this.yEditBox = new PropertyEditBox<Integer>(this.minecraft.font, centerX - 210, centerY - (leftPropY -= 30), yProp, 0);
        this.yEditBox.setValue(this.bounds.getYSpan());
        this.yEditBox.setResponder(s -> {
            if (yProp.canRead((String)s)) {
                this.positivePos = new Vec3i(this.positivePos.getX(), this.negativePos.getY() + (Integer)yProp.read((String)s) - 1, this.positivePos.getZ());
                this.updateBounds(false);
            }
        });
        this.widgetsToRender.add((Renderable)this.addWidget(this.yEditBox));
        ToolModeProperty.NumberProp<Integer> zProp = ToolModeProperty.Z_SIZE;
        this.zEditBox = new PropertyEditBox<Integer>(this.minecraft.font, centerX - 210, centerY - (leftPropY -= 30), zProp, 0);
        this.zEditBox.setValue(this.bounds.getZSpan());
        this.zEditBox.setResponder(s -> {
            if (zProp.canRead((String)s)) {
                this.positivePos = new Vec3i(this.positivePos.getX(), this.positivePos.getY(), this.negativePos.getZ() + (Integer)zProp.read((String)s) - 1);
                this.updateBounds(false);
            }
        });
        this.widgetsToRender.add((Renderable)this.addWidget(this.zEditBox));
        leftPropY -= 30;
    }

    private Component component(String key, Object ... args) {
        return Component.translatable((String)key, (Object[])args);
    }

    private void expand(Direction direction) {
        if ((direction = this.rotatedByPlayer(direction)).getAxisDirection() == Direction.AxisDirection.POSITIVE) {
            this.positivePos = this.positivePos.offset(direction.getUnitVec3i());
        } else {
            this.negativePos = this.negativePos.offset(direction.getUnitVec3i());
        }
        if (Screen.hasShiftDown()) {
            Direction opposite = direction.getOpposite();
            if (opposite.getAxisDirection() == Direction.AxisDirection.POSITIVE) {
                this.positivePos = this.positivePos.subtract(opposite.getUnitVec3i());
            } else {
                this.negativePos = this.negativePos.subtract(opposite.getUnitVec3i());
            }
        }
        this.updateBounds(true);
    }

    private void shrink(Direction direction) {
        if ((direction = this.rotatedByPlayer(direction)).getAxisDirection() == Direction.AxisDirection.POSITIVE) {
            this.positivePos = this.positivePos.subtract(direction.getUnitVec3i());
        } else {
            this.negativePos = this.negativePos.subtract(direction.getUnitVec3i());
        }
        if (Screen.hasShiftDown()) {
            Direction opposite = direction.getOpposite();
            if (opposite.getAxisDirection() == Direction.AxisDirection.POSITIVE) {
                this.positivePos = this.positivePos.offset(opposite.getUnitVec3i());
            } else {
                this.negativePos = this.negativePos.offset(opposite.getUnitVec3i());
            }
        }
        this.updateBounds(true);
    }

    private Direction rotatedByPlayer(Direction direction) {
        if (direction.getAxis() != Direction.Axis.Y) {
            Direction facingDir = this.minecraft.player.getDirection();
            return Direction.from2DDataValue((int)((direction.get2DDataValue() + facingDir.get2DDataValue()) % 4)).getOpposite();
        }
        return direction;
    }

    private void expandFacing() {
        Direction direction = Direction.orderedByNearest((Entity)this.minecraft.player)[0];
        if (direction.getAxisDirection() == Direction.AxisDirection.POSITIVE) {
            this.positivePos = this.positivePos.offset(direction.getUnitVec3i());
        } else {
            this.negativePos = this.negativePos.offset(direction.getUnitVec3i());
        }
        if (Screen.hasShiftDown()) {
            Direction opposite = direction.getOpposite();
            if (opposite.getAxisDirection() == Direction.AxisDirection.POSITIVE) {
                this.positivePos = this.positivePos.subtract(opposite.getUnitVec3i());
            } else {
                this.negativePos = this.negativePos.subtract(opposite.getUnitVec3i());
            }
        }
        this.updateBounds(true);
    }

    private void clearSelection() {
        this.parent.clearPoses = true;
        this.close();
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        Component component;
        super.render(graphics, mouseX, mouseY, partialTick);
        int arrowW = 54;
        int arrowH = 72;
        int topBottomW = 51;
        int topBottomH = 33;
        this.drawHoverable(graphics, SGSprites.SELECTION_NORTH, mouseX, mouseY, 73, 0, arrowW, arrowH);
        this.drawHoverable(graphics, SGSprites.SELECTION_SOUTH, mouseX, mouseY, 73, 128, arrowW, arrowH);
        this.drawHoverable(graphics, SGSprites.SELECTION_WEST, mouseX, mouseY, 0, 73, arrowH, arrowW);
        this.drawHoverable(graphics, SGSprites.SELECTION_EAST, mouseX, mouseY, 128, 73, arrowH, arrowW);
        this.drawHoverable(graphics, SGSprites.SELECTION_UP, mouseX, mouseY, 143, 132, topBottomW, topBottomH);
        this.drawHoverable(graphics, SGSprites.SELECTION_DOWN, mouseX, mouseY, 143, 167, topBottomW, topBottomH);
        this.widgetsToRender.forEach(w -> {
            w.render(graphics, mouseX, mouseY, partialTick);
            RenderSystem.enableBlend();
        });
        if (this.descriptionRenderer.isPresent()) {
            this.descriptionRenderer.get().render(graphics);
            this.descriptionRenderer = Optional.empty();
        }
        if ((component = this.parent.mode.getHudMessage(this.parent.stack)) != null) {
            int length = this.font.width((FormattedText)component);
            graphics.drawString(this.font, component, this.width / 2 - length / 2, this.height / 2 - 112, 0xE0E0E0);
        }
    }

    private void drawHoverable(GuiGraphics graphics, WidgetSprites sprites, int mouseX, int mouseY, int x, int y, int width, int height) {
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        int texX = centerX - 100;
        int texY = centerY - 100;
        boolean hovered = mouseX >= texX + x && mouseX <= texX + x + width && mouseY >= texY + y && mouseY <= texY + y + height;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        graphics.blitSprite(RenderType::guiTextured, sprites.get(true, hovered), texX + x, texY + y, width, height);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int clickType) {
        return super.mouseClicked(mouseX, mouseY, clickType);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key key = InputConstants.Type.KEYSYM.getOrCreate(keyCode);
        int escape = 256;
        int backspace = 259;
        boolean pressedEnter = keyCode == 257 || keyCode == 335;
        boolean consumed = super.keyPressed(keyCode, scanCode, modifiers);
        if (!consumed && (backspace == keyCode || this.minecraft.options.keyDrop.isActiveAndMatches(key))) {
            this.back();
            BuildingToolScreen.playClickSound();
            return true;
        }
        if (escape == keyCode || this.minecraft.options.keyInventory.isActiveAndMatches(key) || ((KeyMapping)ClientProxy.BUILDING_TOOL_KEY.get()).isActiveAndMatches(key) || pressedEnter) {
            this.close();
            return true;
        }
        return consumed;
    }

    private void renderDescription(GuiEventListener widget, Component title, String descriptionKey, Object ... descriptionArgs) {
        this.renderDescription(widget, title, List.of(Pair.of((Object)descriptionKey, (Object)descriptionArgs)));
    }

    private void renderDescription(GuiEventListener widget, Component title, List<Pair<String, Object[]>> descriptionKeys) {
        this.renderDescription(widget.getRectangle().position().x(), title, descriptionKeys);
    }

    private void renderDescription(int x, Component title, String descriptionKey, Object ... descriptionArgs) {
        this.renderDescription(x, title, List.of(Pair.of((Object)descriptionKey, (Object)descriptionArgs)));
    }

    private void renderDescription(int x, Component title, List<Pair<String, Object[]>> descriptionKeys) {
        this.descriptionRenderer = Optional.of(new BuildingToolScreen.DescriptionRenderer(this, x, title, descriptionKeys));
    }

    public void close() {
        this.onClose();
        this.parent.onClose();
        BuildingToolScreen.lastScreenState = 1;
        this.minecraft.setScreen(null);
    }

    public void back() {
        this.onClose();
        BuildingToolScreen.lastScreenState = 0;
        this.minecraft.setScreen((Screen)this.parent);
    }

    @Override
    public void onClose() {
        SmartBoundingBox bb = this.updateBounds(false);
        if (this.parent.selectedPosA.isPresent() && this.parent.selectedPosB.isPresent() && !SmartBoundingBox.fromCorners((Vec3i)this.parent.selectedPosA.get(), (Vec3i)this.parent.selectedPosB.get()).equals(bb)) {
            this.parent.usedEditSelectionScreen = true;
        }
        this.parent.selectedPosA = Optional.of(new BlockPos(bb.getPosA()));
        this.parent.selectedPosB = Optional.of(new BlockPos(bb.getPosB()));
    }

    public SmartBoundingBox updateBounds(boolean updateEditBox) {
        ItemStack tool;
        SmartBoundingBox bb = SmartBoundingBox.from(this.bounds);
        bb.setMin(this.negativePos);
        bb.setMax(this.positivePos);
        if (updateEditBox) {
            this.xEditBox.setValue(bb.getXSpan());
            this.yEditBox.setValue(bb.getYSpan());
            this.zEditBox.setValue(bb.getZSpan());
        }
        if ((tool = this.minecraft.player.getItemInHand(this.parent.hand)).is((Item)SGRegistry.Items.BUILDING_TOOL.get())) {
            BuildingToolItem.setPos(tool, 0, (Vec3i)new BlockPos(bb.getPosA()));
            BuildingToolItem.setPos(tool, 1, (Vec3i)new BlockPos(bb.getPosB()));
        }
        return bb;
    }

    public void tick() {
        this.parent.tick();
    }

    public boolean isPauseScreen() {
        return false;
    }
}

