/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.client.widget;

import com.legacy.structure_gel.api.data_handler.parsing.DataParser;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.client.screen.DataHandlerScreen;
import com.legacy.structure_gel.core.client.widget.SuggestionEditBox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;

public class DataParamsList
extends ContainerObjectSelectionList<Entry> {
    private static final Map<Class<?>, WidgetFactory> WIDGET_FACTORIES = (Map)Util.make(new HashMap(), map -> {
        map.put(Boolean.class, WidgetFactory::booleanButton);
        map.put(Direction.class, WidgetFactory::directionButton);
        map.put(BlockState.class, (mc, parser) -> WidgetFactory.registryEditBox(mc, parser, BuiltInRegistries.BLOCK));
        map.put(ItemStack.class, (mc, parser) -> WidgetFactory.registryEditBox(mc, parser, BuiltInRegistries.ITEM));
        map.put(ResourceKey.class, WidgetFactory::registryEditBox);
    });
    public final DataHandlerScreen parentScreen;
    @Nullable
    private Entry hoveredEntry = null;
    private boolean isValid = false;

    public DataParamsList(DataHandlerScreen screen, Minecraft mc, @Nullable DataParser dataParser) {
        super(mc, screen.width + 55, screen.height - 88, 52, 25);
        this.parentScreen = screen;
        this.createEntries(dataParser);
    }

    public Map<String, String> values() {
        HashMap<String, String> entries = new HashMap<String, String>();
        for (Entry entry : this.children()) {
            DataParser.Parser<?> parser;
            Object parsedVal;
            String value = entry.getValue();
            if (value.isBlank() || (parsedVal = (parser = entry.parser).parse(value, (LevelReader)this.minecraft.level)) == null) continue;
            entries.put(parser.key, value);
        }
        return entries;
    }

    public List<Entry> childrenClone() {
        return new ArrayList<Entry>(this.children());
    }

    public void createEntries(@Nullable DataParser dataParser) {
        this.clearEntries();
        if (dataParser != null) {
            List<DataParser.Parser<?>> parsers = dataParser.getParsers();
            for (int i = 0; i < parsers.size(); ++i) {
                String string;
                DataParser.Parser<?> parser = parsers.get(i);
                WidgetFactory defaultVal = WidgetFactory.canMakeEnumButton(parser.type) ? (mc, p) -> WidgetFactory.hackyEnumButton(mc, p, parser.type) : WidgetFactory::suggestionEditBox;
                Entry entry = new Entry(WIDGET_FACTORIES.getOrDefault(parser.type, defaultVal).create(this.minecraft, parser), parser);
                this.addEntry((AbstractSelectionList.Entry)entry);
                AbstractWidget abstractWidget = entry.widget;
                if (!(abstractWidget instanceof CycleButton)) continue;
                CycleButton cycle = (CycleButton)abstractWidget;
                if (parser.defaultVal == null) continue;
                Object t = parser.defaultVal;
                if (t instanceof StringRepresentable) {
                    StringRepresentable s = (StringRepresentable)t;
                    string = s.getSerializedName();
                } else {
                    string = parser.defaultVal.toString();
                }
                cycle.setValue((Object)string);
            }
        }
    }

    public void setEntries(@Nullable List<Entry> entries) {
        this.clearEntries();
        if (entries != null) {
            entries.forEach(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0));
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.parentScreen.nameEdit.isVisible()) {
            return false;
        }
        for (Entry e : this.children()) {
            SuggestionEditBox suggestionEditBox;
            AbstractWidget abstractWidget = e.widget;
            if (!(abstractWidget instanceof SuggestionEditBox) || !(suggestionEditBox = (SuggestionEditBox)abstractWidget).isFocused() || !suggestionEditBox.mouseScrolled(mouseX, mouseY, deltaX, deltaY)) continue;
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int clickType) {
        if (this.parentScreen.nameEdit.isVisible()) {
            return false;
        }
        boolean ret = super.mouseClicked(mouseX, mouseY, clickType);
        if (mouseY > (double)this.getY() && mouseY < (double)this.getBottom()) {
            boolean clickedChild = this.getEntryAtPosition(mouseX, mouseY) != null;
            boolean clickedScrollBar = clickType == 0 && mouseX >= this.scrollAmount() && mouseX < this.scrollAmount() + 6.0;
            return clickedChild || clickedScrollBar;
        }
        return ret;
    }

    public void tick() {
        boolean isValid = true;
        for (Entry entry : this.children()) {
            if (entry.isValid()) continue;
            isValid = false;
            break;
        }
        this.isValid = isValid;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        if (!this.parentScreen.nameEdit.isVisible()) {
            for (Entry entry : this.children()) {
                if (!entry.widget.isFocused()) continue;
                entry.widget.render(graphics, mouseX, mouseY, partialTicks);
            }
        }
        if (this.hoveredEntry != null) {
            this.parentScreen.renderTooltip(graphics, this.hoveredEntry.tooltips, mouseX, mouseY + 10);
            this.hoveredEntry = null;
        }
    }

    public class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        public final AbstractWidget widget;
        public final DataParser.Parser<?> parser;
        public final Component renderLabel;
        public final List<Component> tooltips = new ArrayList<Component>();
        protected boolean isValid = true;

        public Entry(AbstractWidget widget, DataParser.Parser<?> parser) {
            this.widget = widget;
            this.parser = parser;
            String raw = parser.key;
            String labelStranslationKey = parser.getTranlsationKey("label");
            MutableComponent translatedLabel = Component.translatable((String)labelStranslationKey);
            if (translatedLabel.getString().equals(labelStranslationKey)) {
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < raw.length(); ++i) {
                    int prev = i - 1;
                    char c = raw.charAt(i);
                    if (i == 0 || prev > -1 && !Character.isAlphabetic(raw.charAt(prev))) {
                        builder.append(Character.toUpperCase(c));
                        continue;
                    }
                    builder.append(c == '_' ? (char)' ' : (char)c);
                }
                this.renderLabel = Component.literal((String)builder.toString());
            } else {
                this.renderLabel = translatedLabel;
            }
            this.tooltips.add((Component)Component.literal((String)this.renderLabel.getString()).append((Component)Component.literal((String)(" (" + raw + ")"))).withStyle(ChatFormatting.DARK_GREEN));
            this.createTranslatedTooltip("description", ChatFormatting.GREEN);
            if (parser.getExample() != null) {
                this.createRawTooltip("example", parser.getExample(), ChatFormatting.GREEN);
            }
            if (parser instanceof DataParser.NumberParser) {
                DataParser.NumberParser numberParser = (DataParser.NumberParser)parser;
                this.createRawTooltip("range", String.valueOf(numberParser.getMin()) + " - " + String.valueOf(numberParser.getMax()), ChatFormatting.GREEN);
            }
            this.createRawTooltip("default", parser.getDefaultValName((LevelReader)((DataParamsList)DataParamsList.this).minecraft.level), ChatFormatting.AQUA);
            this.createRawTooltip("type", parser.typeName, ChatFormatting.BLUE);
        }

        @Nullable
        private void createRawTooltip(String key, String value, ChatFormatting color) {
            this.tooltips.add((Component)Component.translatable((String)("gui.structure_gel.data_handler." + key)).append((Component)Component.literal((String)": ")).withStyle(color).append((Component)Component.literal((String)value).withStyle(ChatFormatting.GRAY)));
        }

        @Nullable
        private void createTranslatedTooltip(String key, ChatFormatting color) {
            String translationKey = this.parser.getTranlsationKey(key);
            MutableComponent translatedComponent = Component.translatable((String)translationKey);
            if (!translatedComponent.getString().equals(translationKey)) {
                this.tooltips.add((Component)Component.translatable((String)("gui.structure_gel.data_handler." + key)).append((Component)Component.literal((String)": ")).withStyle(color).append((Component)translatedComponent.withStyle(ChatFormatting.GRAY)));
            }
        }

        public List<? extends GuiEventListener> children() {
            return List.of(this.widget);
        }

        public List<? extends NarratableEntry> narratables() {
            return List.of(this.widget);
        }

        public void render(GuiGraphics graphics, int index, int rowTop, int rowLeft, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean isHovered, float partialTicks) {
            int maxWidth;
            DataParamsList dataParamsList = DataParamsList.this;
            if (dataParamsList.parentScreen.nameEdit.isVisible()) {
                return;
            }
            int white = 0xFFFFFF;
            int red = 0xBA0000;
            Font font = ((DataParamsList)dataParamsList).minecraft.font;
            int labelWidth = font.width((FormattedText)this.renderLabel);
            String labelToDraw = labelWidth > (maxWidth = 95) ? font.substrByWidth((FormattedText)this.renderLabel, maxWidth).getString() + "..." : this.renderLabel.getString();
            graphics.drawString(font, labelToDraw, rowLeft - 76, rowTop + rowHeight / 2 - 4, this.isValid ? white : red);
            this.widget.setX(rowLeft + 30);
            this.widget.setY(rowTop);
            if (!this.widget.isFocused()) {
                this.widget.render(graphics, mouseX, mouseY, partialTicks);
            }
            if (!this.isValid) {
                graphics.drawString(font, "\u2717", rowLeft - 89, rowTop + rowHeight / 2 - 4, red);
            }
            if (mouseX > rowLeft - 70 && mouseX < rowLeft + 30 && mouseY > rowTop - rowHeight + 20 && mouseY < rowTop + 20) {
                dataParamsList.hoveredEntry = this;
            }
        }

        public boolean isValid() {
            AbstractWidget abstractWidget = this.widget;
            if (abstractWidget instanceof EditBox) {
                EditBox editBox = (EditBox)abstractWidget;
                String val = editBox.getValue();
                boolean bl = this.isValid = val != null && (val.isEmpty() || this.parser.validator.test(val, (LevelReader)((DataParamsList)DataParamsList.this).minecraft.level));
                if (!this.isValid) {
                    return false;
                }
            }
            return true;
        }

        public String getValue() {
            AbstractWidget abstractWidget = this.widget;
            if (abstractWidget instanceof CycleButton) {
                CycleButton button = (CycleButton)abstractWidget;
                return button.getValue().toString().toLowerCase(Locale.ENGLISH);
            }
            abstractWidget = this.widget;
            if (abstractWidget instanceof EditBox) {
                EditBox editBox = (EditBox)abstractWidget;
                return editBox.getValue();
            }
            StructureGelMod.LOGGER.error("Unhandled widget type for DataParamsList.Entry.getValue(): " + this.widget.getClass().getCanonicalName(), new Object[0]);
            return "unknown";
        }

        public void setValue(String value) {
            AbstractWidget abstractWidget = this.widget;
            if (abstractWidget instanceof CycleButton) {
                CycleButton button = (CycleButton)abstractWidget;
                button.setValue((Object)value);
            } else {
                abstractWidget = this.widget;
                if (abstractWidget instanceof EditBox) {
                    EditBox editBox = (EditBox)abstractWidget;
                    editBox.setValue(value);
                } else {
                    StructureGelMod.LOGGER.error("Unhandled widget type for DataParamsList.Entry.setValue(): " + this.widget.getClass().getCanonicalName(), new Object[0]);
                }
            }
        }
    }

    public static interface WidgetFactory {
        public AbstractWidget create(Minecraft var1, DataParser.Parser<?> var2);

        public static <T> AbstractWidget suggestionEditBox(Minecraft mc, DataParser.Parser<?> parser, Supplier<Collection<T>> suggestions, Function<T, String> toString) {
            SuggestionEditBox editBox = new SuggestionEditBox(mc.font, 0, 0, 190, 20, (Component)Component.literal((String)""), 10, suggestions, toString);
            editBox.setMaxLength(512);
            return editBox;
        }

        private static AbstractWidget suggestionEditBox(Minecraft mc, DataParser.Parser<?> parser) {
            return WidgetFactory.suggestionEditBox(mc, parser, parser::getSuggestions, parser.getSuggestionToString());
        }

        public static AbstractWidget registryEditBox(Minecraft mc, DataParser.Parser<?> parser, Registry<?> registry) {
            FeatureFlagSet features = mc.level.enabledFeatures();
            return WidgetFactory.suggestionEditBox(mc, parser, () -> registry.entrySet().stream().filter(e -> {
                FeatureElement feature;
                Object patt0$temp = e.getValue();
                return !(patt0$temp instanceof FeatureElement) || (feature = (FeatureElement)patt0$temp).isEnabled(features);
            }).map(e -> ((ResourceKey)e.getKey()).location()).toList(), ResourceLocation::toString);
        }

        public static <T> AbstractWidget registryEditBox(Minecraft mc, DataParser.Parser<?> parser) {
            if (parser instanceof DataParser.ResourceKeyParser) {
                DataParser.ResourceKeyParser registryParser = (DataParser.ResourceKeyParser)parser;
                return WidgetFactory.suggestionEditBox(mc, registryParser, () -> registryParser.getSuggestions().stream().map(ResourceKey::location).map(ResourceLocation::toString).toList(), Function.identity());
            }
            return WidgetFactory.suggestionEditBox(mc, parser);
        }

        private static AbstractWidget booleanButton(Minecraft mc, DataParser.Parser<?> parser) {
            return WidgetFactory.cycleButton(mc, parser, "true", "false");
        }

        private static <T extends Enum<T>> AbstractWidget enumButton(Minecraft mc, DataParser.Parser<?> parser, Class<T> clazz) {
            return WidgetFactory.cycleButton((Minecraft)mc, parser, (T rec$) -> ((StringRepresentable)rec$).getSerializedName(), (Enum[])((Enum[])clazz.getEnumConstants()));
        }

        private static boolean canMakeEnumButton(Class<?> clazz) {
            return Enum.class.isAssignableFrom(clazz) && StringRepresentable.class.isAssignableFrom(clazz);
        }

        private static <T extends Enum<T>> AbstractWidget hackyEnumButton(Minecraft mc, DataParser.Parser<?> parser, Class<?> clazz) {
            if (!WidgetFactory.canMakeEnumButton(clazz)) {
                throw new IllegalArgumentException("clazz (" + clazz.getSimpleName() + ") must be an Enum and " + StringRepresentable.class.getSimpleName());
            }
            Class<?> realClazz = clazz;
            return WidgetFactory.enumButton(mc, parser, realClazz);
        }

        private static AbstractWidget directionButton(Minecraft mc, DataParser.Parser<?> parser) {
            return WidgetFactory.cycleButton((Minecraft)mc, parser, Direction::getSerializedName, (Enum[])new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST, Direction.UP, Direction.DOWN});
        }

        public static <T extends Enum<T>> AbstractWidget cycleButton(Minecraft mc, DataParser.Parser<?> parser, Function<T, String> toString, T ... values) {
            return WidgetFactory.cycleButton(mc, parser, (String[])Arrays.stream(values).map(toString).toArray(String[]::new));
        }

        public static AbstractWidget cycleButton(Minecraft mc, DataParser.Parser<?> parser, String ... values) {
            CycleButton.Builder builder = CycleButton.builder(s -> Component.literal((String)(s.substring(0, 1).toUpperCase(Locale.ENGLISH) + s.substring(1).toLowerCase(Locale.ENGLISH))));
            builder.displayOnlyValue();
            builder.withValues((Object[])values);
            return builder.create(0, 0, 60, 20, (Component)Component.literal((String)""));
        }
    }
}

