/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.client.widget;

import com.legacy.structure_gel.api.client.gui.LayerWidgetHolder;
import com.legacy.structure_gel.core.client.SGSprites;
import com.legacy.structure_gel.core.client.widget.TexturedEditBox;
import com.legacy.structure_gel.core.item.building_tool.ToolModeProperty;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;

public class PropertyEditBox<T>
extends TexturedEditBox {
    private final ToolModeProperty<T> property;
    private final String prefix;

    public PropertyEditBox(Font font, int x, int y, ToolModeProperty<T> property, String prefix, T currentVal) {
        super(font, x, y, 100, 24, SGSprites.BUILDING_TOOL_BUTTON, property.getNameComponent());
        this.property = property;
        this.prefix = prefix;
        this.setValue(property.write(currentVal));
        this.setTextColor(0xCDCDCD, 0xFFFFFF);
        this.setMaxLength(100);
    }

    public PropertyEditBox(Font font, int x, int y, ToolModeProperty<T> property, T currentVal) {
        this(font, x, y, property, property.getNameComponent().getString(), currentVal);
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        String oldValue = this.getValue();
        int color = this.property.canRead(oldValue) ? 0xE0E0E0 : 14703708;
        this.setTextColor(color, color);
        this.setValue(this.prefix + ": " + oldValue);
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        this.setValue(oldValue);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        ToolModeProperty<T> toolModeProperty = this.property;
        if (toolModeProperty instanceof ToolModeProperty.NumberProp) {
            ToolModeProperty.NumberProp numProp = (ToolModeProperty.NumberProp)toolModeProperty;
            boolean up = deltaY > 0.0;
            Object val = numProp.read(this.getValue());
            if (numProp.getNumberClass() == Integer.class) {
                int scale = Screen.hasControlDown() ? 5 : 1;
                Integer newVal = numProp.clamp(((Number)val).intValue() + (up ? scale : -scale));
                if (numProp.isValid(newVal)) {
                    this.setValue(numProp.write(newVal));
                    return true;
                }
            } else if (numProp.getNumberClass() == Double.class) {
                double scale = Screen.hasControlDown() ? 0.05 : 0.01;
                Double newVal = numProp.clamp(((Number)val).doubleValue() + (up ? scale : -scale));
                if (numProp.isValid(Double.valueOf(newVal))) {
                    this.setValue(numProp.write(newVal));
                    return true;
                }
            }
        }
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    public ToolModeProperty<T> getProperty() {
        return this.property;
    }

    public void setValue(T val) {
        super.setValue(this.property.write(val));
    }

    @Override
    public boolean isHoveredOrFocused() {
        return super.isHoveredOrFocused() && LayerWidgetHolder.LayerAwareWidget.isTop((GuiEventListener)this);
    }

    public String toString() {
        return String.format("%s[%s]", ((Object)((Object)this)).getClass().getName(), this.getValue());
    }
}

