/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.client.widget;

import com.legacy.structure_gel.core.client.widget.TooltipSpriteButton;
import com.legacy.structure_gel.core.item.building_tool.ToolModeProperty;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;

public class PropertyImageButton<T extends StringRepresentable>
extends TooltipSpriteButton {
    public static final int DEFAULT_WIDTH = 100;
    public static final int DEFAULT_HEIGHT = 24;
    protected final Component name;
    protected final ToolModeProperty.SelectionProp<T> property;
    protected T currentValue;

    public PropertyImageButton(int x, int y, WidgetSprites sprites, OnPress<PropertyImageButton<T>> onPress, Component name, ToolModeProperty.SelectionProp<T> property, T currentVal) {
        this(x, y, 100, 24, sprites, onPress, name, property, currentVal);
    }

    public PropertyImageButton(int x, int y, int width, int height, WidgetSprites sprites, OnPress<PropertyImageButton<T>> onPress, Component name, ToolModeProperty.SelectionProp<T> property, T currentVal) {
        super(x, y, width, height, sprites, b -> {
            if (b instanceof PropertyImageButton) {
                onPress.onPress((PropertyImageButton)b);
            }
        }, property.getNameComponent());
        this.name = name;
        this.property = property;
        this.currentValue = currentVal;
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
        Minecraft mc = Minecraft.getInstance();
        int color = this.isHoveredOrFocused() ? 0xFFFFFF : 0xCDCDCD;
        MutableComponent keyComp = Component.literal((String)(this.name.getString() + ": "));
        int keyStartX = this.getX() + 4;
        int keyY = this.getY() + 8;
        graphics.drawString(mc.font, (Component)keyComp, keyStartX, keyY, color);
        int start = keyStartX + mc.font.width((FormattedText)keyComp);
        int end = this.getX() + this.getWidth() - 3;
        Component valueComp = this.property.getValueComponent(this.currentValue);
        PropertyImageButton.renderLeftAlignedScrollingString(graphics, mc.font, valueComp, start, end, keyY, this.getHeight() + 10, color);
    }

    protected static void renderLeftAlignedScrollingString(GuiGraphics graphics, Font font, Component text, int xMinBounds, int xMaxBounds, int yPlacement, int yMargin, int color) {
        int xBounds;
        int width = font.width((FormattedText)text);
        if (width > (xBounds = xMaxBounds - xMinBounds)) {
            int delta = width - xBounds;
            double d0 = (double)Util.getMillis() / 1000.0;
            double d1 = Math.max((double)delta * 0.5, 3.0);
            double d2 = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d0 / d1)) / 2.0 + 0.5;
            double scrollAmount = Mth.lerp((double)d2, (double)0.0, (double)delta);
            graphics.enableScissor(xMinBounds, yPlacement - yMargin, xMaxBounds, yPlacement + yMargin);
            graphics.drawString(font, text, xMinBounds - (int)scrollAmount, yPlacement, color);
            graphics.disableScissor();
        } else {
            graphics.drawString(font, text, xMinBounds, yPlacement, color);
        }
    }

    public void cycleValue(boolean forward) {
        List<T> vals = this.property.getAllValues();
        int index = vals.indexOf(this.currentValue);
        index = forward ? --index : ++index;
        int size = vals.size();
        if (index >= size) {
            index = 0;
        }
        if (index < 0) {
            index = size - 1;
        }
        this.currentValue = (StringRepresentable)vals.get(index);
    }

    public void onPress() {
        this.cycleValue(Screen.hasShiftDown());
        super.onPress();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        boolean up = deltaY > 0.0;
        this.cycleValue(!up);
        this.playDownSound(Minecraft.getInstance().getSoundManager());
        super.onPress();
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    public ToolModeProperty.SelectionProp<T> getProperty() {
        return this.property;
    }

    public T getSelectedValue() {
        return this.currentValue;
    }

    @Override
    public String toString() {
        return String.format("%s[%s=%s]", ((Object)((Object)this)).getClass().getName(), this.property.getKey(), this.currentValue.getSerializedName());
    }

    public static interface OnPress<T extends PropertyImageButton<?>> {
        public void onPress(T var1);
    }
}

