/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;

public class GetFeaturesCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.literal((String)"getfeatures").requires(source -> source.hasPermission(2));
        command.then(((LiteralArgumentBuilder)Commands.literal((String)"here").executes(c -> GetFeaturesCommand.here((CommandContext<CommandSourceStack>)c, BlockPos.containing((Position)((CommandSourceStack)c.getSource()).getPosition())))).then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(c -> GetFeaturesCommand.here((CommandContext<CommandSourceStack>)c, BlockPosArgument.getLoadedBlockPos((CommandContext)c, (String)"pos")))));
        command.then(((LiteralArgumentBuilder)Commands.literal((String)"biome").executes(c -> GetFeaturesCommand.biome((CommandContext<CommandSourceStack>)c))).then(Commands.argument((String)"biome", (ArgumentType)ResourceKeyArgument.key((ResourceKey)Registries.BIOME)).executes(c -> GetFeaturesCommand.biome((CommandContext<CommandSourceStack>)c, (ResourceKey<Biome>)((ResourceKey)c.getArgument("biome", ResourceKey.class))))));
        return command;
    }

    private static int here(CommandContext<CommandSourceStack> context, BlockPos pos) {
        return GetFeaturesCommand.biome(context, (Holder<Biome>)((CommandSourceStack)context.getSource()).getLevel().getBiome(pos));
    }

    private static int biome(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        return GetFeaturesCommand.biome(context, (Holder<Biome>)source.getLevel().getBiome(BlockPos.containing((Position)source.getPosition())));
    }

    private static int biome(CommandContext<CommandSourceStack> context, ResourceKey<Biome> biomeKey) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Optional opBiome = source.getLevel().registryAccess().lookupOrThrow(Registries.BIOME).get(biomeKey);
        if (opBiome.isPresent()) {
            return GetFeaturesCommand.biome(context, (Holder<Biome>)((Holder)opBiome.get()));
        }
        source.sendFailure((Component)Component.literal((String)"The biome you're targeting is unregistered."));
        return 0;
    }

    private static int biome(CommandContext<CommandSourceStack> context, Holder<Biome> biome) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String biomeName = biome.unwrapKey().map(k -> k.location().toString()).orElse("Biome Not Registered");
        source.sendSuccess(() -> Component.literal((String)("[" + biomeName + "]")).withStyle(ChatFormatting.GREEN), true);
        List features = ((Biome)biome.value()).getGenerationSettings().features().stream().flatMap(HolderSet::stream).toList();
        if (features.isEmpty()) {
            source.sendSuccess(() -> Component.literal((String)(biomeName + " has no features.")), true);
        } else {
            features.stream().map(Holder::unwrapKey).map(op -> op.map(k -> k.location().toString()).orElse("Not registered")).forEach(s -> source.sendSuccess(() -> Component.literal((String)(" - " + s)), true));
        }
        return features.size();
    }
}

