/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.chunk.ChunkGenerator;

public class GetSpawnsCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"getspawns").requires(source -> source.hasPermission(2))).executes(context -> GetSpawnsCommand.getSpawns((CommandContext<CommandSourceStack>)context, MobCategory.values()));
        for (MobCategory category : MobCategory.values()) {
            command.then(Commands.literal((String)category.getName()).executes(context -> GetSpawnsCommand.getSpawns((CommandContext<CommandSourceStack>)context, category)));
        }
        return command;
    }

    private static int getSpawns(CommandContext<CommandSourceStack> context, MobCategory ... categories) {
        LinkedHashMap<MobCategory, WeightedRandomList<MobSpawnSettings.SpawnerData>> map = new LinkedHashMap<MobCategory, WeightedRandomList<MobSpawnSettings.SpawnerData>>();
        for (MobCategory category : categories) {
            WeightedRandomList<MobSpawnSettings.SpawnerData> list = GetSpawnsCommand.getSpawnList(context, category);
            if (list.isEmpty()) continue;
            map.put(category, list);
        }
        if (!map.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"--Spawn Data--"), true);
            map.entrySet().stream().sorted(new ClassificationComparator()).forEach(e -> GetSpawnsCommand.printSpawns(context, (MobCategory)e.getKey(), (WeightedRandomList<MobSpawnSettings.SpawnerData>)((WeightedRandomList)e.getValue())));
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"No spawn data."), true);
        }
        return 1;
    }

    private static WeightedRandomList<MobSpawnSettings.SpawnerData> getSpawnList(CommandContext<CommandSourceStack> context, MobCategory category) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        BlockPos pos = BlockPos.containing((Position)((CommandSourceStack)context.getSource()).getPosition());
        Holder biome = level.getBiome(pos);
        ServerChunkCache chunkSource = level.getChunkSource();
        ChunkGenerator chunkGen = chunkSource.getGenerator();
        StructureManager manager = level.structureManager();
        WeightedRandomList list = chunkGen.getMobsAt(biome, manager, category, pos);
        return list;
    }

    private static void printSpawns(CommandContext<CommandSourceStack> context, MobCategory category, WeightedRandomList<MobSpawnSettings.SpawnerData> spawns) {
        if (!spawns.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("[" + category.getName() + "]")).withStyle(ChatFormatting.GREEN), true);
            spawns.unwrap().stream().sorted(new SpawnInfoComparator()).forEach(spawn -> ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)String.format(" - %s, weight:%d, min:%d, max:%d", BuiltInRegistries.ENTITY_TYPE.getKey((Object)spawn.type), spawn.getWeight().asInt(), spawn.minCount, spawn.maxCount)), true));
        }
    }

    private static class ClassificationComparator<T extends Map.Entry<MobCategory, WeightedRandomList<MobSpawnSettings.SpawnerData>>>
    implements Comparator<T> {
        private ClassificationComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            return ((MobCategory)o1.getKey()).getName().compareTo(((MobCategory)o2.getKey()).getName());
        }
    }

    private static class SpawnInfoComparator<T extends MobSpawnSettings.SpawnerData>
    implements Comparator<T> {
        private SpawnInfoComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            ResourceLocation n1 = BuiltInRegistries.ENTITY_TYPE.getKey((Object)((MobSpawnSettings.SpawnerData)o1).type);
            ResourceLocation n2 = BuiltInRegistries.ENTITY_TYPE.getKey((Object)((MobSpawnSettings.SpawnerData)o2).type);
            if (n1 == null || n2 == null) {
                return 0;
            }
            return n1.toString().compareTo(n2.toString());
        }
    }
}

