/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.data_components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public record BuildingToolProperties(Map<String, String> properties) {
    public static final Codec<BuildingToolProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).fieldOf("properties").forGetter(r -> r.properties)).apply((Applicative)instance, BuildingToolProperties::new));
    public static final StreamCodec<FriendlyByteBuf, BuildingToolProperties> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, BuildingToolProperties>(){

        public BuildingToolProperties decode(FriendlyByteBuf buff) {
            HashMap<String, String> props = new HashMap<String, String>();
            int size = buff.readInt();
            for (int i = 0; i < size; ++i) {
                String key = buff.readUtf();
                String value = buff.readUtf();
                props.put(key, value);
            }
            return new BuildingToolProperties(props);
        }

        public void encode(FriendlyByteBuf buff, BuildingToolProperties value) {
            Map<String, String> props = value.properties;
            int size = props.size();
            buff.writeInt(size);
            for (Map.Entry<String, String> entry : props.entrySet()) {
                buff.writeUtf(entry.getKey());
                buff.writeUtf(entry.getValue());
            }
        }
    };
    public static final BuildingToolProperties DEFAULT = new BuildingToolProperties(Map.of());

    public boolean contains(String key) {
        return this.properties.containsKey(key);
    }

    @Nullable
    public String get(String key) {
        return this.properties.get(key);
    }

    public Map<String, String> getProperties() {
        return new HashMap<String, String>(this.properties);
    }

    public BuildingToolProperties withValue(String key, String value) {
        Map<String, String> props = this.getProperties();
        props.put(key, value);
        return new BuildingToolProperties(props);
    }
}

