/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.item.building_tool;

import com.legacy.structure_gel.api.registry.SGSimpleRegistry;
import com.legacy.structure_gel.api.util.SGCodecs;
import com.legacy.structure_gel.core.SGConfig;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.capability.level.BuildingToolPlayerData;
import com.legacy.structure_gel.core.capability.level.BuildingToolWorldData;
import com.legacy.structure_gel.core.capability.misc.LevelTicksData;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolMode;
import com.legacy.structure_gel.core.registry.SGRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ActionHistory {
    public static final Codec<ActionHistory> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("player").forGetter(i -> i.player), (App)Action.CODEC.listOf().fieldOf("actions").forGetter(i -> i.actions), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("last_action").forGetter(i -> i.lastActionIndex), (App)Codec.LONG.optionalFieldOf("last_modified", (Object)0L).forGetter(i -> i.lastModified)).apply((Applicative)instance, ActionHistory::new));
    private String player;
    private final LinkedList<Action> actions;
    private int lastActionIndex;
    private boolean dirty = false;
    private long lastModified = 0L;
    public static final ActionHistory EMPTY = new ActionHistory("EMPTY"){

        @Override
        public void add(Level level, ActionBuilder action) {
        }

        @Override
        public boolean undo(ServerPlayer player) {
            return false;
        }

        @Override
        public boolean redo(ServerPlayer player) {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    };
    private boolean spamming = false;

    public ActionHistory(String player, List<Action> actions, int lastActionIndex, long lastModified) {
        this.player = player;
        this.actions = new LinkedList<Action>(actions);
        this.lastActionIndex = lastActionIndex;
        this.lastModified = lastModified;
    }

    public ActionHistory(String player) {
        this(player, Collections.emptyList(), 0, 0L);
    }

    public static ActionHistory get(Player player) {
        return ActionHistory.get(player.getGameProfile().getName(), player.level());
    }

    public static ActionHistory get(String playerName, Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return BuildingToolPlayerData.get(serverLevel, playerName).getActionHistory();
        }
        return EMPTY;
    }

    public static Set<String> getHistoryOwners(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return BuildingToolWorldData.get(serverLevel).getPlayers();
        }
        return Collections.emptySet();
    }

    public static Set<String> getHistoryOwners(MinecraftServer server) {
        HashSet<String> owners = new HashSet<String>();
        server.getAllLevels().forEach(level -> owners.addAll(ActionHistory.getHistoryOwners((Level)level)));
        return owners;
    }

    public String getPlayer() {
        return this.player;
    }

    public void add(Level level, ActionBuilder action) {
        long oldModified = this.lastModified;
        this.modified(level);
        long timeSinceLastModification = this.lastModified - oldModified;
        boolean wasSpamming = this.spamming;
        if (timeSinceLastModification > 2L) {
            this.spamming = false;
            while (this.lastActionIndex > 0) {
                this.actions.removeFirst();
                --this.lastActionIndex;
            }
        } else {
            this.spamming = true;
            Action firstAction = this.actions.pollFirst();
            action.insertOld(firstAction);
            if (!wasSpamming) {
                Action secondAction = this.actions.pollFirst();
                action.insertOld(secondAction);
            }
        }
        this.actions.addFirst(action.build(level));
        while (this.actions.size() > SGConfig.COMMON.getBuildingToolMaxUndos()) {
            this.actions.removeLast();
        }
    }

    public boolean undo(ServerPlayer player) {
        this.modified(player.level());
        if (this.lastActionIndex < this.actions.size()) {
            if (this.actions.get(this.lastActionIndex).undo(player, player.serverLevel())) {
                ++this.lastActionIndex;
            }
            return true;
        }
        return false;
    }

    public boolean redo(ServerPlayer player) {
        this.modified(player.level());
        if (this.lastActionIndex > 0) {
            if (this.actions.get(this.lastActionIndex - 1).redo(player, player.serverLevel())) {
                --this.lastActionIndex;
            }
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean changed) {
        this.dirty = changed;
    }

    public void setModified(long time) {
        this.lastModified = time;
        this.setDirty(true);
    }

    public void modified(Level level) {
        this.lastModified = level.getGameTime();
        this.setModified(this.lastModified);
    }

    public boolean isExpired(Level level) {
        return this.isEmpty() || level.getGameTime() - this.lastModified > SGConfig.COMMON.buildingToolHistoryExpiration();
    }

    public boolean isEmpty() {
        return this.actions.isEmpty();
    }

    public void clear() {
        this.actions.clear();
        this.lastActionIndex = 0;
    }

    public static ActionBuilder newAction(@Nullable Level level, boolean causeUpdates) {
        return new ActionBuilder(level, causeUpdates);
    }

    public static void init() {
        Change.init();
    }

    private record Action(Change[] changes, boolean causeUpdates) {
        public static final Codec<Action> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Change.CODEC.listOf().fieldOf("changes").xmap(l -> (Change[])l.toArray(Change[]::new), Arrays::asList).forGetter(Action::changes), (App)Codec.BOOL.optionalFieldOf("cause_updates", (Object)false).forGetter(Action::causeUpdates)).apply((Applicative)instance, Action::new));
        private static final String UNDO_KEY = "info.structure_gel.building_tool.message.undo";
        private static final String REDO_KEY = "info.structure_gel.building_tool.message.redo";

        public boolean undo(ServerPlayer player, ServerLevel level) {
            if (!this.causeUpdates) {
                LevelTicksData.shouldScheduleTicks((Level)level, false);
            }
            int totalChanges = this.getChangeTotal();
            ActionCounter actionCounter = new ActionCounter(a -> this.sendMessage(player, UNDO_KEY, a.lastPercent, a.count, totalChanges));
            for (int i = this.changes.length - 1; i > -1; --i) {
                this.changes[i].undo(player, level, actionCounter);
            }
            if (!this.causeUpdates) {
                LevelTicksData.shouldScheduleTicks((Level)level, true);
            }
            return true;
        }

        public boolean redo(ServerPlayer player, ServerLevel level) {
            if (!this.causeUpdates) {
                LevelTicksData.shouldScheduleTicks((Level)level, false);
            }
            int totalChanges = this.getChangeTotal();
            ActionCounter actionCounter = new ActionCounter(a -> this.sendMessage(player, REDO_KEY, a.lastPercent, a.count, totalChanges));
            for (Change change : this.changes) {
                change.redo(player, level, actionCounter);
            }
            if (!this.causeUpdates) {
                LevelTicksData.shouldScheduleTicks((Level)level, true);
            }
            return true;
        }

        private int sendMessage(ServerPlayer player, String key, int lastPercent, int changes, int totalChanges) {
            int percent = Math.round((float)changes / (float)totalChanges * 100.0f);
            if (percent - lastPercent >= 1 || percent == 100) {
                player.displayClientMessage((Component)Component.translatable((String)key, (Object[])new Object[]{percent}), true);
            }
            return percent;
        }

        private int getChangeTotal() {
            int total = 0;
            for (Change c : this.changes) {
                total += c.changeCount();
            }
            return total;
        }
    }

    public static class ActionBuilder {
        private final boolean causeUpdates;
        private final Map<Integer, LinkedList<BlockChange>> blockChanges = new HashMap<Integer, LinkedList<BlockChange>>();
        private final LinkedList<Change> changes = new LinkedList();

        private ActionBuilder(@Nullable Level level, boolean causeUpdates) {
            this.causeUpdates = causeUpdates;
            if (!this.causeUpdates) {
                LevelTicksData.shouldScheduleTicks(level, false);
            }
        }

        public ActionBuilder insertOld(@Nullable Action action) {
            if (action != null) {
                Change[] changes = action.changes;
                for (int i = changes.length - 1; i > -1; --i) {
                    this.changes.addFirst(changes[i]);
                }
            }
            return this;
        }

        public ActionBuilder changeBlock(BlockPos pos, BlockState oldState, @Nullable CompoundTag oldBlockEntity, BlockState newState, @Nullable CompoundTag newBlockEntity, int flags) {
            this.addChange(new BlockChange(pos, oldState, Optional.ofNullable(oldBlockEntity), newState, Optional.ofNullable(newBlockEntity), flags));
            return this;
        }

        public ActionBuilder changeSelection(BuildingToolMode mode, int posIndex, BlockPos oldPos, BlockPos newPos) {
            this.addChange(new SelectionChange(mode, posIndex, oldPos, newPos));
            return this;
        }

        public ActionBuilder addEntity(Entity entity) {
            CompoundTag tag = new CompoundTag();
            entity.save(tag);
            this.addChange(new AddEntity(entity.getUUID(), tag));
            return this;
        }

        public ActionBuilder removeEntity(Entity entity) {
            CompoundTag tag = new CompoundTag();
            entity.save(tag);
            this.addChange(new RemoveEntity(entity.getUUID(), tag));
            return this;
        }

        private void addChange(Change change) {
            if (change instanceof BlockChange) {
                BlockChange blockChange = (BlockChange)change;
                this.blockChanges.computeIfAbsent(blockChange.flags(), flag -> new LinkedList()).add(blockChange);
            } else {
                this.changes.add(change);
            }
        }

        private void compressData() {
            if (!this.blockChanges.isEmpty()) {
                this.blockChanges.forEach((flags, changes) -> this.changes.add(CombinedBlockChange.from(flags, changes)));
            }
        }

        private Action build(@Nullable Level level) {
            if (level != null && !this.causeUpdates) {
                LevelTicksData.shouldScheduleTicks(level, true);
            }
            this.compressData();
            return new Action((Change[])this.changes.toArray(Change[]::new), this.causeUpdates);
        }
    }

    private static interface Change {
        public static final SGSimpleRegistry<ResourceLocation, ChangeType> TYPE_REGISTRY = new SGSimpleRegistry(StructureGelMod.locate("world_change_type"), () -> null, null);
        public static final Codec<Change> CODEC = ResourceLocation.CODEC.xmap(name -> TYPE_REGISTRY.get((ResourceLocation)name), change -> TYPE_REGISTRY.getKey((ChangeType)change)).dispatch(Change::type, ChangeType::codec);

        public static void init() {
            TYPE_REGISTRY.register(StructureGelMod.locate("block_change"), BlockChange.TYPE);
            TYPE_REGISTRY.register(StructureGelMod.locate("combined_block_change"), CombinedBlockChange.TYPE);
            TYPE_REGISTRY.register(StructureGelMod.locate("selection_change"), SelectionChange.TYPE);
            TYPE_REGISTRY.register(StructureGelMod.locate("add_entity"), AddEntity.TYPE);
            TYPE_REGISTRY.register(StructureGelMod.locate("remove_entity"), RemoveEntity.TYPE);
        }

        public void undo(ServerPlayer var1, ServerLevel var2, ActionCounter var3);

        public void redo(ServerPlayer var1, ServerLevel var2, ActionCounter var3);

        public ChangeType type();

        default public int changeCount() {
            return 1;
        }

        public static interface ChangeType {
            public MapCodec<? extends Change> codec();
        }
    }

    private record RemoveEntity(UUID uuid, CompoundTag entity) implements Change
    {
        public static final MapCodec<RemoveEntity> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SGCodecs.UUID.fieldOf("uuid").forGetter(RemoveEntity::uuid), (App)CompoundTag.CODEC.fieldOf("entity").forGetter(RemoveEntity::entity)).apply((Applicative)instance, RemoveEntity::new));
        public static final Change.ChangeType TYPE = () -> CODEC;

        @Override
        public void undo(ServerPlayer player, ServerLevel level, ActionCounter actionsFinished) {
            new AddEntity(this.uuid, this.entity).redo(player, level, actionsFinished);
        }

        @Override
        public void redo(ServerPlayer player, ServerLevel level, ActionCounter actionsFinished) {
            new AddEntity(this.uuid, this.entity).undo(player, level, actionsFinished);
        }

        @Override
        public Change.ChangeType type() {
            return TYPE;
        }
    }

    private record AddEntity(UUID uuid, CompoundTag entity) implements Change
    {
        public static final MapCodec<AddEntity> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SGCodecs.UUID.fieldOf("uuid").forGetter(AddEntity::uuid), (App)CompoundTag.CODEC.fieldOf("entity").forGetter(AddEntity::entity)).apply((Applicative)instance, AddEntity::new));
        public static final Change.ChangeType TYPE = () -> CODEC;

        @Override
        public void undo(ServerPlayer player, ServerLevel level, ActionCounter actionsFinished) {
            Entity entity = level.getEntity(this.uuid);
            if (entity != null) {
                entity.remove(Entity.RemovalReason.DISCARDED);
            }
            actionsFinished.increment();
        }

        @Override
        public void redo(ServerPlayer player, ServerLevel level, ActionCounter actionsFinished) {
            Entity entity = EntityType.create((CompoundTag)this.entity, (Level)level, (EntitySpawnReason)EntitySpawnReason.COMMAND).orElse(null);
            if (entity != null) {
                level.addFreshEntity(entity);
            }
            actionsFinished.increment();
        }

        @Override
        public Change.ChangeType type() {
            return TYPE;
        }
    }

    private record SelectionChange(BuildingToolMode mode, int posIndex, BlockPos oldPos, BlockPos newPos) implements Change
    {
        public static final MapCodec<SelectionChange> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuildingToolMode.CODEC.fieldOf("mode").forGetter(SelectionChange::mode), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("pos_index").forGetter(SelectionChange::posIndex), (App)BlockPos.CODEC.fieldOf("old_pos").forGetter(SelectionChange::oldPos), (App)BlockPos.CODEC.fieldOf("new_pos").forGetter(SelectionChange::newPos)).apply((Applicative)instance, SelectionChange::new));
        public static final Change.ChangeType TYPE = () -> CODEC;

        @Override
        public void undo(ServerPlayer player, ServerLevel level, ActionCounter actionsFinished) {
            this.apply(player, this.oldPos, actionsFinished);
        }

        @Override
        public void redo(ServerPlayer player, ServerLevel level, ActionCounter actionsFinished) {
            this.apply(player, this.newPos, actionsFinished);
        }

        private void apply(ServerPlayer player, BlockPos pos, ActionCounter actionsFinished) {
            ItemStack buildingTool;
            ItemStack mainItem = player.getMainHandItem();
            ItemStack offItem = player.getOffhandItem();
            Object object = mainItem.is((Item)SGRegistry.Items.BUILDING_TOOL.get()) ? mainItem : (buildingTool = offItem.is((Item)SGRegistry.Items.BUILDING_TOOL.get()) ? offItem : null);
            if (buildingTool != null && BuildingToolItem.getMode(buildingTool) == this.mode) {
                BuildingToolItem.setPos(buildingTool, this.posIndex, (Vec3i)pos);
            }
            actionsFinished.increment();
        }

        @Override
        public Change.ChangeType type() {
            return TYPE;
        }
    }

    private record CombinedBlockChange(int flags, List<BlockState> palette, List<Long> blockPositions, List<BlockChangeData> blockData, Map<Integer, BlockEntityChangeData> beData) implements Change
    {
        public static final MapCodec<CombinedBlockChange> CODEC = RecordCodecBuilder.mapCodec(instance -> {
            Codec intAsString = Codec.STRING.xmap(Integer::valueOf, String::valueOf);
            return instance.group((App)Codec.INT.fieldOf("flags").forGetter(CombinedBlockChange::flags), (App)BlockState.CODEC.listOf().optionalFieldOf("palette", List.of()).forGetter(CombinedBlockChange::palette), (App)Codec.LONG.listOf().optionalFieldOf("block_positions", List.of()).forGetter(CombinedBlockChange::blockPositions), (App)BlockChangeData.CODEC.listOf().optionalFieldOf("block_data", List.of()).forGetter(CombinedBlockChange::blockData), (App)Codec.unboundedMap((Codec)intAsString, BlockEntityChangeData.CODEC).optionalFieldOf("be_data", Map.of()).forGetter(CombinedBlockChange::beData)).apply((Applicative)instance, CombinedBlockChange::new);
        });
        public static final Change.ChangeType TYPE = () -> CODEC;

        private static CombinedBlockChange from(int flags, List<BlockChange> blockChanges) {
            ArrayList<BlockState> palette = new ArrayList<BlockState>();
            HashMap<BlockState, Short> reversedPalette = new HashMap<BlockState, Short>();
            ArrayList<Long> blockPositions = new ArrayList<Long>();
            ArrayList<BlockChangeData> blockData = new ArrayList<BlockChangeData>();
            HashMap<Integer, BlockEntityChangeData> beData = new HashMap<Integer, BlockEntityChangeData>();
            short paletteIndex = 0;
            int index = 0;
            for (BlockChange blockChange : blockChanges) {
                short newStateId;
                short oldStateId;
                BlockState oldState = blockChange.oldState;
                BlockState newState = blockChange.newState;
                if (!reversedPalette.containsKey(oldState)) {
                    oldStateId = paletteIndex;
                    palette.add(oldState);
                    short s = paletteIndex;
                    paletteIndex = (short)(paletteIndex + 1);
                    reversedPalette.put(oldState, s);
                } else {
                    oldStateId = (Short)reversedPalette.get(oldState);
                }
                if (!reversedPalette.containsKey(newState)) {
                    newStateId = paletteIndex;
                    palette.add(newState);
                    short s = paletteIndex;
                    paletteIndex = (short)(paletteIndex + 1);
                    reversedPalette.put(newState, s);
                } else {
                    newStateId = (Short)reversedPalette.get(newState);
                }
                long pos = blockChange.pos.asLong();
                blockPositions.add(pos);
                blockData.add(new BlockChangeData(oldStateId, newStateId));
                if (blockChange.oldBlockEntity.isPresent() || blockChange.newBlockEntity.isPresent()) {
                    beData.put(index, new BlockEntityChangeData(blockChange.oldBlockEntity, blockChange.newBlockEntity));
                }
                ++index;
            }
            return new CombinedBlockChange(flags, palette, blockPositions, blockData, beData);
        }

        @Override
        public void undo(ServerPlayer player, ServerLevel level, ActionCounter actionsFinished) {
            this.apply(player, level, c -> c.undo(player, level, actionsFinished), true);
        }

        @Override
        public void redo(ServerPlayer player, ServerLevel level, ActionCounter actionsFinished) {
            this.apply(player, level, c -> c.redo(player, level, actionsFinished), false);
        }

        private void apply(ServerPlayer player, ServerLevel level, Consumer<BlockChange> action, boolean reverseOrder) {
            int i;
            int size = this.blockPositions.size();
            int n = i = reverseOrder ? size - 1 : 0;
            while (reverseOrder ? i > -1 : i < size) {
                BlockChangeData change = this.blockData.get(i);
                BlockEntityChangeData beChange = this.beData.getOrDefault(i, BlockEntityChangeData.EMPTY);
                BlockChange c = new BlockChange(BlockPos.of((long)this.blockPositions.get(i)), this.palette.get(change.oldState), beChange.oldBlockEntity, this.palette.get(change.newState), beChange.newBlockEntity, this.flags);
                action.accept(c);
                i = reverseOrder ? i - 1 : i + 1;
            }
        }

        @Override
        public Change.ChangeType type() {
            return TYPE;
        }

        @Override
        public int changeCount() {
            return this.blockPositions.size();
        }

        private record BlockChangeData(short oldState, short newState) {
            public static final Codec<BlockChangeData> CODEC = Codec.INT.xmap(i -> new BlockChangeData((short)(i >> 16), (short)(i & Short.MAX_VALUE)), b -> b.oldState << 16 | b.newState);
        }

        private record BlockEntityChangeData(Optional<CompoundTag> oldBlockEntity, Optional<CompoundTag> newBlockEntity) {
            public static final Codec<BlockEntityChangeData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CompoundTag.CODEC.optionalFieldOf("old_be").forGetter(BlockEntityChangeData::oldBlockEntity), (App)CompoundTag.CODEC.optionalFieldOf("new_be").forGetter(BlockEntityChangeData::newBlockEntity)).apply((Applicative)instance, BlockEntityChangeData::new));
            public static final BlockEntityChangeData EMPTY = new BlockEntityChangeData(Optional.empty(), Optional.empty());
        }
    }

    private record BlockChange(BlockPos pos, BlockState oldState, Optional<CompoundTag> oldBlockEntity, BlockState newState, Optional<CompoundTag> newBlockEntity, int flags) implements Change
    {
        public static final MapCodec<BlockChange> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockPos.CODEC.fieldOf("pos").forGetter(BlockChange::pos), (App)BlockState.CODEC.fieldOf("old_state").forGetter(BlockChange::oldState), (App)CompoundTag.CODEC.optionalFieldOf("old_be").forGetter(BlockChange::oldBlockEntity), (App)BlockState.CODEC.fieldOf("new_state").forGetter(BlockChange::newState), (App)CompoundTag.CODEC.optionalFieldOf("new_be").forGetter(BlockChange::newBlockEntity), (App)Codec.INT.optionalFieldOf("flags", (Object)19).forGetter(BlockChange::flags)).apply((Applicative)instance, BlockChange::new));
        public static final Change.ChangeType TYPE = () -> CODEC;

        @Override
        public void undo(ServerPlayer player, ServerLevel level, ActionCounter actionsFinished) {
            this.apply(level, this.oldState, this.oldBlockEntity, actionsFinished);
        }

        @Override
        public void redo(ServerPlayer player, ServerLevel level, ActionCounter actionsFinished) {
            this.apply(level, this.newState, this.newBlockEntity, actionsFinished);
        }

        private void apply(ServerLevel level, BlockState state, Optional<CompoundTag> blockEntityTag, ActionCounter actionsFinished) {
            BlockPos pos = this.pos;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity != null) {
                Clearable.tryClear((Object)blockEntity);
                level.setBlock(pos, Blocks.AIR.defaultBlockState(), 18);
            }
            level.setBlock(pos, state, this.flags);
            if (blockEntityTag.isPresent()) {
                level.getBlockEntity(pos).loadWithComponents(blockEntityTag.get(), (HolderLookup.Provider)level.registryAccess());
            }
            actionsFinished.increment();
        }

        @Override
        public Change.ChangeType type() {
            return TYPE;
        }
    }

    private static class ActionCounter {
        int lastPercent = 0;
        int count = 0;
        final Function<ActionCounter, Integer> onIncrement;

        ActionCounter(Function<ActionCounter, Integer> onIncrement) {
            this.onIncrement = onIncrement;
        }

        void increment() {
            ++this.count;
            this.lastPercent = this.onIncrement.apply(this);
        }
    }
}

