/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.item.building_tool;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.legacy.structure_gel.core.SGConfig;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableInt;

public class CapturedBlocks {
    public static final Codec<CapturedBlocks> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.CODEC.fieldOf(WORLD_POS_KEY).forGetter(CapturedBlocks::getWorldPos), (App)BlockPos.CODEC.fieldOf(CENTER_OFFSET_KEY).forGetter(CapturedBlocks::getCenterPos), (App)BoundingBox.CODEC.fieldOf(BOUNDS_KEY).forGetter(CapturedBlocks::getBounds), (App)BlockInfo.CODEC.listOf().fieldOf("block_infos").forGetter(CapturedBlocks::getBlockInfos), (App)EntityInfo.CODEC.listOf().fieldOf("entity_infos").forGetter(CapturedBlocks::getEntityInfos), (App)Mirror.CODEC.fieldOf(MIRROR_KEY).forGetter(CapturedBlocks::getMirror), (App)Rotation.CODEC.fieldOf(ROTATION_KEY).forGetter(CapturedBlocks::getRotation)).apply((Applicative)instance, CapturedBlocks::new));
    private final BlockPos worldPos;
    private final BlockPos centerOffset;
    private final BoundingBox bounds;
    private List<BlockInfo> blockInfos;
    private final List<EntityInfo> entityInfos;
    private final Mirror mirror;
    private final Rotation rotation;
    @Nullable
    private CapturedBlocks lastTransform = null;
    @Nullable
    private CapturedBlocks clientCopy = null;
    @Nullable
    private Map<BlockPos, VoxelShape> shapeCache = null;
    @Nullable
    private List<AABB> entityBoxesCache = null;
    boolean compressedForRender = false;
    private static final String PALETTE_KEY = "palette";
    private static final String DEFAULT_STATE_KEY = "default_state";
    private static final String BLOCKS_KEY = "blocks";
    private static final String STATE_KEY = "state";
    private static final String TAG_KEY = "tag";
    private static final String BOUNDS_KEY = "bounds";
    private static final String WORLD_POS_KEY = "world_pos";
    private static final String CENTER_OFFSET_KEY = "center_offset";
    private static final String MIRROR_KEY = "mirror";
    private static final String ROTATION_KEY = "rotation";
    private static final String ENTITIES_KEY = "entities";
    private static final String ENTITY_KEY = "entity";
    private static final String POS_KEY = "pos";
    private static final String UUID_KEY = "uuid";

    private CapturedBlocks(BlockPos worldPos, BlockPos centerOffset, BoundingBox bounds, List<BlockInfo> blockInfos, List<EntityInfo> entityInfos, Mirror mirror, Rotation rotation) {
        this.worldPos = worldPos;
        this.centerOffset = centerOffset;
        this.bounds = bounds;
        this.blockInfos = blockInfos;
        this.entityInfos = entityInfos;
        this.mirror = mirror;
        this.rotation = rotation;
    }

    public CapturedBlocks copy() {
        return new CapturedBlocks(this.worldPos, this.centerOffset, this.bounds, this.blockInfos, this.entityInfos, this.mirror, this.rotation);
    }

    public CapturedBlocks clientCopy() {
        if (this.clientCopy == null) {
            this.clientCopy = this.copy();
        }
        return this.clientCopy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CapturedBlocks) {
            CapturedBlocks other = (CapturedBlocks)obj;
            if (!this.worldPos.equals((Object)other.worldPos)) {
                return false;
            }
            if (!this.centerOffset.equals((Object)other.centerOffset)) {
                return false;
            }
            if (!this.bounds.equals((Object)other.bounds)) {
                return false;
            }
            if (!this.mirror.equals((Object)other.mirror)) {
                return false;
            }
            if (!this.rotation.equals((Object)other.rotation)) {
                return false;
            }
            if (!this.blockInfos.equals(other.blockInfos)) {
                return false;
            }
            return this.entityInfos.equals(other.entityInfos);
        }
        return false;
    }

    public CapturedBlocks(Level level, BlockPos cornerA, BlockPos cornerB, boolean includeEntities) {
        this(level, cornerA, cornerB, Mirror.NONE, Rotation.NONE, includeEntities);
    }

    public CapturedBlocks(Level level, BlockPos cornerA, BlockPos cornerB, Mirror mirror, Rotation rotation, boolean includeEntities) {
        Vec3i bbLength;
        BoundingBox bounds = BoundingBox.fromCorners((Vec3i)cornerA, (Vec3i)cornerB);
        LinkedList<BlockInfo> infos = new LinkedList<BlockInfo>();
        int minX = bounds.minX();
        int minY = bounds.minY();
        int minZ = bounds.minZ();
        int maxX = bounds.maxX();
        int maxY = bounds.maxY();
        int maxZ = bounds.maxZ();
        Vec3i transformedBBLength = bbLength = bounds.getLength();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = level.getBlockState(pos);
                    BlockEntity blockEntity = level.getBlockEntity(pos);
                    CompoundTag blockEntityTag = blockEntity != null ? blockEntity.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess()) : null;
                    BlockPos transformedPos = this.transformPos(new BlockPos(x - minX, y - minY, z - minZ), bbLength, mirror, rotation);
                    infos.add(new BlockInfo(transformedPos, state.mirror(mirror).rotate(rotation), Optional.ofNullable(blockEntityTag)));
                }
            }
        }
        if (rotation == Rotation.CLOCKWISE_90 || rotation == Rotation.COUNTERCLOCKWISE_90) {
            bounds = BoundingBox.fromCorners((Vec3i)new Vec3i(minX, minY, minZ), (Vec3i)new Vec3i(minX + bbLength.getZ(), maxY, minZ + bbLength.getX()));
            transformedBBLength = bounds.getLength();
        }
        this.bounds = bounds;
        this.centerOffset = new BlockPos(-transformedBBLength.getX() + transformedBBLength.getX() / 2, 0, -transformedBBLength.getZ() + transformedBBLength.getZ() / 2);
        this.worldPos = new BlockPos(bounds.minX(), bounds.minY(), bounds.minZ());
        if (includeEntities) {
            ArrayList<EntityInfo> entityInfos = new ArrayList<EntityInfo>();
            List entities = level.getEntities(null, AABB.of((BoundingBox)this.bounds));
            for (Entity entity : entities) {
                if (entity instanceof Player) continue;
                Vec3 pos = this.transformPos(entity.position().subtract(Vec3.atLowerCornerOf((Vec3i)this.worldPos)), bbLength, mirror, rotation);
                CompoundTag entityTag = new CompoundTag();
                entity.save(entityTag);
                entityTag.remove("UUID");
                entityInfos.add(new EntityInfo(entity.getUUID(), pos, entityTag));
            }
            this.entityInfos = entityInfos;
        } else {
            this.entityInfos = Collections.emptyList();
        }
        this.blockInfos = new ArrayList<BlockInfo>(infos);
        this.mirror = mirror;
        this.rotation = rotation;
    }

    public CapturedBlocks withTransforms(Mirror mirror, Rotation rotation) {
        Vec3i bbLength;
        if (this.lastTransform != null && this.lastTransform.mirror == mirror && this.lastTransform.rotation == rotation) {
            return this.lastTransform;
        }
        BoundingBox bounds = this.bounds;
        ArrayList<BlockInfo> blockInfos = new ArrayList<BlockInfo>(this.blockInfos.size());
        int minX = bounds.minX();
        int minY = bounds.minY();
        int minZ = bounds.minZ();
        int maxY = bounds.maxY();
        Vec3i transformedBBLength = bbLength = bounds.getLength();
        for (BlockInfo info : this.blockInfos) {
            BlockPos pos = info.pos;
            BlockPos transformedPos = this.transformPos(pos, bbLength, mirror, rotation);
            blockInfos.add(new BlockInfo(transformedPos, info.state.mirror(mirror).rotate(rotation), info.blockEntityTag));
        }
        if (rotation == Rotation.CLOCKWISE_90 || rotation == Rotation.COUNTERCLOCKWISE_90) {
            bounds = BoundingBox.fromCorners((Vec3i)new Vec3i(minX, minY, minZ), (Vec3i)new Vec3i(minX + bbLength.getZ(), maxY, minZ + bbLength.getX()));
            transformedBBLength = bounds.getLength();
        }
        BlockPos centerOffset = new BlockPos(-transformedBBLength.getX() + transformedBBLength.getX() / 2, 0, -transformedBBLength.getZ() + transformedBBLength.getZ() / 2);
        BlockPos worldPos = new BlockPos(bounds.minX(), bounds.minY(), bounds.minZ());
        ArrayList<EntityInfo> entityInfos = new ArrayList<EntityInfo>();
        for (EntityInfo info : this.entityInfos) {
            Vec3 pos = info.pos;
            Vec3 transformedPos = this.transformPos(pos, bbLength, mirror, rotation);
            entityInfos.add(new EntityInfo(info.original, transformedPos, info.entityTag));
        }
        this.lastTransform = new CapturedBlocks(worldPos, centerOffset, bounds, blockInfos, entityInfos, mirror, rotation);
        return this.lastTransform;
    }

    public void compressForRender(Level level, BlockPos startPos, Player player) {
        if (this.compressedForRender) {
            return;
        }
        int maxTime = SGConfig.CLIENT.maxCloneCompileTime();
        boolean timeExceeded = false;
        long startTime = System.currentTimeMillis();
        Map<BlockPos, BlockState> positions = this.blockInfos.stream().collect(Collectors.toMap(BlockInfo::pos, BlockInfo::state));
        ArrayList<BlockInfo> newBlockInfos = new ArrayList<BlockInfo>(this.blockInfos.size() / 3);
        for (BlockInfo info : this.blockInfos) {
            boolean remove = true;
            BlockPos pos = info.pos;
            for (Direction dir : Direction.values()) {
                BlockPos offset = pos.relative(dir);
                BlockState offsetState = positions.get(offset);
                if (offsetState != null && offsetState.isSolidRender()) continue;
                remove = false;
                break;
            }
            if (!remove) {
                newBlockInfos.add(info);
            }
            if (System.currentTimeMillis() - startTime <= (long)maxTime) continue;
            timeExceeded = true;
            break;
        }
        if (timeExceeded) {
            player.displayClientMessage((Component)Component.literal((String)("[Structure Gel] A Building Tool render tool longer than " + maxTime + "ms to compile. Aborting.")).withStyle(ChatFormatting.RED), false);
            this.blockInfos = new ArrayList<BlockInfo>(0);
        } else {
            this.blockInfos = newBlockInfos;
        }
        this.compressedForRender = true;
    }

    private BlockPos transformPos(BlockPos pos, Vec3i size, Mirror mirror, Rotation rotation) {
        if (mirror == Mirror.NONE && rotation == Rotation.NONE) {
            return pos;
        }
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        switch (mirror) {
            case LEFT_RIGHT: {
                z = size.getZ() - z;
                break;
            }
            case FRONT_BACK: {
                x = size.getX() - x;
                break;
            }
        }
        switch (rotation) {
            case CLOCKWISE_90: {
                int invZ = size.getZ() - z;
                z = x;
                x = invZ;
                break;
            }
            case CLOCKWISE_180: {
                x = size.getX() - x;
                z = size.getZ() - z;
                break;
            }
            case COUNTERCLOCKWISE_90: {
                int invX = size.getX() - x;
                x = z;
                z = invX;
                break;
            }
        }
        return new BlockPos(x, y, z);
    }

    private Vec3 transformPos(Vec3 pos, Vec3i size, Mirror mirror, Rotation rotation) {
        if (mirror == Mirror.NONE && rotation == Rotation.NONE) {
            return pos;
        }
        size = size.offset(1, 1, 1);
        double x = pos.x();
        double y = pos.y();
        double z = pos.z();
        switch (mirror) {
            case LEFT_RIGHT: {
                z = (double)size.getZ() - z;
                break;
            }
            case FRONT_BACK: {
                x = (double)size.getX() - x;
                break;
            }
        }
        switch (rotation) {
            case CLOCKWISE_90: {
                double invZ = (double)size.getZ() - z;
                z = x;
                x = invZ;
                break;
            }
            case CLOCKWISE_180: {
                x = (double)size.getX() - x;
                z = (double)size.getZ() - z;
                break;
            }
            case COUNTERCLOCKWISE_90: {
                double invX = (double)size.getX() - x;
                x = z;
                z = invX;
                break;
            }
        }
        return new Vec3(x, y, z);
    }

    public BoundingBox getBounds() {
        return this.bounds;
    }

    public BlockPos getCenterPos() {
        return this.centerOffset;
    }

    public BlockPos getWorldPos() {
        return this.worldPos;
    }

    public Mirror getMirror() {
        return this.mirror;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public List<BlockInfo> getBlockInfos() {
        return Collections.unmodifiableList(this.blockInfos);
    }

    public List<EntityInfo> getEntityInfos() {
        return Collections.unmodifiableList(this.entityInfos);
    }

    public Map<BlockPos, VoxelShape> getShapes(Level level, BlockPos worldPos) {
        if (this.shapeCache == null) {
            this.shapeCache = this.getBlockInfos().stream().collect(Collectors.toMap(b -> worldPos.offset((Vec3i)b.pos()), b -> b.state().getShape((BlockGetter)level, b.pos())));
        }
        return this.shapeCache;
    }

    public List<AABB> getEntityBoxes(Level level, BlockPos worldPos) {
        if (this.entityBoxesCache == null) {
            this.entityBoxesCache = this.entityInfos.stream().map(info -> info.createEntity(level, worldPos, this.mirror, this.rotation)).filter(e -> e != null).map(Entity::getBoundingBox).map(aabb -> aabb.getSize() <= 0.0 ? AABB.ofSize((Vec3)aabb.getCenter(), (double)0.75, (double)0.75, (double)0.75) : aabb).toList();
        }
        return this.entityBoxesCache;
    }

    public CompoundTag toCompressedTag(HolderLookup.Provider registryAccess) {
        CompoundTag tag = new CompoundTag();
        HashBiMap states = HashBiMap.create();
        HashMap<Object, MutableInt> stateUsage = new HashMap<Object, MutableInt>();
        for (BlockInfo info : this.blockInfos) {
            BlockState state = info.state;
            states.computeIfAbsent((Object)state, arg_0 -> CapturedBlocks.lambda$toCompressedTag$6((BiMap)states, arg_0));
            if (info.blockEntityTag.isPresent()) continue;
            MutableInt count = (MutableInt)stateUsage.get(state);
            if (count == null) {
                stateUsage.put(state, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BlockState mostUsed = stateUsage.entrySet().stream().sorted((a, b) -> ((MutableInt)b.getValue()).compareTo((MutableInt)a.getValue())).map(Map.Entry::getKey).findFirst().orElse(null);
        if (mostUsed != null) {
            tag.put(DEFAULT_STATE_KEY, (Tag)NbtUtils.writeBlockState((BlockState)mostUsed));
        }
        ListTag paletteTag = new ListTag();
        for (Object state : states.keySet()) {
            paletteTag.add((Object)NbtUtils.writeBlockState((BlockState)state));
        }
        tag.put(PALETTE_KEY, (Tag)paletteTag);
        CompoundTag blocksTag = new CompoundTag();
        for (BlockInfo info : this.blockInfos) {
            if (info.state == mostUsed) continue;
            CompoundTag infoTag = new CompoundTag();
            infoTag.putInt(STATE_KEY, ((Integer)states.get((Object)info.state)).intValue());
            if (info.blockEntityTag.isPresent()) {
                infoTag.put(TAG_KEY, (Tag)info.blockEntityTag.get());
            }
            blocksTag.put(Long.toString(info.pos.asLong()), (Tag)infoTag);
        }
        tag.put(BLOCKS_KEY, (Tag)blocksTag);
        ListTag entitiesListTag = new ListTag();
        for (EntityInfo info : this.entityInfos) {
            CompoundTag infoTag = new CompoundTag();
            infoTag.putUUID(UUID_KEY, info.original);
            ListTag pos = new ListTag();
            pos.add((Object)FloatTag.valueOf((float)((float)info.pos.x)));
            pos.add((Object)FloatTag.valueOf((float)((float)info.pos.y)));
            pos.add((Object)FloatTag.valueOf((float)((float)info.pos.z)));
            infoTag.put(POS_KEY, (Tag)pos);
            infoTag.put(ENTITY_KEY, (Tag)info.entityTag);
            entitiesListTag.add((Object)infoTag);
        }
        tag.put(ENTITIES_KEY, (Tag)entitiesListTag);
        tag.putLongArray(BOUNDS_KEY, new long[]{BlockPos.asLong((int)this.bounds.minX(), (int)this.bounds.minY(), (int)this.bounds.minZ()), BlockPos.asLong((int)this.bounds.maxX(), (int)this.bounds.maxY(), (int)this.bounds.maxZ())});
        tag.putLong(WORLD_POS_KEY, this.worldPos.asLong());
        tag.putLong(CENTER_OFFSET_KEY, this.centerOffset.asLong());
        tag.putString(MIRROR_KEY, this.mirror.name());
        tag.putString(ROTATION_KEY, this.rotation.name());
        return tag;
    }

    public static CapturedBlocks fromCompressedTag(HolderLookup.Provider registryAccess, CompoundTag tag) {
        HolderLookup.RegistryLookup blockRegistry = registryAccess.lookupOrThrow(Registries.BLOCK);
        BlockState[] palette = (BlockState[])tag.getList(PALETTE_KEY, 10).stream().map(arg_0 -> CapturedBlocks.lambda$fromCompressedTag$8((HolderGetter)blockRegistry, arg_0)).toArray(BlockState[]::new);
        BlockState defaultState = tag.contains(DEFAULT_STATE_KEY, 10) ? NbtUtils.readBlockState((HolderGetter)blockRegistry, (CompoundTag)tag.getCompound(DEFAULT_STATE_KEY)) : null;
        long[] boundsCorners = tag.getLongArray(BOUNDS_KEY);
        BoundingBox bounds = BoundingBox.fromCorners((Vec3i)BlockPos.of((long)boundsCorners[0]), (Vec3i)BlockPos.of((long)boundsCorners[1]));
        CompoundTag blocksTag = tag.getCompound(BLOCKS_KEY);
        ArrayList<BlockInfo> blockInfos = new ArrayList<BlockInfo>(bounds.getXSpan() * bounds.getYSpan() * bounds.getZSpan());
        for (int x = 0; x <= bounds.getXSpan() - 1; ++x) {
            for (int z = 0; z <= bounds.getZSpan() - 1; ++z) {
                for (int y = 0; y <= bounds.getYSpan() - 1; ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    String l = Long.toString(pos.asLong());
                    if (blocksTag.contains(l, 10)) {
                        CompoundTag infoTag = blocksTag.getCompound(l);
                        BlockState state = palette[infoTag.getInt(STATE_KEY)];
                        Optional<Object> beTag = Optional.ofNullable(infoTag.contains(TAG_KEY) ? infoTag.getCompound(TAG_KEY) : null);
                        blockInfos.add(new BlockInfo(pos, state, beTag));
                        continue;
                    }
                    if (defaultState == null) continue;
                    blockInfos.add(new BlockInfo(pos, defaultState, Optional.empty()));
                }
            }
        }
        ListTag entitiesListTag = tag.getList(ENTITIES_KEY, 10);
        ArrayList<EntityInfo> entityInfos = new ArrayList<EntityInfo>(entitiesListTag.size());
        for (Tag t : entitiesListTag) {
            if (!(t instanceof CompoundTag)) continue;
            CompoundTag infoTag = (CompoundTag)t;
            ListTag posTag = infoTag.getList(POS_KEY, 5);
            entityInfos.add(new EntityInfo(infoTag.getUUID(UUID_KEY), new Vec3((double)posTag.getFloat(0), (double)posTag.getFloat(1), (double)posTag.getFloat(2)), infoTag.getCompound(ENTITY_KEY)));
        }
        return new CapturedBlocks(BlockPos.of((long)tag.getLong(WORLD_POS_KEY)), BlockPos.of((long)tag.getLong(CENTER_OFFSET_KEY)), bounds, blockInfos, entityInfos, Mirror.valueOf((String)tag.getString(MIRROR_KEY)), Rotation.valueOf((String)tag.getString(ROTATION_KEY)));
    }

    private static /* synthetic */ BlockState lambda$fromCompressedTag$8(HolderGetter blockRegistry, Tag t) {
        return NbtUtils.readBlockState((HolderGetter)blockRegistry, (CompoundTag)((CompoundTag)t));
    }

    private static /* synthetic */ Integer lambda$toCompressedTag$6(BiMap states, BlockState i) {
        return states.size();
    }

    public record BlockInfo(BlockPos pos, BlockState state, Optional<CompoundTag> blockEntityTag) {
        public static final Codec<BlockInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.CODEC.fieldOf(CapturedBlocks.POS_KEY).forGetter(BlockInfo::pos), (App)BlockState.CODEC.fieldOf(CapturedBlocks.STATE_KEY).forGetter(BlockInfo::state), (App)CompoundTag.CODEC.optionalFieldOf(CapturedBlocks.TAG_KEY).forGetter(BlockInfo::blockEntityTag)).apply((Applicative)instance, BlockInfo::new));
    }

    public record EntityInfo(UUID original, Vec3 pos, CompoundTag entityTag) {
        public static final Codec<EntityInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.xmap(UUID::fromString, UUID::toString).fieldOf("original").forGetter(EntityInfo::original), (App)Vec3.CODEC.fieldOf(CapturedBlocks.POS_KEY).forGetter(EntityInfo::pos), (App)CompoundTag.CODEC.fieldOf(CapturedBlocks.ENTITY_KEY).forGetter(EntityInfo::entityTag)).apply((Applicative)instance, EntityInfo::new));

        @Nullable
        public Entity createEntity(Level level, BlockPos startPos, Mirror mirror, Rotation rotation) {
            Entity entity = EntityType.create((CompoundTag)this.entityTag(), (Level)level, (EntitySpawnReason)EntitySpawnReason.COMMAND).orElse(null);
            if (entity != null) {
                float rot = entity.mirror(mirror);
                entity.setYRot(rot);
                rot = entity.rotate(rotation);
                entity.setYRot(rot);
                entity.setPos(this.pos().add(Vec3.atLowerCornerOf((Vec3i)startPos)));
            }
            return entity;
        }
    }
}

