/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.mixin;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class StructureGelMixins
implements IMixinConfigPlugin {
    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return false;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        ArrayList<String> mixins = new ArrayList<String>();
        StructureGelMixins.addMixin(mixins, "BlockMixin", "ChunkGeneratorMixin", "StructureMixin", "LakeFeatureMixin", "PoolElementStructurePieceMixin", "SinglePoolElementMixin", "StructureBlockEntityMixin", "StructureTemplateManagerMixin", "TemplateStructurePieceMixin", "LevelTicksMixin");
        StructureGelMixins.addMixin(mixins, StructureGelMixins.subclasses("TemplateMixins", "StructurePlaceSettingsMixin", "StructureTemplateMixin", "PlaceCommandMixin", "StructureBlockEntityMixin"));
        StructureGelMixins.addMixin(mixins, StructureGelMixins.subclasses("JigsawMixins", "JigsawStructureMixin", "JigsawPlacementMixin", "JigsawPlacerMixin"));
        StructureGelMixins.addMixin(mixins, "GenerationContextMixin");
        StructureGelMixins.addMixin(mixins, "ChunkAccessMixin$Access", "StructureTemplateAccessor");
        if (MixinEnvironment.getCurrentEnvironment().getSide() == MixinEnvironment.Side.CLIENT) {
            StructureGelMixins.addClientMixin(mixins, "EntityMixin", "GuiMixin", "ItemMixin", "StructureBlockRendererMixin", "StructureBlockEditScreenMixin");
            StructureGelMixins.addClientMixin(mixins, StructureGelMixins.subclasses("ArmorTrimMixins", "SpriteSourceListMixin"));
            if (!StructureGelMixins.doesClassExist("net.optifine.Lang")) {
                StructureGelMixins.addClientMixin(mixins, StructureGelMixins.subclasses("ArmorTrimMixins", "EquipmentLayerRendererMixin"));
            }
        }
        return mixins;
    }

    private static String[] subclasses(String mainClass, String ... subclasses) {
        int l = subclasses.length;
        String[] ret = new String[l];
        for (int i = 0; i < l; ++i) {
            ret[i] = mainClass + "$" + subclasses[i];
        }
        return ret;
    }

    private static void addMixin(List<String> mixins, String ... toAdd) {
        StructureGelMixins.addMixin("common", mixins, toAdd);
    }

    private static void addClientMixin(List<String> mixins, String ... toAdd) {
        StructureGelMixins.addMixin("client", mixins, toAdd);
    }

    private static void addServerMixin(List<String> mixins, String ... toAdd) {
        StructureGelMixins.addMixin("server", mixins, toAdd);
    }

    private static void addMixin(String sidePackage, List<String> mixins, String ... toAdd) {
        String prefix = sidePackage + ".";
        for (String s : toAdd) {
            mixins.add(prefix + s);
        }
    }

    private static boolean doesClassExist(String classPath) {
        try {
            Class.forName(classPath);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

