/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.mixin.client;

import com.legacy.structure_gel.core.SGConfig;
import com.legacy.structure_gel.core.registry.SGRegistry;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={Item.class})
public class ItemMixin {
    @Inject(at={@At(value="HEAD")}, method={"getName(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/network/chat/Component;"}, cancellable=true)
    private void getDisplayName(ItemStack stack, CallbackInfoReturnable<Component> callback) {
        if (SGConfig.CLIENT.showStructureBlockInfo()) {
            Item item = stack.getItem();
            try {
                if (item == Items.STRUCTURE_BLOCK || item == Items.JIGSAW || item == SGRegistry.Blocks.DATA_HANDLER.map(Block::asItem)) {
                    if (stack.has(DataComponents.CUSTOM_NAME)) {
                        return;
                    }
                    CustomData beData = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
                    if (beData != null) {
                        CompoundTag blockEntityTag = beData.copyTag();
                        MutableComponent displayName = null;
                        if (item == Items.STRUCTURE_BLOCK) {
                            String mode;
                            String string = mode = blockEntityTag.contains("mode") ? blockEntityTag.getString("mode").toLowerCase(Locale.ENGLISH) : "load";
                            String text = mode.equals("data") ? (blockEntityTag.contains("metadata") ? blockEntityTag.getString("metadata") : "") : (blockEntityTag.contains("name") ? blockEntityTag.getString("name") : "");
                            displayName = Component.translatable((String)("structure_block.mode." + mode)).append((Component)Component.literal((String)(text.isBlank() ? " " + Component.translatable((String)item.getDescriptionId()).getString() : ": \"" + text + "\"")));
                        } else if (item == Items.JIGSAW) {
                            String text = blockEntityTag.contains("pool") ? blockEntityTag.getString("pool") : "null";
                            displayName = Component.literal((String)("Pool: \"" + text + "\""));
                        } else if (item == ((Block)SGRegistry.Blocks.DATA_HANDLER.get()).asItem() && blockEntityTag.contains("CustomName", 8) && Minecraft.getInstance().level != null) {
                            displayName = Component.Serializer.fromJson((String)blockEntityTag.getString("CustomName"), (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
                        }
                        if (displayName != null) {
                            callback.setReturnValue((Object)displayName);
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

