/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.mixin.common;

import com.legacy.structure_gel.api.block_entity.IRotatable;
import com.legacy.structure_gel.api.data.tags.SGTags;
import com.legacy.structure_gel.api.structure.base.IModifyState;
import com.legacy.structure_gel.api.structure.processor.RemoveGelStructureProcessor;
import com.legacy.structure_gel.core.capability.misc.StructureSettingsData;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.commands.PlaceCommand;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class TemplateMixins {

    @Mixin(value={StructureBlockEntity.class})
    public static class StructureBlockEntityMixin {
        @ModifyExpressionValue(at={@At(value="NEW", target="net/minecraft/world/level/levelgen/structure/templatesystem/StructurePlaceSettings")}, method={"placeStructure(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplate;)V"})
        private StructurePlaceSettings modifySettings_placeStructure(StructurePlaceSettings original) {
            ((StructureSettingsData)original).structure_gel$setNatural(false);
            return original;
        }
    }

    @Mixin(value={PlaceCommand.class})
    public static class PlaceCommandMixin {
        @ModifyExpressionValue(at={@At(value="NEW", target="net/minecraft/world/level/levelgen/structure/templatesystem/StructurePlaceSettings")}, method={"placeTemplate"})
        private static StructurePlaceSettings modifySettings_placeTemplate(StructurePlaceSettings original) {
            ((StructureSettingsData)original).structure_gel$setNatural(false);
            return original;
        }
    }

    @Mixin(value={StructureTemplate.class})
    public static class StructureTemplateMixin {
        @Inject(at={@At(value="HEAD")}, remap=false, method={"processBlockInfos(Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructurePlaceSettings;Ljava/util/List;Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplate;)Ljava/util/List;"})
        private static void addGelProcessor_processBlockInfos(ServerLevelAccessor pServerLevel, BlockPos pOffset, BlockPos p_74520_, StructurePlaceSettings settings, List<StructureTemplate.StructureBlockInfo> blockInfos, @Nullable StructureTemplate template, CallbackInfoReturnable<List<StructureTemplate.StructureBlockInfo>> callback) {
            StructureSettingsData settingsData = (StructureSettingsData)settings;
            if (settingsData.structure_gel$isNatural() && !settings.getProcessors().contains((Object)RemoveGelStructureProcessor.INSTANCE) && blockInfos.stream().anyMatch(info -> info.state().is(SGTags.BlockTags.GEL))) {
                settings.getProcessors().add(0, RemoveGelStructureProcessor.INSTANCE);
            }
        }

        @Inject(at={@At(value="TAIL")}, remap=false, method={"processBlockInfos(Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructurePlaceSettings;Ljava/util/List;Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplate;)Ljava/util/List;"})
        private static void modifyStates_processBlockInfos(ServerLevelAccessor level, BlockPos pOffset, BlockPos p_74520_, StructurePlaceSettings settings, List<StructureTemplate.StructureBlockInfo> blockInfos, @Nullable StructureTemplate template, CallbackInfoReturnable<List<StructureTemplate.StructureBlockInfo>> callback) {
            IModifyState stateModifier;
            StructureSettingsData settingsData = (StructureSettingsData)settings;
            if (settingsData.structure_gel$isNatural() && (stateModifier = settingsData.structure_gel$getStateModifier()) != IModifyState.NOOP) {
                RandomSource rand = level.getRandom();
                List processedBlocks = (List)callback.getReturnValue();
                ArrayList<Integer> toRemove = new ArrayList<Integer>();
                int size = processedBlocks.size();
                for (int i = 0; i < size; ++i) {
                    StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)processedBlocks.get(i);
                    BlockState state = info.state();
                    BlockPos infoPos = info.pos();
                    BlockState modifiedState = stateModifier.modifyState(level, rand, infoPos, state);
                    if (modifiedState == null) {
                        toRemove.add(i);
                        continue;
                    }
                    if (state == modifiedState) continue;
                    processedBlocks.set(i, new StructureTemplate.StructureBlockInfo(infoPos, modifiedState, info.nbt()));
                }
                int removeCount = toRemove.size();
                if (removeCount > 0) {
                    for (int i = removeCount - 1; i > -1; --i) {
                        processedBlocks.remove((Integer)toRemove.get(i));
                    }
                }
            }
        }

        @WrapOperation(at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/BlockEntity;loadWithComponents(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;)V")}, method={"placeInWorld"})
        private void loadBlockEntity(BlockEntity target, CompoundTag tag, HolderLookup.Provider lookup, Operation<Void> original, ServerLevelAccessor p_230329_, BlockPos p_230330_, BlockPos p_230331_, StructurePlaceSettings settings) {
            original.call(new Object[]{target, tag, lookup});
            if (target instanceof IRotatable) {
                IRotatable r = (IRotatable)target;
                r.transform(settings.getMirror(), settings.getRotation());
            }
        }
    }

    @Mixin(value={StructurePlaceSettings.class})
    public static class StructurePlaceSettingsMixin
    implements StructureSettingsData {
        private boolean structure_gel$setNatural = true;
        private IModifyState structure_gel$stateModifier = IModifyState.NOOP;

        @Override
        public void structure_gel$setNatural(boolean natural) {
            this.structure_gel$setNatural = natural;
        }

        @Override
        public boolean structure_gel$isNatural() {
            return this.structure_gel$setNatural;
        }

        @Override
        public void structure_gel$setStateModifier(IModifyState modifier) {
            this.structure_gel$stateModifier = modifier;
        }

        @Override
        public IModifyState structure_gel$getStateModifier() {
            return this.structure_gel$stateModifier;
        }
    }
}

