/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.network.bi_directional;

import com.legacy.structure_gel.api.util.NetworkUtil;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.data_components.BlockPalette;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolMode;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolModes;
import com.legacy.structure_gel.core.item.building_tool.ToolModeProperty;
import com.legacy.structure_gel.core.registry.SGRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record UpdateBuildingToolPacket(boolean toServer, InteractionHand hand, Optional<BuildingToolMode> mode, Map<ToolModeProperty<?>, Object> properties, Optional<BlockPos> posA, Optional<BlockPos> posB, boolean clearPoses, Optional<BlockPalette> palette, Optional<Integer> reachDistanceModifier, Optional<Float> cornerReachDistance, Optional<Boolean> causeBlockUpdates) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateBuildingToolPacket> TYPE = new CustomPacketPayload.Type(StructureGelMod.locate("update_building_tool"));
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdateBuildingToolPacket> CODEC = new StreamCodec<RegistryFriendlyByteBuf, UpdateBuildingToolPacket>(){

        public void encode(RegistryFriendlyByteBuf buff, UpdateBuildingToolPacket packet) {
            buff.writeBoolean(packet.toServer);
            buff.writeBoolean(packet.hand == InteractionHand.MAIN_HAND);
            NetworkUtil.writeOptional((FriendlyByteBuf)buff, packet.mode.map(BuildingToolMode::getName), arg_0 -> ((RegistryFriendlyByteBuf)buff).writeResourceLocation(arg_0));
            buff.writeInt(packet.properties.size());
            for (Map.Entry<ToolModeProperty<?>, Object> entry : packet.properties.entrySet()) {
                ToolModeProperty<?> property = entry.getKey();
                buff.writeUtf(property.getKey());
                buff.writeUtf(property.write(entry.getValue()));
            }
            NetworkUtil.writeOptional((FriendlyByteBuf)buff, packet.posA, arg_0 -> ((RegistryFriendlyByteBuf)buff).writeBlockPos(arg_0));
            NetworkUtil.writeOptional((FriendlyByteBuf)buff, packet.posB, arg_0 -> ((RegistryFriendlyByteBuf)buff).writeBlockPos(arg_0));
            buff.writeBoolean(packet.clearPoses);
            NetworkUtil.writeOptional((FriendlyByteBuf)buff, packet.palette, p -> BlockPalette.STREAM_CODEC.encode((Object)buff, p));
            NetworkUtil.writeOptional((FriendlyByteBuf)buff, packet.reachDistanceModifier, arg_0 -> ((RegistryFriendlyByteBuf)buff).writeInt(arg_0));
            NetworkUtil.writeOptional((FriendlyByteBuf)buff, packet.cornerReachDistance, arg_0 -> ((RegistryFriendlyByteBuf)buff).writeFloat(arg_0));
            NetworkUtil.writeOptional((FriendlyByteBuf)buff, packet.causeBlockUpdates, arg_0 -> ((RegistryFriendlyByteBuf)buff).writeBoolean(arg_0));
        }

        public UpdateBuildingToolPacket decode(RegistryFriendlyByteBuf buff) {
            boolean toServer = buff.readBoolean();
            InteractionHand hand = buff.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
            Optional<BuildingToolMode> mode = NetworkUtil.readOptional((FriendlyByteBuf)buff, () -> ((RegistryFriendlyByteBuf)buff).readResourceLocation(), () -> null).map(BuildingToolModes.REGISTRY::get);
            HashMap properties = new HashMap();
            int propertiesSize = buff.readInt();
            if (!mode.isPresent() && propertiesSize > 0) {
                StructureGelMod.LOGGER.warn("Can't read building tool properties from packet because no mode was sent", new Object[0]);
            } else {
                for (int i = 0; i < propertiesSize; ++i) {
                    String k = buff.readUtf();
                    String v = buff.readUtf();
                    ToolModeProperty<?> property = mode.get().getProperties().get(k);
                    properties.put(property, property.read(v));
                }
            }
            Optional<BlockPos> posA = NetworkUtil.readOptional((FriendlyByteBuf)buff, () -> ((RegistryFriendlyByteBuf)buff).readBlockPos(), () -> null);
            Optional<BlockPos> posB = NetworkUtil.readOptional((FriendlyByteBuf)buff, () -> ((RegistryFriendlyByteBuf)buff).readBlockPos(), () -> null);
            boolean clearPoses = buff.readBoolean();
            Optional<BlockPalette> palette = NetworkUtil.readOptional((FriendlyByteBuf)buff, () -> (BlockPalette)BlockPalette.STREAM_CODEC.decode((Object)buff), () -> null);
            Optional<Integer> reachDistanceModifier = NetworkUtil.readOptional((FriendlyByteBuf)buff, () -> ((RegistryFriendlyByteBuf)buff).readInt(), () -> 0);
            Optional<Float> cornerReachDistance = NetworkUtil.readOptional((FriendlyByteBuf)buff, () -> ((RegistryFriendlyByteBuf)buff).readFloat(), () -> Float.valueOf(0.0f));
            Optional<Boolean> causeBlockUpdates = NetworkUtil.readOptional((FriendlyByteBuf)buff, () -> ((RegistryFriendlyByteBuf)buff).readBoolean(), () -> null);
            return new UpdateBuildingToolPacket(toServer, hand, mode, properties, posA, posB, clearPoses, palette, reachDistanceModifier, cornerReachDistance, causeBlockUpdates);
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handler(UpdateBuildingToolPacket packet, IPayloadContext context) {
        if (context.flow().isClientbound()) {
            context.enqueueWork(() -> UpdateBuildingToolPacket.handleClient(packet));
        } else {
            context.enqueueWork(() -> UpdateBuildingToolPacket.handle(packet, context.player()));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(UpdateBuildingToolPacket packet) {
        UpdateBuildingToolPacket.handle(packet, (Player)Minecraft.getInstance().player);
    }

    private static void handle(UpdateBuildingToolPacket packet, Player player) {
        InteractionHand hand = packet.hand;
        ItemStack stack = player.getItemInHand(hand);
        if (stack.is((Item)SGRegistry.Items.BUILDING_TOOL.get())) {
            int reach;
            if (packet.mode.isPresent()) {
                BuildingToolMode mode = packet.mode.get();
                BuildingToolItem.setMode(stack, mode);
                if (mode instanceof BuildingToolMode.ForCorners) {
                    BuildingToolMode.ForCorners forCorners = (BuildingToolMode.ForCorners)mode;
                    if (packet.posA.isPresent()) {
                        forCorners.setPositionA(player, packet.posA.get(), stack, false);
                    }
                    if (packet.posB.isPresent()) {
                        forCorners.setPositionB(player, packet.posB.get(), stack, false);
                    }
                }
                if (packet.clearPoses) {
                    mode.clearPoses(stack, player);
                }
            }
            for (Map.Entry entry : packet.properties.entrySet()) {
                ToolModeProperty prop = (ToolModeProperty)entry.getKey();
                BuildingToolItem.setProperty(stack, prop, entry.getValue());
            }
            if (packet.palette.isPresent()) {
                BuildingToolItem.setPalette(stack, packet.palette.get());
            }
            if (packet.reachDistanceModifier.isPresent() && ToolModeProperty.REACH_DISTANCE.isValid(reach = packet.reachDistanceModifier.get().intValue()) && reach != BuildingToolItem.getReachDistanceModifier(stack)) {
                BuildingToolItem.setReachDistanceModifier(stack, reach);
            }
            if (packet.cornerReachDistance.isPresent()) {
                BuildingToolItem.setSelectedCornerDistance(stack, packet.cornerReachDistance.get().floatValue());
            }
            if (packet.causeBlockUpdates.isPresent()) {
                BuildingToolItem.setCausesBlockUpdates(stack, packet.causeBlockUpdates.get());
            }
            if (packet.mode.isPresent()) {
                packet.mode.get().onSelect(stack, player.level(), player);
            }
            player.swing(hand);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        boolean toServer = true;
        InteractionHand hand = InteractionHand.MAIN_HAND;
        Optional<BuildingToolMode> mode = Optional.empty();
        Map<ToolModeProperty<?>, Object> properties = Map.of();
        Optional<BlockPos> posA = Optional.empty();
        Optional<BlockPos> posB = Optional.empty();
        boolean clearPoses = false;
        Optional<BlockPalette> palette = Optional.empty();
        Optional<Integer> reachDistanceModifier = Optional.empty();
        Optional<Float> cornerReachDistance = Optional.empty();
        Optional<Boolean> causeBlockUpdates = Optional.empty();

        private Builder() {
        }

        public Builder toClient() {
            this.toServer = false;
            return this;
        }

        public Builder toServer() {
            this.toServer = true;
            return this;
        }

        public Builder hand(InteractionHand hand) {
            this.hand = hand;
            return this;
        }

        public Builder mode(BuildingToolMode mode) {
            this.mode = Optional.ofNullable(mode);
            return this;
        }

        public Builder properties(Map<ToolModeProperty<?>, Object> properties) {
            this.properties = properties;
            return this;
        }

        public Builder posA(Optional<BlockPos> posA) {
            this.posA = posA;
            return this;
        }

        public Builder posB(Optional<BlockPos> posB) {
            this.posB = posB;
            return this;
        }

        public Builder clearPoses(boolean clearPoses) {
            this.clearPoses = clearPoses;
            return this;
        }

        public Builder palette(BlockPalette states) {
            this.palette = Optional.ofNullable(states);
            return this;
        }

        public Builder reachDistance(int reachDistance) {
            this.reachDistanceModifier = Optional.of(reachDistance);
            return this;
        }

        public Builder cornerReachDistance(float cornerReachDistance) {
            this.cornerReachDistance = Optional.of(Float.valueOf(cornerReachDistance));
            return this;
        }

        public Builder causeBlockUpdates(boolean val) {
            this.causeBlockUpdates = Optional.of(val);
            return this;
        }

        public UpdateBuildingToolPacket build() {
            return new UpdateBuildingToolPacket(this.toServer, this.hand, this.mode, this.properties, this.posA, this.posB, this.clearPoses, this.palette, this.reachDistanceModifier, this.cornerReachDistance, this.causeBlockUpdates);
        }
    }
}

