/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.network.c_to_s;

import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.registry.SGRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MiddleClickBuildingToolPacket(InteractionHand hand, @Nullable BlockPos pos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MiddleClickBuildingToolPacket> TYPE = new CustomPacketPayload.Type(StructureGelMod.locate("middle_click_building_tool"));
    public static final StreamCodec<RegistryFriendlyByteBuf, MiddleClickBuildingToolPacket> CODEC = new StreamCodec<RegistryFriendlyByteBuf, MiddleClickBuildingToolPacket>(){

        public void encode(RegistryFriendlyByteBuf buff, MiddleClickBuildingToolPacket packet) {
            buff.writeBoolean(packet.hand == InteractionHand.MAIN_HAND);
            buff.writeBoolean(packet.pos != null);
            if (packet.pos != null) {
                buff.writeBlockPos(packet.pos);
            }
        }

        public MiddleClickBuildingToolPacket decode(RegistryFriendlyByteBuf buff) {
            InteractionHand hand = buff.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
            boolean isPosPresent = buff.readBoolean();
            BlockPos pos = isPosPresent ? buff.readBlockPos() : null;
            return new MiddleClickBuildingToolPacket(hand, pos);
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handler(MiddleClickBuildingToolPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            ItemStack stack = player.getItemInHand(packet.hand);
            if (stack.is((Item)SGRegistry.Items.BUILDING_TOOL.get())) {
                ((BuildingToolItem)((Object)((Object)SGRegistry.Items.BUILDING_TOOL.get()))).onMiddleClick(stack, (Player)player, packet.pos);
                player.swing(packet.hand);
            }
        });
    }
}

