/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.network.c_to_s;

import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.network.SGPacketHandler;
import com.legacy.structure_gel.core.network.s_to_c.SendRegistryKeysToClientPacket;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlagSet;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record RequestRegistryKeysPacket(ResourceKey<? extends Registry<?>> registry) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RequestRegistryKeysPacket> TYPE = new CustomPacketPayload.Type(StructureGelMod.locate("request_registry_keys"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RequestRegistryKeysPacket> CODEC = new StreamCodec<RegistryFriendlyByteBuf, RequestRegistryKeysPacket>(){

        public void encode(RegistryFriendlyByteBuf buff, RequestRegistryKeysPacket packet) {
            buff.writeResourceKey(packet.registry);
        }

        public RequestRegistryKeysPacket decode(RegistryFriendlyByteBuf buff) {
            return new RequestRegistryKeysPacket(buff.readRegistryKey());
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handler(RequestRegistryKeysPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Optional opRegistry;
            Player patt0$temp = context.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            ServerLevel level = player.serverLevel();
            if (level != null && (opRegistry = level.registryAccess().lookup(packet.registry)).isPresent()) {
                Registry registry = (Registry)opRegistry.get();
                ArrayList<ResourceLocation> keys = new ArrayList<ResourceLocation>(registry.keySet().size());
                FeatureFlagSet featureFlags = level.enabledFeatures();
                for (Map.Entry entry : registry.entrySet()) {
                    FeatureElement feature;
                    Object patt1$temp = entry.getValue();
                    if (patt1$temp instanceof FeatureElement && !(feature = (FeatureElement)patt1$temp).isEnabled(featureFlags)) continue;
                    keys.add(((ResourceKey)entry.getKey()).location());
                }
                SGPacketHandler.sendToClient(new SendRegistryKeysToClientPacket(packet.registry, keys), player);
            }
        });
    }
}

