/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.network.c_to_s;

import com.legacy.structure_gel.api.data_handler.handlers.DataHandler;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.block.DataHandlerBlock;
import com.legacy.structure_gel.core.block_entity.DataHandlerBlockEntity;
import com.legacy.structure_gel.core.registry.SGRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record UpdateDataHandlerPacket(Mode mode, BlockPos pos, List<DataHandlerBlockEntity.RawHandler> handlers, String name, boolean useGravity, boolean waterlogged, Vec3 offset, boolean connectToBlocks, boolean markPostProcessing) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateDataHandlerPacket> TYPE = new CustomPacketPayload.Type(StructureGelMod.locate("update_data_handler"));
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdateDataHandlerPacket> CODEC = new StreamCodec<RegistryFriendlyByteBuf, UpdateDataHandlerPacket>(){

        public void encode(RegistryFriendlyByteBuf buff, UpdateDataHandlerPacket packet) {
            Mode.STREAM_CODEC.encode((Object)buff, (Object)packet.mode);
            buff.writeBlockPos(packet.pos);
            buff.writeInt(packet.handlers.size());
            for (DataHandlerBlockEntity.RawHandler handler : packet.handlers) {
                buff.writeInt(handler.getWeight().asInt());
                buff.writeResourceLocation(handler.typeName());
                buff.writeInt(handler.dataEntries().size());
                for (Map.Entry<String, String> entry : handler.dataEntries().entrySet()) {
                    buff.writeUtf(entry.getKey());
                    buff.writeUtf(entry.getValue());
                }
            }
            buff.writeUtf(packet.name);
            buff.writeBoolean(packet.useGravity);
            buff.writeBoolean(packet.waterlogged);
            buff.writeDouble(packet.offset.x);
            buff.writeDouble(packet.offset.y);
            buff.writeDouble(packet.offset.z);
            buff.writeBoolean(packet.connectToBlocks);
            buff.writeBoolean(packet.markPostProcessing);
        }

        public UpdateDataHandlerPacket decode(RegistryFriendlyByteBuf buff) {
            try {
                Mode mode = (Mode)((Object)Mode.STREAM_CODEC.decode((Object)buff));
                BlockPos pos = buff.readBlockPos();
                ArrayList<DataHandlerBlockEntity.RawHandler> handlers = new ArrayList<DataHandlerBlockEntity.RawHandler>();
                int size = buff.readInt();
                for (int i = 0; i < size; ++i) {
                    Weight weight = Weight.of((int)buff.readInt());
                    ResourceLocation type = buff.readResourceLocation();
                    LinkedHashMap<String, String> dataEntries = new LinkedHashMap<String, String>();
                    int entrySize = buff.readInt();
                    for (int e = 0; e < entrySize; ++e) {
                        dataEntries.put(buff.readUtf(), buff.readUtf());
                    }
                    handlers.add(new DataHandlerBlockEntity.RawHandler(weight, type, dataEntries));
                }
                String name = buff.readUtf();
                boolean useGravity = buff.readBoolean();
                boolean waterlogged = buff.readBoolean();
                Vec3 offset = new Vec3(buff.readDouble(), buff.readDouble(), buff.readDouble());
                boolean connectToBlocks = buff.readBoolean();
                boolean markPostProcessing = buff.readBoolean();
                return new UpdateDataHandlerPacket(mode, pos, handlers, name, useGravity, waterlogged, offset, connectToBlocks, markPostProcessing);
            }
            catch (Throwable t) {
                return new UpdateDataHandlerPacket(Mode.ERROR, BlockPos.ZERO, Collections.emptyList(), "", false, false, Vec3.ZERO, false, false);
            }
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handler(UpdateDataHandlerPacket packet, IPayloadContext context) {
        if (packet.mode == Mode.ERROR) {
            Player player = context.player();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            StructureGelMod.LOGGER.warn("An invalid packet ({}) was sent to the server from {} at {} in {}", packet.getClass().getSimpleName(), player2.getGameProfile().getName(), player2.blockPosition(), player2.level().dimension().location());
            return;
        }
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            ServerLevel level = player.serverLevel();
            BlockPos pos = packet.pos;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            BlockState state = level.getBlockState(pos);
            if (state.is((Block)SGRegistry.Blocks.DATA_HANDLER.get()) && blockEntity instanceof DataHandlerBlockEntity) {
                Object newState;
                DataHandlerBlockEntity dataHandler = (DataHandlerBlockEntity)blockEntity;
                if (packet.mode.shouldSave()) {
                    dataHandler.setHandlers((WeightedRandomList<DataHandlerBlockEntity.RawHandler>)WeightedRandomList.create(packet.handlers));
                    dataHandler.setCustomName((Component)(packet.name.isBlank() ? null : Component.literal((String)packet.name)));
                    dataHandler.setUseGravity(packet.useGravity);
                    dataHandler.setOffset(packet.offset);
                    dataHandler.setMarkPostProcessing(packet.markPostProcessing);
                    boolean waterlogged = packet.waterlogged;
                    boolean connectToBlocks = packet.connectToBlocks;
                    newState = (BlockState)((BlockState)state.setValue((Property)DataHandlerBlock.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged))).setValue((Property)DataHandlerBlock.CONNECT_TO_BLOCKS, (Comparable)Boolean.valueOf(connectToBlocks));
                    level.setBlock(pos, newState, 3);
                    blockEntity.setChanged();
                    level.sendBlockUpdated(pos, state, newState, 3);
                }
                if (packet.mode.shouldGenerate()) {
                    ItemEntity itemEntity;
                    ItemStack itemStack;
                    newState = SGRegistry.Blocks.DATA_HANDLER.get();
                    if (newState instanceof DataHandlerBlock) {
                        DataHandlerBlock d = (DataHandlerBlock)((Object)((Object)newState));
                        itemStack = d.getCloneItemStack((LevelReader)level, pos, state, true);
                    } else {
                        itemStack = SGRegistry.Blocks.DATA_HANDLER.asItem().getDefaultInstance();
                    }
                    ItemStack stack = itemStack;
                    CompoundTag beTag = dataHandler.saveCustomOnly((HolderLookup.Provider)level.registryAccess());
                    dataHandler.removeComponentsFromTag(beTag);
                    BlockItem.setBlockEntityData((ItemStack)stack, (BlockEntityType)dataHandler.getType(), (CompoundTag)beTag);
                    stack.applyComponents(dataHandler.collectComponents());
                    stack.set(DataComponents.BLOCK_STATE, (Object)new BlockItemStateProperties(Map.of()).with((Property)DataHandlerBlock.WATERLOGGED, (Comparable)Boolean.valueOf(packet.waterlogged)).with((Property)DataHandlerBlock.CONNECT_TO_BLOCKS, (Comparable)Boolean.valueOf(packet.connectToBlocks)));
                    if (!player.getInventory().contains(stack) && (itemEntity = player.drop(stack, false)) != null) {
                        itemEntity.setNoPickUpDelay();
                        itemEntity.setTarget(player.getUUID());
                    }
                    int offsetAmt = 8;
                    BoundingBox bounds = BoundingBox.fromCorners((Vec3i)pos.offset(-offsetAmt, -offsetAmt, -offsetAmt), (Vec3i)pos.offset(offsetAmt, offsetAmt, offsetAmt));
                    DataHandler.process(state, dataHandler.saveWithFullMetadata((HolderLookup.Provider)level.registryAccess()), pos, (WorldGenLevel)level, level.random, bounds, new DummyPiece(bounds), true);
                }
            } else {
                StructureGelMod.LOGGER.warn("Attempted to set DataHandlerBlockEntity data for the wrong block.", new Object[0]);
            }
        });
    }

    public static enum Mode {
        ERROR(-1),
        SAVE(0),
        GENERATE(1);

        public static final StreamCodec<FriendlyByteBuf, Mode> STREAM_CODEC;
        byte flag;

        private Mode(int flag) {
            this.flag = (byte)flag;
        }

        private boolean shouldSave() {
            return this == SAVE || this == GENERATE;
        }

        private boolean shouldGenerate() {
            return this == GENERATE;
        }

        private static Mode from(byte flag) {
            for (Mode m : Mode.values()) {
                if (m.flag != flag) continue;
                return m;
            }
            return ERROR;
        }

        static {
            STREAM_CODEC = StreamCodec.of((b, m) -> b.writeByte(m.flag), b -> Mode.from(b.readByte()));
        }
    }

    private static final class DummyPiece
    extends StructurePiece {
        protected DummyPiece(BoundingBox bounds) {
            super(StructurePieceType.JIGSAW, 0, bounds);
            this.setOrientation(Direction.NORTH);
        }

        protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tag) {
        }

        public void postProcess(WorldGenLevel level, StructureManager structureManager, ChunkGenerator chunkGen, RandomSource rand, BoundingBox bounds, ChunkPos chunkPos, BlockPos pos) {
        }
    }
}

