/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.network.s_to_c;

import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.client.ClientUtil;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.Registry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SendRegistryKeysToClientPacket(ResourceKey<? extends Registry<?>> registry, Collection<ResourceLocation> keys) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SendRegistryKeysToClientPacket> TYPE = new CustomPacketPayload.Type(StructureGelMod.locate("send_registry_keys"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SendRegistryKeysToClientPacket> CODEC = new StreamCodec<RegistryFriendlyByteBuf, SendRegistryKeysToClientPacket>(){

        public void encode(RegistryFriendlyByteBuf buff, SendRegistryKeysToClientPacket packet) {
            buff.writeResourceLocation(packet.registry.location());
            buff.writeCollection(packet.keys, (b, c) -> b.writeResourceLocation(c));
        }

        public SendRegistryKeysToClientPacket decode(RegistryFriendlyByteBuf buff) {
            return new SendRegistryKeysToClientPacket(ResourceKey.createRegistryKey((ResourceLocation)buff.readResourceLocation()), buff.readList(b -> b.readResourceLocation()));
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handler(SendRegistryKeysToClientPacket packet, IPayloadContext context) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            context.enqueueWork(() -> SendRegistryKeysToClientPacket.handleClient(packet, context));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(SendRegistryKeysToClientPacket packet, IPayloadContext context) {
        ResourceKey<? extends Registry<?>> registry = packet.registry;
        ArrayList<ResourceKey> keys = new ArrayList<ResourceKey>(packet.keys.size());
        for (ResourceLocation key : packet.keys) {
            keys.add(ResourceKey.create(registry, (ResourceLocation)key));
        }
        ClientUtil.REGISTRY_KEYS.put(registry, keys);
    }
}

