/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.network.s_to_c;

import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.client.renderers.StructureBoundsRenderer;
import com.legacy.structure_gel.core.structure.StructureInfo;
import java.util.ArrayList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SendStructureInfoToClientPacket(StructureInfo structureInfo) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SendStructureInfoToClientPacket> TYPE = new CustomPacketPayload.Type(StructureGelMod.locate("send_structure_info"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SendStructureInfoToClientPacket> CODEC = new StreamCodec<RegistryFriendlyByteBuf, SendStructureInfoToClientPacket>(){

        public void encode(RegistryFriendlyByteBuf buff, SendStructureInfoToClientPacket packet) {
            StructureInfo info = packet.structureInfo;
            if (info.dimension() != null) {
                buff.writeResourceLocation(info.dimension());
                1.writeBB(info.fullBounds(), (FriendlyByteBuf)buff);
                int count = info.pieces().size();
                buff.writeInt(count);
                for (int i = 0; i < count; ++i) {
                    StructureInfo.PieceInfo pieceInfo = info.pieces().get(i);
                    1.writeBB(pieceInfo.bounds(), (FriendlyByteBuf)buff);
                    buff.writeInt(pieceInfo.color());
                }
            }
        }

        private static void writeBB(BoundingBox bb, FriendlyByteBuf buff) {
            buff.writeInt(bb.minX());
            buff.writeInt(bb.minY());
            buff.writeInt(bb.minZ());
            buff.writeInt(bb.maxX());
            buff.writeInt(bb.maxY());
            buff.writeInt(bb.maxZ());
        }

        public SendStructureInfoToClientPacket decode(RegistryFriendlyByteBuf buff) {
            ResourceLocation dimensionType = buff.readResourceLocation();
            BoundingBox fullBounds = 1.readBB((FriendlyByteBuf)buff);
            int count = buff.readInt();
            ArrayList<StructureInfo.PieceInfo> pieces = new ArrayList<StructureInfo.PieceInfo>(count);
            for (int i = 0; i < count; ++i) {
                BoundingBox pieceBounds = 1.readBB((FriendlyByteBuf)buff);
                int pieceColor = buff.readInt();
                pieces.add(new StructureInfo.PieceInfo(pieceBounds, pieceColor));
            }
            return new SendStructureInfoToClientPacket(new StructureInfo(dimensionType, fullBounds, pieces));
        }

        private static BoundingBox readBB(FriendlyByteBuf buff) {
            return new BoundingBox(buff.readInt(), buff.readInt(), buff.readInt(), buff.readInt(), buff.readInt(), buff.readInt());
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handler(SendStructureInfoToClientPacket packet, IPayloadContext context) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            context.enqueueWork(() -> StructureBoundsRenderer.addInfo(packet.structureInfo));
        }
    }
}

