/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.structure.jigsaw;

import com.legacy.structure_gel.api.data_handler.handlers.DataHandler;
import com.legacy.structure_gel.api.structure.GelTemplate;
import com.legacy.structure_gel.api.structure.jigsaw.ExtendedJigsawStructurePiece;
import com.legacy.structure_gel.api.structure.processor.RemoveGelStructureProcessor;
import com.legacy.structure_gel.core.registry.SGRegistry;
import com.legacy.structure_gel.core.structure.jigsaw.SinglePoolElementExtension;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class GelSinglePoolElement
extends SinglePoolElement {
    public static final Codec<Either<ResourceLocation, StructureTemplate>> POOL_CODEC = Codec.of(GelSinglePoolElement::encodePool, (Decoder)ResourceLocation.CODEC.map(Either::left));
    public static final MapCodec<GelSinglePoolElement> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(GelSinglePoolElement.encodeTemplate(), GelSinglePoolElement.encodeProcessor(), (App)GelSinglePoolElement.projectionCodec(), (App)GelSinglePoolElement.overrideLiquidSettingsCodec(), (App)Codec.BOOL.optionalFieldOf("ingore_entities", (Object)false).forGetter(element -> element.ignoreEntities)).apply((Applicative)instance, GelSinglePoolElement::new));
    private boolean ignoreEntities = false;

    private static <T> DataResult<T> encodePool(Either<ResourceLocation, StructureTemplate> locationTemplate, DynamicOps<T> dyn, T data) {
        Optional optional = locationTemplate.left();
        return !optional.isPresent() ? DataResult.error(() -> "Can not serialize a runtime pool element") : ResourceLocation.CODEC.encode((Object)((ResourceLocation)optional.get()), dyn, data);
    }

    protected static <E extends GelSinglePoolElement> RecordCodecBuilder<E, Holder<StructureProcessorList>> encodeProcessor() {
        return StructureProcessorType.LIST_CODEC.fieldOf("processors").forGetter(piece -> piece.processors);
    }

    protected static <E extends GelSinglePoolElement> RecordCodecBuilder<E, Either<ResourceLocation, StructureTemplate>> encodeTemplate() {
        return POOL_CODEC.fieldOf("location").forGetter(piece -> piece.template);
    }

    public GelSinglePoolElement(Either<ResourceLocation, StructureTemplate> location, Holder<StructureProcessorList> processors, StructureTemplatePool.Projection projection, Optional<LiquidSettings> overrideLiquidSettings, boolean ignoreEntities) {
        super(location, processors, projection, overrideLiquidSettings);
        this.ignoreEntities = ignoreEntities;
    }

    public GelSinglePoolElement setIgnoreEntities(boolean ignoreEntities) {
        this.ignoreEntities = ignoreEntities;
        return this;
    }

    protected StructurePlaceSettings getSettings(Rotation rotation, BoundingBox boundingBox, LiquidSettings liquidSettings, boolean isLegacy) {
        StructurePlaceSettings settings = super.getSettings(rotation, boundingBox, liquidSettings, isLegacy);
        settings.setIgnoreEntities(this.ignoreEntities);
        settings.getProcessors().remove(BlockIgnoreProcessor.STRUCTURE_BLOCK);
        settings.getProcessors().add(0, RemoveGelStructureProcessor.INSTANCE);
        return settings;
    }

    public boolean place(StructureTemplateManager templateManager, WorldGenLevel level, StructureManager structureManager, ChunkGenerator chunkGen, BlockPos templatePos, BlockPos jigsawPos, Rotation rotation, BoundingBox bounds, RandomSource rand, LiquidSettings liquidSettings, boolean isLegacy) {
        SinglePoolElementExtension singlePool;
        GelSinglePoolElement gelSinglePoolElement = this;
        if (gelSinglePoolElement instanceof SinglePoolElementExtension && (gelSinglePoolElement = (singlePool = (SinglePoolElementExtension)((Object)gelSinglePoolElement)).structure_gel$getPiece()) instanceof ExtendedJigsawStructurePiece) {
            ExtendedJigsawStructurePiece extendedJigsawPiece = (ExtendedJigsawStructurePiece)((Object)gelSinglePoolElement);
            return this.place(templateManager, level, structureManager, chunkGen, templatePos, jigsawPos, rotation, bounds, rand, liquidSettings, isLegacy, extendedJigsawPiece);
        }
        return super.place(templateManager, level, structureManager, chunkGen, templatePos, jigsawPos, rotation, bounds, rand, liquidSettings, isLegacy);
    }

    public boolean place(StructureTemplateManager templateManager, WorldGenLevel level, StructureManager structureManager, ChunkGenerator chunkGen, BlockPos templatePos, BlockPos jigsawPos, Rotation rotation, BoundingBox bounds, RandomSource rand, LiquidSettings liquidSettings, boolean isLegacy, ExtendedJigsawStructurePiece extendedJigsawPiece) {
        StructureTemplate template = this.getTemplate(templateManager);
        StructurePlaceSettings placementSettings = this.getSettings(rotation, bounds, liquidSettings, isLegacy);
        if (!GelTemplate.placeInWorld(template, (ServerLevelAccessor)level, templatePos, jigsawPos, placementSettings, rand, 18, extendedJigsawPiece::modifyState)) {
            return false;
        }
        GelSinglePoolElement.processDataHandlers((StructurePiece)extendedJigsawPiece, template, templatePos, jigsawPos, placementSettings, level, rotation, bounds, rand);
        for (StructureTemplate.StructureBlockInfo blockInfo : StructureTemplate.processBlockInfos((ServerLevelAccessor)level, (BlockPos)templatePos, (BlockPos)jigsawPos, (StructurePlaceSettings)placementSettings, (List)this.getDataMarkers(templateManager, templatePos, rotation, false), (StructureTemplate)template)) {
            this.handleDataMarker((LevelAccessor)level, blockInfo, templatePos, rotation, rand, bounds);
            if (blockInfo.nbt() == null || !level.getBlockState(blockInfo.pos()).is(Blocks.STRUCTURE_BLOCK) || StructureMode.valueOf((String)blockInfo.nbt().getString("mode")) != StructureMode.DATA) continue;
            extendedJigsawPiece.handleDataMarker(blockInfo.nbt().getString("metadata"), blockInfo.pos(), (ServerLevelAccessor)level, rand, bounds);
        }
        return true;
    }

    public static void processDataHandlers(StructurePiece piece, StructureTemplate template, BlockPos templatePos, BlockPos jigsawPos, StructurePlaceSettings placeSettings, WorldGenLevel level, Rotation rotation, BoundingBox bounds, RandomSource rand) {
        Block dataHandler = (Block)SGRegistry.Blocks.DATA_HANDLER.get();
        for (StructureTemplate.StructureBlockInfo blockInfo : StructureTemplate.processBlockInfos((ServerLevelAccessor)level, (BlockPos)templatePos, (BlockPos)jigsawPos, (StructurePlaceSettings)placeSettings, (List)template.filterBlocks(templatePos, new StructurePlaceSettings().setRotation(rotation), dataHandler, false), (StructureTemplate)template)) {
            BlockState state;
            if (blockInfo.nbt() == null || !(state = level.getBlockState(blockInfo.pos())).is(dataHandler)) continue;
            DataHandler.process(state, blockInfo.nbt(), blockInfo.pos(), level, rand, bounds, piece, false);
        }
    }

    public ResourceLocation getLocation() {
        return (ResourceLocation)this.template.left().get();
    }

    private StructureTemplate getTemplate(StructureTemplateManager templateManager) {
        return (StructureTemplate)this.template.map(arg_0 -> ((StructureTemplateManager)templateManager).getOrCreate(arg_0), Function.identity());
    }

    public StructurePoolElementType<?> getType() {
        return SGRegistry.JigsawDeserializers.GEL_SINGLE_POOL_ELEMENT.get();
    }

    public String toString() {
        return "Gel[" + String.valueOf(this.template) + "]";
    }
}

