/*
 * Decompiled with CFR 0.152.
 */
package com.mgen256.al;

import com.mgen256.al.ModBlockList;
import com.mgen256.al.ModItemList;
import com.mgen256.al.ModSoundList;
import com.mgen256.al.conditions.EnableFireCraftingCondition;
import com.mgen256.al.config.AdditionalLightsConfig;
import com.mojang.serialization.MapCodec;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="additional_lights")
public class AdditionalLights {
    public static final String MOD_ID = "additional_lights";
    private static final Logger LOGGER = LogManager.getLogger();
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"additional_lights");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"additional_lights");
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((ResourceKey)Registries.SOUND_EVENT, (String)"additional_lights");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"additional_lights");
    public static final DeferredRegister<MapCodec<? extends ICondition>> CONDITION_CODECS = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.CONDITION_CODECS, (String)"additional_lights");
    public static Map<ModBlockList, DeferredHolder<Block, Block>> modBlocks;
    public static Map<ModBlockList, DeferredHolder<Item, BlockItem>> modBlockItems;
    public static Map<ModItemList, DeferredHolder<Item, Item>> modItems;
    public static Map<ModSoundList, DeferredHolder<SoundEvent, SoundEvent>> modSounds;
    public static DeferredHolder<CreativeModeTab, CreativeModeTab> CREATIVE_TAB;

    public AdditionalLights(IEventBus modEventBus, ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)AdditionalLightsConfig.SPEC);
        modEventBus.addListener(this::commonSetup);
        modSounds = new LinkedHashMap<ModSoundList, DeferredHolder<SoundEvent, SoundEvent>>(){
            {
                this.put(ModSoundList.Change, SOUNDS.register("change", () -> SoundEvent.createVariableRangeEvent((Identifier)Identifier.fromNamespaceAndPath((String)AdditionalLights.MOD_ID, (String)"change"))));
                this.put(ModSoundList.Undo, SOUNDS.register("undo", () -> SoundEvent.createVariableRangeEvent((Identifier)Identifier.fromNamespaceAndPath((String)AdditionalLights.MOD_ID, (String)"undo"))));
                this.put(ModSoundList.Fire_Ignition_S, SOUNDS.register("fire_ignition_s", () -> SoundEvent.createVariableRangeEvent((Identifier)Identifier.fromNamespaceAndPath((String)AdditionalLights.MOD_ID, (String)"fire_ignition_s"))));
                this.put(ModSoundList.Fire_Ignition_L, SOUNDS.register("fire_ignition_l", () -> SoundEvent.createVariableRangeEvent((Identifier)Identifier.fromNamespaceAndPath((String)AdditionalLights.MOD_ID, (String)"fire_ignition_l"))));
                this.put(ModSoundList.Fire_Extinguish, SOUNDS.register("fire_extinguish", () -> SoundEvent.createVariableRangeEvent((Identifier)Identifier.fromNamespaceAndPath((String)AdditionalLights.MOD_ID, (String)"fire_extinguish"))));
            }
        };
        for (ModBlockList modBlockList : ModBlockList.values()) {
            modBlockList.register();
        }
        for (Enum enum_ : ModItemList.values()) {
            ((ModItemList)enum_).register();
        }
        CREATIVE_TAB = CREATIVE_MODE_TABS.register("creative_tab", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"Additional Lights")).icon(() -> new ItemStack((ItemLike)modBlockItems.get((Object)ModBlockList.ALTorch_Oak).get())).withSearchBar().hideTitle().displayItems((param, output) -> {
            modItems.forEach((key, item) -> output.accept((ItemLike)item.get()));
            modBlockItems.forEach((key, item) -> output.accept((ItemLike)item.get()));
        }).build());
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        SOUNDS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        CONDITION_CODECS.register(modEventBus);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        for (ModBlockList block : ModBlockList.values()) {
            block.init();
        }
    }

    public static void Log(String message) {
        LOGGER.info("additional_lights::" + message);
    }

    public static Block getBlock(ModBlockList key) {
        return (Block)modBlocks.get((Object)key).get();
    }

    public static BlockItem getBlockItem(ModBlockList key) {
        return (BlockItem)modBlockItems.get((Object)key).get();
    }

    public static SoundEvent getSound(ModSoundList key) {
        return (SoundEvent)modSounds.get((Object)key).get();
    }

    public static ResourceKey<Block> createResourceKey(String name) {
        return ResourceKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (Identifier)Identifier.fromNamespaceAndPath((String)MOD_ID, (String)name));
    }

    public static ResourceKey<Item> createItemResourceKey(String name) {
        return ResourceKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (Identifier)Identifier.fromNamespaceAndPath((String)MOD_ID, (String)name));
    }

    static {
        CONDITION_CODECS.register("enable_fire_crafting", () -> EnableFireCraftingCondition.CODEC);
        modBlocks = new LinkedHashMap<ModBlockList, DeferredHolder<Block, Block>>();
        modBlockItems = new LinkedHashMap<ModBlockList, DeferredHolder<Item, BlockItem>>();
        modItems = new LinkedHashMap<ModItemList, DeferredHolder<Item, Item>>();
    }
}

