/*
 * Decompiled with CFR 0.152.
 */
package com.mgen256.al.blocks;

import com.mgen256.al.AdditionalLights;
import com.mgen256.al.ModSoundList;
import com.mgen256.al.PedestalTypes;
import com.mgen256.al.blocks.ModBlock;
import com.mgen256.al.blocks.Pedestal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.util.DeferredSoundType;

public abstract class FireBase
extends ModBlock {
    public static BooleanProperty SET = BooleanProperty.create((String)"set");
    public static BooleanProperty SUMMONED = BooleanProperty.create((String)"summoned");
    public static BooleanProperty TEMP = BooleanProperty.create((String)"temp");
    private static Map<PedestalTypes, VoxelShape> SHAPES;
    private static Map<PedestalTypes, SimpleParticleType> PARTICLE_TYPES;
    private static Map<PedestalTypes, Double> SMOKE_POS;
    private static final VoxelShape COLLISION_SHAPE;
    private PedestalTypes pedestalKey;

    protected static BlockBehaviour.Properties createProps(MapColor mapColor, String name) {
        return BlockBehaviour.Properties.of().instabreak().noCollision().mapColor(mapColor).sound((SoundType)new DeferredSoundType(1.5f, 1.0f, () -> AdditionalLights.getSound(ModSoundList.Fire_Extinguish), () -> SoundEvents.WOOL_STEP, () -> SoundEvents.STONE_PLACE, () -> SoundEvents.WOOL_HIT, () -> SoundEvents.WOOL_FALL)).setId(AdditionalLights.createResourceKey(name));
    }

    protected FireBase(PedestalTypes _pedestalKey, String name, BlockBehaviour.Properties props) {
        super(null, name, props, SHAPES.get((Object)_pedestalKey));
        this.pedestalKey = _pedestalKey;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)SET, (Comparable)Boolean.valueOf(false))).setValue((Property)SUMMONED, (Comparable)Boolean.valueOf(false))).setValue((Property)TEMP, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SET});
        builder.add(new Property[]{SUMMONED});
        builder.add(new Property[]{TEMP});
    }

    protected float getFireDamageAmount() {
        return 0.0f;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter blockgetter, BlockPos pos, CollisionContext context) {
        return COLLISION_SHAPE;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter blockgetter, BlockPos pos, CollisionContext context) {
        return SHAPES.get((Object)this.pedestalKey);
    }

    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        double d0 = (double)pos.getX() + 0.5;
        double d1 = (double)pos.getY() + SMOKE_POS.get((Object)this.pedestalKey);
        double d2 = (double)pos.getZ() + 0.5;
        level.addParticle((ParticleOptions)PARTICLE_TYPES.get((Object)this.pedestalKey), d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public BlockState updateShape(BlockState stateIn, LevelReader level, ScheduledTickAccess sta, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource randomSource) {
        return facing == Direction.DOWN && !this.isValidPosition(stateIn, level, currentPos) ? Blocks.AIR.defaultBlockState() : stateIn;
    }

    public boolean isValidPosition(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos belowPos = pos.below();
        BlockState belowState = level.getBlockState(belowPos);
        return !level.isEmptyBlock(belowPos) && belowState.getBlock() != Blocks.WATER;
    }

    @Override
    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        if (state.getValue((Property)SUMMONED) == Boolean.FALSE && state.getValue((Property)TEMP) == Boolean.FALSE) {
            return super.getDrops((BlockState)state.setValue((Property)SET, (Comparable)Boolean.valueOf(false)), builder);
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        return list;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        Block lowerblock = level.getBlockState(pos.below()).getBlock();
        if (lowerblock instanceof Pedestal != Boolean.TRUE) {
            return;
        }
        Pedestal pedestal = (Pedestal)lowerblock;
        if (pedestal.getType() == this.pedestalKey) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)SET, (Comparable)Boolean.valueOf(true)));
        }
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    static {
        COLLISION_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.0, (double)16.0);
        SHAPES = new LinkedHashMap<PedestalTypes, VoxelShape>();
        SHAPES.put(PedestalTypes.standing_torch_s, Block.box((double)4.0, (double)-6.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0));
        SHAPES.put(PedestalTypes.standing_torch_l, Block.box((double)4.0, (double)-2.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0));
        SHAPES.put(PedestalTypes.fire_pit_s, Block.box((double)0.0, (double)-10.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0));
        SHAPES.put(PedestalTypes.fire_pit_l, Block.box((double)0.0, (double)-2.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0));
        PARTICLE_TYPES = new LinkedHashMap<PedestalTypes, SimpleParticleType>();
        PARTICLE_TYPES.put(PedestalTypes.standing_torch_s, ParticleTypes.SMOKE);
        PARTICLE_TYPES.put(PedestalTypes.standing_torch_l, ParticleTypes.SMOKE);
        PARTICLE_TYPES.put(PedestalTypes.fire_pit_s, ParticleTypes.LARGE_SMOKE);
        PARTICLE_TYPES.put(PedestalTypes.fire_pit_l, ParticleTypes.LARGE_SMOKE);
        SMOKE_POS = new LinkedHashMap<PedestalTypes, Double>();
        SMOKE_POS.put(PedestalTypes.standing_torch_s, 0.2);
        SMOKE_POS.put(PedestalTypes.standing_torch_l, 0.7);
        SMOKE_POS.put(PedestalTypes.fire_pit_s, 0.0);
        SMOKE_POS.put(PedestalTypes.fire_pit_l, 0.8);
    }
}

