/*
 * Decompiled with CFR 0.152.
 */
package betteradvancements.common.gui;

import betteradvancements.common.advancements.BetterDisplayInfo;
import betteradvancements.common.api.IBetterAdvancementEntryGui;
import betteradvancements.common.api.event.IAdvancementDrawConnectionsEvent;
import betteradvancements.common.gui.BetterAdvancementTab;
import betteradvancements.common.gui.BetterAdvancementsScreen;
import betteradvancements.common.platform.Services;
import betteradvancements.common.reference.Resources;
import betteradvancements.common.util.CriterionGrid;
import betteradvancements.common.util.RenderUtil;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.advancements.AdvancementWidgetType;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class BetterAdvancementWidget
implements IBetterAdvancementEntryGui {
    protected static final int ADVANCEMENT_SIZE = 26;
    private static final int CORNER_SIZE = 10;
    private static final int WIDGET_WIDTH = 256;
    private static final int WIDGET_HEIGHT = 26;
    private static final int TITLE_SIZE = 32;
    private static final int ICON_OFFSET = 128;
    private static final int ICON_SIZE = 26;
    private final BetterAdvancementTab betterAdvancementTabGui;
    private final AdvancementNode advancementNode;
    protected final BetterDisplayInfo betterDisplayInfo;
    private final DisplayInfo displayInfo;
    private final String title;
    private int width;
    private List<FormattedCharSequence> description;
    private CriterionGrid criterionGrid;
    private final Minecraft minecraft;
    private BetterAdvancementWidget parent;
    private final List<BetterAdvancementWidget> children = Lists.newArrayList();
    private AdvancementProgress advancementProgress;
    protected int x;
    protected int y;
    private final int screenScale;

    public BetterAdvancementWidget(BetterAdvancementTab betterAdvancementTabGui, Minecraft mc, AdvancementNode advancementNode, DisplayInfo displayInfo) {
        this.betterAdvancementTabGui = betterAdvancementTabGui;
        this.advancementNode = advancementNode;
        this.betterDisplayInfo = betterAdvancementTabGui.getBetterDisplayInfo(this.advancementNode);
        this.displayInfo = displayInfo;
        this.minecraft = mc;
        this.title = displayInfo.getTitle().getString(163);
        this.x = this.betterDisplayInfo.getPosX() != null ? this.betterDisplayInfo.getPosX() : Mth.floor((float)(displayInfo.getX() * 32.0f));
        this.y = this.betterDisplayInfo.getPosY() != null ? this.betterDisplayInfo.getPosY() : Mth.floor((float)(displayInfo.getY() * 27.0f));
        this.refreshHover();
        this.screenScale = mc.getWindow().calculateScale(0, false);
    }

    private void refreshHover() {
        Minecraft mc = this.minecraft;
        int k = 0;
        if (this.advancementNode.advancement().requirements().size() > 1) {
            int strLengthRequirementCount = String.valueOf(this.advancementNode.advancement().requirements().size()).length();
            k = mc.font.width("  ") + mc.font.width("0") * strLengthRequirementCount * 2 + mc.font.width("/");
        }
        int titleWidth = 29 + mc.font.width(this.title) + k;
        BetterAdvancementsScreen screen = this.betterAdvancementTabGui.getScreen();
        this.criterionGrid = CriterionGrid.findOptimalCriterionGrid(this.advancementNode.holder(), this.advancementNode.advancement(), this.advancementProgress, screen.width / 2, mc.font);
        int maxWidth = !CriterionGrid.requiresShift || this.minecraft.hasShiftDown() ? Math.max(titleWidth, this.criterionGrid.width) : titleWidth;
        this.description = Language.getInstance().getVisualOrder(this.findOptimalLines((Component)ComponentUtils.mergeStyles((MutableComponent)this.displayInfo.getDescription().copy(), (Style)Style.EMPTY.withColor(this.displayInfo.getType().getChatColor())), maxWidth));
        for (FormattedCharSequence line : this.description) {
            maxWidth = Math.max(maxWidth, mc.font.width(line));
        }
        this.width = maxWidth + 8;
    }

    private List<FormattedText> findOptimalLines(Component line, int width) {
        if (line.getString().isEmpty()) {
            return Collections.emptyList();
        }
        StringSplitter stringsplitter = this.minecraft.font.getSplitter();
        List list = stringsplitter.splitLines((FormattedText)line, width, Style.EMPTY);
        if (list.size() > 1) {
            width = Math.max(width, this.betterAdvancementTabGui.getScreen().internalWidth / 4);
            list = stringsplitter.splitLines((FormattedText)line, width, Style.EMPTY);
        }
        while (list.size() > 5 && (double)width < 384.0 && (double)width < (double)this.betterAdvancementTabGui.getScreen().internalWidth / 2.5) {
            width += width / 4;
            list = stringsplitter.splitLines((FormattedText)line, width, Style.EMPTY);
        }
        return list;
    }

    private BetterAdvancementWidget getFirstVisibleParent(AdvancementNode advancement) {
        while ((advancement = advancement.parent()) != null && advancement.advancement().display().isEmpty()) {
        }
        if (advancement != null && !advancement.advancement().display().isEmpty()) {
            return this.betterAdvancementTabGui.getWidget(advancement.holder());
        }
        return null;
    }

    public void drawConnectivity(GuiGraphics guiGraphics, int scrollX, int scrollY, boolean drawInside) {
        if (!this.betterDisplayInfo.hideLines().booleanValue()) {
            if (this.parent != null) {
                this.drawConnection(guiGraphics, this.parent, scrollX, scrollY, drawInside);
            }
            IAdvancementDrawConnectionsEvent event = Services.PLATFORM.getEventHelper().postAdvancementDrawConnectionsEvent(this.advancementNode);
            for (AdvancementHolder advancementHolder : event.getExtraConnections()) {
                BetterAdvancementWidget parentGui = this.betterAdvancementTabGui.getWidget(advancementHolder);
                if (parentGui == null) continue;
                this.drawConnection(guiGraphics, parentGui, scrollX, scrollY, drawInside);
            }
        }
        for (BetterAdvancementWidget betterAdvancementWidget : this.children) {
            betterAdvancementWidget.drawConnectivity(guiGraphics, scrollX, scrollY, drawInside);
        }
    }

    public void drawConnection(GuiGraphics guiGraphics, BetterAdvancementWidget parent, int scrollX, int scrollY, boolean drawInside) {
        int innerLineColor = this.advancementProgress != null && this.advancementProgress.isDone() ? this.betterDisplayInfo.getCompletedLineColor() : this.betterDisplayInfo.getUnCompletedLineColor();
        int borderLineColor = -16777216;
        if (this.betterDisplayInfo.drawDirectLines().booleanValue()) {
            boolean perpendicular;
            float x1 = scrollX + this.x + 13 + 3;
            float y1 = scrollY + this.y + 13;
            float x2 = scrollX + parent.x + 13 + 3;
            float y2 = scrollY + parent.y + 13;
            boolean bl = perpendicular = x1 == x2 || y1 == y2;
            if (!perpendicular) {
                float width;
                switch (this.screenScale) {
                    case 1: {
                        width = drawInside ? 1.5f : 0.5f;
                        break;
                    }
                    case 2: {
                        width = drawInside ? 2.25f : 0.75f;
                        break;
                    }
                    case 3: {
                        width = drawInside ? 2.0f : 0.6666667f;
                        break;
                    }
                    case 4: {
                        width = drawInside ? 2.125f : 0.625f;
                        break;
                    }
                    default: {
                        float f = width = drawInside ? 3.0f : 1.0f;
                    }
                }
                if (drawInside) {
                    RenderUtil.drawRect(guiGraphics, x1 - 0.75f, y1 - 0.75f, x2 - 0.75f, y2 - 0.75f, width, borderLineColor);
                } else {
                    RenderUtil.drawRect(guiGraphics, x1, y1, x2, y2, width, innerLineColor);
                }
            } else {
                float width;
                float f = width = drawInside ? 3.0f : 1.0f;
                if (drawInside) {
                    RenderUtil.drawRect(guiGraphics, x1 - 1.0f, y1 - 1.0f, x2 - 1.0f, y2 - 1.0f, width, borderLineColor);
                } else {
                    RenderUtil.drawRect(guiGraphics, x1, y1, x2, y2, width, innerLineColor);
                }
            }
        } else {
            int startX = scrollX + parent.x + 13;
            int endXHalf = scrollX + parent.x + 26 + 6;
            int startY = scrollY + parent.y + 13;
            int endX = scrollX + this.x + 13;
            int endY = scrollY + this.y + 13;
            if (drawInside) {
                guiGraphics.hLine(endXHalf, startX, startY - 1, borderLineColor);
                guiGraphics.hLine(endXHalf + 1, startX, startY, borderLineColor);
                guiGraphics.hLine(endXHalf, startX, startY + 1, borderLineColor);
                guiGraphics.hLine(endX, endXHalf - 1, endY - 1, borderLineColor);
                guiGraphics.hLine(endX, endXHalf - 1, endY, borderLineColor);
                guiGraphics.hLine(endX, endXHalf - 1, endY + 1, borderLineColor);
                guiGraphics.vLine(endXHalf - 1, endY, startY, borderLineColor);
                guiGraphics.vLine(endXHalf + 1, endY, startY, borderLineColor);
            } else {
                guiGraphics.hLine(endXHalf, startX, startY, innerLineColor);
                guiGraphics.hLine(endX, endXHalf, endY, innerLineColor);
                guiGraphics.vLine(endXHalf, endY, startY, innerLineColor);
            }
        }
    }

    public void draw(GuiGraphics guiGraphics, int scrollX, int scrollY) {
        if (!this.displayInfo.isHidden() || this.advancementProgress != null && this.advancementProgress.isDone()) {
            float f = this.advancementProgress == null ? 0.0f : this.advancementProgress.getPercent();
            AdvancementWidgetType advancementState = f >= 1.0f ? AdvancementWidgetType.OBTAINED : AdvancementWidgetType.UNOBTAINED;
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, advancementState.frameSprite(this.displayInfo.getType()), scrollX + this.x + 3, scrollY + this.y, 26, 26, this.betterDisplayInfo.getIconColor(advancementState));
            guiGraphics.renderFakeItem(this.displayInfo.getIcon(), scrollX + this.x + 8, scrollY + this.y + 5, this.betterDisplayInfo.defaultIconColor());
        }
        for (BetterAdvancementWidget betterAdvancementWidget : this.children) {
            betterAdvancementWidget.draw(guiGraphics, scrollX, scrollY);
        }
    }

    public void getAdvancementProgress(AdvancementProgress advancementProgressIn) {
        this.advancementProgress = advancementProgressIn;
        this.refreshHover();
    }

    public void addGuiAdvancement(BetterAdvancementWidget betterAdvancementEntryScreen) {
        this.children.add(betterAdvancementEntryScreen);
    }

    public void drawHover(GuiGraphics guiGraphics, int scrollX, int scrollY, float fade, int left, int top, float zoom) {
        int boxHeight;
        int rounded_scaled_scrolled_y;
        AdvancementWidgetType stateIcon;
        AdvancementWidgetType stateTitleRight;
        AdvancementWidgetType stateTitleLeft;
        boolean drawTop;
        int i;
        this.refreshHover();
        float scaled_scrolled_x = (float)(scrollX + this.x) * zoom;
        float scaled_scrolled_y = (float)(scrollY + this.y) * zoom;
        boolean drawLeft = (float)left + scaled_scrolled_x + (float)this.width + 26.0f >= (float)this.betterAdvancementTabGui.getScreen().internalWidth;
        String s = this.advancementProgress == null || this.advancementProgress.getProgressText() == null ? null : this.advancementProgress.getProgressText().getString();
        int n = i = s == null ? 0 : this.minecraft.font.width(s);
        if (!CriterionGrid.requiresShift || this.minecraft.hasShiftDown()) {
            if (this.criterionGrid.height < this.betterAdvancementTabGui.getScreen().height) {
                float f = (float)top + scaled_scrolled_y;
                int n2 = this.description.size();
                Objects.requireNonNull(this.minecraft.font);
                drawTop = f + (float)(n2 * 9) + (float)this.criterionGrid.height + 50.0f >= (float)this.betterAdvancementTabGui.getScreen().height;
            } else {
                drawTop = false;
            }
        } else {
            float f = (float)top + scaled_scrolled_y;
            int n3 = this.description.size();
            Objects.requireNonNull(this.minecraft.font);
            drawTop = f + (float)(n3 * 9) + 50.0f >= (float)this.betterAdvancementTabGui.getScreen().height;
        }
        float percentageObtained = this.advancementProgress == null ? 0.0f : this.advancementProgress.getPercent();
        int j = Mth.floor((float)(percentageObtained * (float)this.width));
        if (percentageObtained >= 1.0f) {
            j = this.width / 2;
            stateTitleLeft = AdvancementWidgetType.OBTAINED;
            stateTitleRight = AdvancementWidgetType.OBTAINED;
            stateIcon = AdvancementWidgetType.OBTAINED;
        } else if (j < 2) {
            j = this.width / 2;
            stateTitleLeft = AdvancementWidgetType.UNOBTAINED;
            stateTitleRight = AdvancementWidgetType.UNOBTAINED;
            stateIcon = AdvancementWidgetType.UNOBTAINED;
        } else if (j > this.width - 2) {
            j = this.width / 2;
            stateTitleLeft = AdvancementWidgetType.OBTAINED;
            stateTitleRight = AdvancementWidgetType.OBTAINED;
            stateIcon = AdvancementWidgetType.UNOBTAINED;
        } else {
            stateTitleLeft = AdvancementWidgetType.OBTAINED;
            stateTitleRight = AdvancementWidgetType.UNOBTAINED;
            stateIcon = AdvancementWidgetType.UNOBTAINED;
        }
        int k = this.width - j;
        int rounded_scaled_scrolled_x = Math.round(scaled_scrolled_x);
        int drawY = rounded_scaled_scrolled_y = Math.round(scaled_scrolled_y);
        int drawX = drawLeft ? rounded_scaled_scrolled_x - this.width + 26 + 6 : rounded_scaled_scrolled_x;
        if (!CriterionGrid.requiresShift || this.minecraft.hasShiftDown()) {
            int n4 = this.description.size();
            Objects.requireNonNull(this.minecraft.font);
            boxHeight = 32 + n4 * 9 + this.criterionGrid.height;
        } else {
            int n5 = this.description.size();
            Objects.requireNonNull(this.minecraft.font);
            boxHeight = 32 + n5 * 9;
        }
        if (!this.description.isEmpty()) {
            if (drawTop) {
                this.render9Sprite(guiGraphics, drawX, drawY + 26 - boxHeight, this.width, boxHeight, 10, 256, 26, 0, 52);
            } else {
                this.render9Sprite(guiGraphics, drawX, drawY, this.width, boxHeight, 10, 256, 26, 0, 52);
            }
        }
        int left_side = Math.min(j, 240);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, Resources.Gui.WIDGETS, drawX, drawY, 0.0f, (float)(this.betterDisplayInfo.getTitleYMultiplier(stateTitleLeft) * 26), left_side, 26, 256, 256, this.betterDisplayInfo.getTitleColor(stateTitleLeft));
        if (left_side < j) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, Resources.Gui.WIDGETS, drawX + left_side, drawY, 16.0f, (float)(this.betterDisplayInfo.getTitleYMultiplier(stateTitleLeft) * 26), j - left_side, 26, 256, 256, this.betterDisplayInfo.getTitleColor(stateTitleLeft));
        }
        int right_side = Math.min(k, 240);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, Resources.Gui.WIDGETS, drawX + j, drawY, (float)(256 - right_side), (float)(this.betterDisplayInfo.getTitleYMultiplier(stateTitleRight) * 26), right_side, 26, 256, 256, this.betterDisplayInfo.getTitleColor(stateTitleRight));
        if (right_side < k) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, Resources.Gui.WIDGETS, drawX + j + right_side - 2, drawY, (float)(256 - k + right_side - 2), (float)(this.betterDisplayInfo.getTitleYMultiplier(stateTitleRight) * 26), k - right_side + 2, 26, 256, 256, this.betterDisplayInfo.getTitleColor(stateTitleRight));
        }
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, stateIcon.frameSprite(this.displayInfo.getType()), rounded_scaled_scrolled_x + 3, rounded_scaled_scrolled_y, 26, 26, this.betterDisplayInfo.getIconColor(stateIcon));
        if (drawLeft) {
            guiGraphics.drawString(this.minecraft.font, this.title, drawX + 5, rounded_scaled_scrolled_y + 9, -1);
            if (s != null) {
                guiGraphics.drawString(this.minecraft.font, s, rounded_scaled_scrolled_x - i, rounded_scaled_scrolled_y + 9, -1);
            }
        } else {
            guiGraphics.drawString(this.minecraft.font, this.title, rounded_scaled_scrolled_x + 32, rounded_scaled_scrolled_y + 9, -1);
            if (s != null) {
                guiGraphics.drawString(this.minecraft.font, s, rounded_scaled_scrolled_x + this.width - i - 5, rounded_scaled_scrolled_y + 9, -1);
            }
        }
        int yOffset = drawTop ? drawY + 26 - boxHeight + 7 : rounded_scaled_scrolled_y + 9 + 17;
        for (int k1 = 0; k1 < this.description.size(); ++k1) {
            Font font = this.minecraft.font;
            Objects.requireNonNull(this.minecraft.font);
            guiGraphics.drawString(font, this.description.get(k1), drawX + 5, yOffset + k1 * 9, -5592406, false);
        }
        if (this.criterionGrid != null && !CriterionGrid.requiresShift || this.minecraft.hasShiftDown()) {
            int xOffset = drawX + 5;
            int n6 = this.description.size();
            Objects.requireNonNull(this.minecraft.font);
            yOffset += n6 * 9;
            for (int colIndex = 0; colIndex < this.criterionGrid.columns.size(); ++colIndex) {
                CriterionGrid.Column col = this.criterionGrid.columns.get(colIndex);
                for (int rowIndex = 0; rowIndex < col.cells().size(); ++rowIndex) {
                    Font font = this.minecraft.font;
                    Objects.requireNonNull(this.minecraft.font);
                    guiGraphics.drawString(font, col.cells().get(rowIndex), xOffset, yOffset + rowIndex * 9, -5592406, false);
                }
                xOffset += col.width();
            }
        }
        guiGraphics.renderFakeItem(this.displayInfo.getIcon(), rounded_scaled_scrolled_x + 8, rounded_scaled_scrolled_y + 5);
    }

    protected void render9Sprite(GuiGraphics guiGraphics, int x, int y, int width, int height, int textureHeight, int textureWidth, int textureDistance, int textureX, int textureY) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, Resources.Gui.WIDGETS, x, y, (float)textureX, (float)textureY, textureHeight, textureHeight, 256, 256);
        RenderUtil.renderRepeating(Resources.Gui.WIDGETS, guiGraphics, x + textureHeight, y, width - textureHeight - textureHeight, textureHeight, textureX + textureHeight, textureY, textureWidth - textureHeight - textureHeight, textureDistance);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, Resources.Gui.WIDGETS, x + width - textureHeight, y, (float)(textureX + textureWidth - textureHeight), (float)textureY, textureHeight, textureHeight, 256, 256);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, Resources.Gui.WIDGETS, x, y + height - textureHeight, (float)textureX, (float)(textureY + textureDistance - textureHeight), textureHeight, textureHeight, 256, 256);
        RenderUtil.renderRepeating(Resources.Gui.WIDGETS, guiGraphics, x + textureHeight, y + height - textureHeight, width - textureHeight - textureHeight, textureHeight, textureX + textureHeight, textureY + textureDistance - textureHeight, textureWidth - textureHeight - textureHeight, textureDistance);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, Resources.Gui.WIDGETS, x + width - textureHeight, y + height - textureHeight, (float)(textureX + textureWidth - textureHeight), (float)(textureY + textureDistance - textureHeight), textureHeight, textureHeight, 256, 256);
        RenderUtil.renderRepeating(Resources.Gui.WIDGETS, guiGraphics, x, y + textureHeight, textureHeight, height - textureHeight - textureHeight, textureX, textureY + textureHeight, textureWidth, textureDistance - textureHeight - textureHeight);
        RenderUtil.renderRepeating(Resources.Gui.WIDGETS, guiGraphics, x + textureHeight, y + textureHeight, width - textureHeight - textureHeight, height - textureHeight - textureHeight, textureX + textureHeight, textureY + textureHeight, textureWidth - textureHeight - textureHeight, textureDistance - textureHeight - textureHeight);
        RenderUtil.renderRepeating(Resources.Gui.WIDGETS, guiGraphics, x + width - textureHeight, y + textureHeight, textureHeight, height - textureHeight - textureHeight, textureX + textureWidth - textureHeight, textureY + textureHeight, textureWidth, textureDistance - textureHeight - textureHeight);
    }

    public boolean isMouseOver(double scrollX, double scrollY, double mouseX, double mouseY, float zoom) {
        if (!this.displayInfo.isHidden() || this.advancementProgress != null && this.advancementProgress.isDone()) {
            double left = scrollX + (double)this.x;
            double right = left + 26.0;
            double top = scrollY + (double)this.y;
            double bottom = top + 26.0;
            return mouseX >= left * (double)zoom && mouseX <= right * (double)zoom && mouseY >= top * (double)zoom && mouseY <= bottom * (double)zoom;
        }
        return false;
    }

    public void attachToParent() {
        if (this.parent == null && this.advancementNode.advancement().parent().isPresent()) {
            this.parent = this.getFirstVisibleParent(this.advancementNode);
            if (this.parent != null) {
                this.parent.addGuiAdvancement(this);
            }
        }
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getX() {
        return this.x;
    }

    public AdvancementNode getAdvancement() {
        return this.advancementNode;
    }
}

