/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.buriedwrecks.datagen;

import com.mrbysco.buriedwrecks.BuriedWrecks;
import com.mrbysco.buriedwrecks.datagen.StructureUpdater;
import com.mrbysco.buriedwrecks.registry.ModStructureSets;
import com.mrbysco.buriedwrecks.registry.ModStructures;
import com.mrbysco.buriedwrecks.util.BuriedBiomeTags;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.BiomeTagsProvider;
import net.minecraft.data.tags.KeyTagProvider;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber
public class BuriedDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(true, (DataProvider)new BuriedWrecksDatapackProvider(packOutput, lookupProvider, Set.of("buriedwrecks")));
        generator.addProvider(true, (DataProvider)new BuriedStructureFeatureTagProvider(packOutput, CompletableFuture.supplyAsync(() -> BuriedWrecksDatapackProvider.BUILDER.build((RegistryAccess)RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY)))));
        generator.addProvider(true, (DataProvider)new BuriedBiomeTagProvider(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new StructureUpdater("structure/buried_shipwreck", packOutput, event.getResourceManager(PackType.SERVER_DATA)));
        generator.addProvider(true, (DataProvider)new BuriedStructureLanguageProvider(packOutput));
    }

    public static class BuriedWrecksDatapackProvider
    extends DatapackBuiltinEntriesProvider {
        public static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().add(Registries.STRUCTURE, ModStructures::bootstrap).add(Registries.STRUCTURE_SET, ModStructureSets::bootstrap).add(Registries.BIOME, $ -> {});

        public BuriedWrecksDatapackProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, Set<String> modIds) {
            super(output, registries, BUILDER, modIds);
        }
    }

    public static class BuriedStructureFeatureTagProvider
    extends KeyTagProvider<Structure> {
        public BuriedStructureFeatureTagProvider(PackOutput generator, CompletableFuture<HolderLookup.Provider> completableFuture) {
            super(generator, Registries.STRUCTURE, completableFuture, "buriedwrecks");
        }

        protected void addTags(HolderLookup.Provider provider) {
            this.tag(BuriedWrecks.HAS_BURIED_WRECK).add(ModStructures.BURIED_SHIPWRECK);
        }
    }

    public static class BuriedBiomeTagProvider
    extends BiomeTagsProvider {
        public BuriedBiomeTagProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> completableFuture) {
            super(packOutput, completableFuture, "buriedwrecks");
        }

        protected void addTags(HolderLookup.Provider provider) {
            this.tag(BuriedBiomeTags.HAS_BURIED_SHIPWRECK).addTag(BiomeTags.IS_OVERWORLD);
        }
    }

    public static class BuriedStructureLanguageProvider
    extends LanguageProvider {
        public BuriedStructureLanguageProvider(PackOutput output) {
            super(output, "buriedwrecks", "en_us");
        }

        protected void addTranslations() {
            this.addConfig("generation", "Generation", "Generation Settings");
            this.addConfig("overwriteYLevel", "Overwrite Y Level", "Overwrite the default yLevel with the y level specified in 'yLevel'");
            this.addConfig("yLevel", "Y Level", "The Y level it'll try to generate ship wrecks at");
        }

        private void addConfig(String path, String name, @Nullable String description) {
            this.add("buriedwrecks.configuration." + path, name);
            if (description != null && !description.isEmpty()) {
                this.add("buriedwrecks.configuration." + path + ".tooltip", description);
            }
        }
    }
}

