/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.buriedwrecks.datagen;

import com.google.common.hash.Hashing;
import com.mojang.datafixers.DataFixerUpper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.NotNull;

public class StructureUpdater
implements DataProvider {
    private final String basePath;
    private final PackOutput output;
    private final ResourceManager resources;

    public StructureUpdater(String basePath, PackOutput output, ResourceManager manager) {
        this.basePath = basePath;
        this.output = output;
        this.resources = manager;
    }

    @NotNull
    public CompletableFuture<?> run(@Nonnull CachedOutput cache) {
        try {
            for (Map.Entry entry : this.resources.listResources(this.basePath, $ -> true).entrySet()) {
                if (!((Identifier)entry.getKey()).getNamespace().equals("buriedwrecks")) continue;
                this.process((Identifier)entry.getKey(), (Resource)entry.getValue(), cache);
            }
            return CompletableFuture.completedFuture(null);
        }
        catch (IOException x) {
            return CompletableFuture.failedFuture(x);
        }
    }

    private void process(Identifier loc, Resource resource, CachedOutput cache) throws IOException {
        CompoundTag inputNBT = NbtIo.readCompressed((InputStream)resource.open(), (NbtAccounter)NbtAccounter.unlimitedHeap());
        CompoundTag converted = StructureUpdater.updateNBT(inputNBT);
        if (!converted.equals((Object)inputNBT)) {
            Class fixerClass = DataFixers.getDataFixer().getClass();
            if (!fixerClass.equals(DataFixerUpper.class)) {
                throw new RuntimeException("Structures are not up to date, but unknown data fixer is in use: " + fixerClass.getName());
            }
            this.writeNBTTo(loc, converted, cache);
        }
    }

    private void writeNBTTo(Identifier loc, CompoundTag data, CachedOutput cache) throws IOException {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        NbtIo.writeCompressed((CompoundTag)data, (OutputStream)bytearrayoutputstream);
        byte[] bytes = bytearrayoutputstream.toByteArray();
        Path outputPath = this.output.getOutputFolder().resolve("data/" + loc.getNamespace() + "/" + loc.getPath());
        cache.writeIfNeeded(outputPath, bytes, Hashing.sha1().hashBytes(bytes));
    }

    private static CompoundTag updateNBT(CompoundTag nbt) {
        CompoundTag updatedNBT = DataFixTypes.STRUCTURE.updateToCurrentVersion(DataFixers.getDataFixer(), nbt, nbt.getIntOr("DataVersion", 0));
        StructureTemplate template = new StructureTemplate();
        template.load((HolderGetter)BuiltInRegistries.BLOCK, updatedNBT);
        return template.save(new CompoundTag());
    }

    @Nonnull
    public String getName() {
        return "Update structure files in " + this.basePath;
    }
}

