/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.buriedwrecks.structure;

import com.mrbysco.buriedwrecks.BuriedWrecks;
import com.mrbysco.buriedwrecks.registry.ModStructurePieceTypes;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;

public class BuriedShipwreckPieces {
    static final BlockPos PIVOT = new BlockPos(4, 0, 15);
    private static final Identifier[] STRUCTURE_LOCATION_BEACHED = new Identifier[]{BuriedWrecks.modLoc("buried_shipwreck/with_mast"), BuriedWrecks.modLoc("buried_shipwreck/sideways_full"), BuriedWrecks.modLoc("buried_shipwreck/sideways_fronthalf"), BuriedWrecks.modLoc("buried_shipwreck/sideways_backhalf"), BuriedWrecks.modLoc("buried_shipwreck/rightsideup_full"), BuriedWrecks.modLoc("buried_shipwreck/rightsideup_fronthalf"), BuriedWrecks.modLoc("buried_shipwreck/rightsideup_backhalf"), BuriedWrecks.modLoc("buried_shipwreck/with_mast_degraded"), BuriedWrecks.modLoc("buried_shipwreck/rightsideup_full_degraded"), BuriedWrecks.modLoc("buried_shipwreck/rightsideup_fronthalf_degraded"), BuriedWrecks.modLoc("buried_shipwreck/rightsideup_backhalf_degraded")};
    private static final Identifier[] STRUCTURE_LOCATION_OCEAN = new Identifier[]{BuriedWrecks.modLoc("buried_shipwreck/with_mast"), BuriedWrecks.modLoc("buried_shipwreck/upsidedown_full"), BuriedWrecks.modLoc("buried_shipwreck/upsidedown_fronthalf"), BuriedWrecks.modLoc("buried_shipwreck/upsidedown_backhalf"), BuriedWrecks.modLoc("buried_shipwreck/sideways_full"), BuriedWrecks.modLoc("buried_shipwreck/sideways_fronthalf"), BuriedWrecks.modLoc("buried_shipwreck/sideways_backhalf"), BuriedWrecks.modLoc("buried_shipwreck/rightsideup_full"), BuriedWrecks.modLoc("buried_shipwreck/rightsideup_fronthalf"), BuriedWrecks.modLoc("buried_shipwreck/rightsideup_backhalf"), BuriedWrecks.modLoc("buried_shipwreck/with_mast_degraded"), BuriedWrecks.modLoc("buried_shipwreck/upsidedown_full_degraded"), BuriedWrecks.modLoc("buried_shipwreck/upsidedown_fronthalf_degraded"), BuriedWrecks.modLoc("buried_shipwreck/upsidedown_backhalf_degraded"), BuriedWrecks.modLoc("buried_shipwreck/sideways_full_degraded"), BuriedWrecks.modLoc("buried_shipwreck/sideways_fronthalf_degraded"), BuriedWrecks.modLoc("buried_shipwreck/sideways_backhalf_degraded"), BuriedWrecks.modLoc("buried_shipwreck/rightsideup_full_degraded"), BuriedWrecks.modLoc("buried_shipwreck/rightsideup_fronthalf_degraded"), BuriedWrecks.modLoc("buried_shipwreck/rightsideup_backhalf_degraded")};
    static final Map<String, ResourceKey<LootTable>> MARKERS_TO_LOOT = Map.of("map_chest", BuiltInLootTables.SHIPWRECK_MAP, "treasure_chest", BuiltInLootTables.SHIPWRECK_TREASURE, "supply_chest", BuiltInLootTables.SHIPWRECK_SUPPLY);

    public static void addPieces(StructureTemplateManager templateManager, BlockPos pos, Rotation rotation, StructurePieceAccessor pieceAccessor, RandomSource randomSource, boolean isBeached) {
        Identifier identifier = (Identifier)Util.getRandom((Object[])(isBeached ? STRUCTURE_LOCATION_BEACHED : STRUCTURE_LOCATION_OCEAN), (RandomSource)randomSource);
        pieceAccessor.addPiece((StructurePiece)new BuriedShipwreckPiece(templateManager, identifier, pos, rotation, isBeached));
    }

    public static class BuriedShipwreckPiece
    extends TemplateStructurePiece {
        private final boolean isBeached;

        public BuriedShipwreckPiece(StructureTemplateManager templateManager, Identifier structureLocation, BlockPos pos, Rotation rotation, boolean beached) {
            super(ModStructurePieceTypes.BURIED_SHIPWRECK_PIECE.get(), 0, templateManager, structureLocation, structureLocation.toString(), BuriedShipwreckPiece.makeSettings(rotation), pos);
            this.isBeached = beached;
        }

        public BuriedShipwreckPiece(StructureTemplateManager templateManager, CompoundTag tag) {
            super(ModStructurePieceTypes.BURIED_SHIPWRECK_PIECE.get(), tag, templateManager, location -> BuriedShipwreckPiece.makeSettings(Rotation.valueOf((String)tag.getStringOr("Rot", ""))));
            this.isBeached = tag.getBooleanOr("isBeached", false);
        }

        protected void addAdditionalSaveData(StructurePieceSerializationContext serializationContext, CompoundTag tag) {
            super.addAdditionalSaveData(serializationContext, tag);
            tag.putBoolean("isBeached", this.isBeached);
            tag.putString("Rot", this.placeSettings.getRotation().name());
        }

        private static StructurePlaceSettings makeSettings(Rotation rotation) {
            return new StructurePlaceSettings().setRotation(rotation).setMirror(Mirror.NONE).setRotationPivot(PIVOT).addProcessor((StructureProcessor)BlockIgnoreProcessor.STRUCTURE_AND_AIR);
        }

        protected void handleDataMarker(String pName, BlockPos pPos, ServerLevelAccessor pLevel, RandomSource pRandom, BoundingBox pBox) {
            ResourceKey<LootTable> resourcekey = MARKERS_TO_LOOT.get(pName);
            if (resourcekey != null) {
                RandomizableContainer.setBlockEntityLootTable((BlockGetter)pLevel, (RandomSource)pRandom, (BlockPos)pPos.below(), resourcekey);
            }
        }

        public void postProcess(WorldGenLevel worldGenLevel, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos pos) {
            int i = worldGenLevel.getHeight();
            int j = pos.getY();
            Vec3i vec3i = this.template.getSize();
            int i1 = this.isBeached ? i - vec3i.getY() / 2 - random.nextInt(3) : j;
            this.templatePosition = new BlockPos(this.templatePosition.getX(), i1, this.templatePosition.getZ());
            super.postProcess(worldGenLevel, structureManager, chunkGenerator, random, boundingBox, chunkPos, pos);
        }
    }
}

