/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.cardboardboxes;

import com.builtbroken.cardboardboxes.box.BoxBlock;
import com.builtbroken.cardboardboxes.box.BoxBlockEntity;
import com.builtbroken.cardboardboxes.box.BoxBlockItem;
import com.builtbroken.cardboardboxes.handler.HandlerManager;
import com.builtbroken.cardboardboxes.mods.ModHandler;
import com.builtbroken.cardboardboxes.mods.VanillaHandler;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

@Mod(value="cardboardboxes")
public class Cardboardboxes {
    public static final String DOMAIN = "cardboardboxes";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"cardboardboxes");
    public static final DeferredBlock<BoxBlock> BOX_BLOCK = BLOCKS.registerBlock("cardboardbox", p -> new BoxBlock(null, (BlockBehaviour.Properties)p));
    public static final List<DeferredBlock<BoxBlock>> BOX_COLORS = Arrays.stream(TabSortedColors.values()).map(TabSortedColors::toDyeColor).map(color -> BLOCKS.registerBlock("box_" + color.getName(), p -> new BoxBlock((DyeColor)color, (BlockBehaviour.Properties)p))).toList();
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"cardboardboxes");
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<BoxBlockEntity>> BOX_BLOCK_ENTITY_TYPE = BLOCK_ENTITY_TYPES.register("box", () -> {
        ArrayList<BoxBlock> boxList = new ArrayList<BoxBlock>(BOX_COLORS.stream().map(DeferredHolder::get).toList());
        boxList.add(0, (BoxBlock)((Object)((Object)BOX_BLOCK.get())));
        return new BlockEntityType(BoxBlockEntity::new, (Block[])boxList.toArray(new BoxBlock[boxList.size()]));
    });
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"cardboardboxes");
    public static final DeferredItem<BoxBlockItem> BOX_ITEM = ITEMS.registerItem("cardboardbox", p -> new BoxBlockItem((Block)BOX_BLOCK.get(), null, (Item.Properties)p), () -> new Item.Properties().useBlockDescriptionPrefix());
    public static final List<DeferredItem<BoxBlockItem>> BOX_ITEM_COLORS = BOX_COLORS.stream().map(defBlock -> ITEMS.registerItem(defBlock.getId().getPath(), p -> new BoxBlockItem((Block)defBlock.get(), ((BoxBlock)((Object)((Object)((Object)defBlock.get())))).color, (Item.Properties)p), () -> new Item.Properties().useBlockDescriptionPrefix())).toList();
    private static ModConfigSpec config;

    public Cardboardboxes(IEventBus modBus, ModContainer modContainer) {
        modBus.addListener(this::setup);
        modBus.addListener(this::onCreativeModeTabBuildContents);
        ModHandler.modSupportHandlerMap.put("minecraft", VanillaHandler.class);
        config = ModHandler.buildHandlerData();
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)config);
        LOGGER.info("Finished building the config -> " + String.valueOf(config));
        BLOCKS.register(modBus);
        BLOCK_ENTITY_TYPES.register(modBus);
        ITEMS.register(modBus);
    }

    private void setup(FMLCommonSetupEvent e) {
        HandlerManager.INSTANCE.banBlock((Block)BOX_BLOCK.get());
        BOX_COLORS.forEach(defBlock -> HandlerManager.INSTANCE.banBlock((Block)defBlock.get()));
        HandlerManager.INSTANCE.banBlockEntity((BlockEntityType)BOX_BLOCK_ENTITY_TYPE.get());
        ModHandler.loadHandlerData(config);
    }

    private void onCreativeModeTabBuildContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.FUNCTIONAL_BLOCKS || event.getTabKey() == CreativeModeTabs.COLORED_BLOCKS) {
            event.accept((ItemLike)BOX_ITEM.get());
            BOX_COLORS.forEach(defBlock -> event.accept((ItemLike)defBlock.get()));
        }
    }

    public static enum TabSortedColors {
        WHITE(0),
        LIGHT_GRAY(8),
        GRAY(7),
        BLACK(15),
        BROWN(12),
        RED(14),
        ORANGE(1),
        YELLOW(4),
        LIME(5),
        GREEN(13),
        CYAN(9),
        LIGHT_BLUE(3),
        BLUE(11),
        PURPLE(10),
        MAGENTA(2),
        PINK(6);

        private int dyeColorId;

        private TabSortedColors(int dyeColorId) {
            this.dyeColorId = dyeColorId;
        }

        public DyeColor toDyeColor() {
            return DyeColor.byId((int)this.dyeColorId);
        }
    }
}

