/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.cardboardboxes.box;

import com.builtbroken.cardboardboxes.Cardboardboxes;
import com.builtbroken.cardboardboxes.box.BoxBlockEntity;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.phys.BlockHitResult;

public class BoxBlock
extends BaseEntityBlock {
    public static final String STORE_ITEM_TAG = "storedItem";
    public static final String BLOCK_ENTITY_DATA_TAG = "tileData";
    public final DyeColor color;

    public BoxBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(properties.mapColor(color == null ? MapColor.DIRT : color.getMapColor()).strength(2.0f, 2.0f));
        this.color = color;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void attack(BlockState state, Level level, BlockPos pos, Player player) {
        BoxBlockEntity boxBlockEntity;
        BlockEntity blockEntity;
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof BoxBlockEntity && (boxBlockEntity = (BoxBlockEntity)blockEntity).getStateForPlacement() != null && level.setBlock(pos, boxBlockEntity.getStateForPlacement(), 3)) {
            boxBlockEntity.getDataForPlacement().ifPresent(compound -> {
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity != null) {
                    try (ProblemReporter.ScopedCollector problemReporter = new ProblemReporter.ScopedCollector(blockEntity.problemPath(), Cardboardboxes.LOGGER);){
                        ValueInput valueInput = TagValueInput.create((ProblemReporter)problemReporter, (HolderLookup.Provider)level.registryAccess(), (CompoundTag)compound);
                        blockEntity.loadWithComponents(valueInput);
                    }
                }
            });
            if (!player.isCreative()) {
                ItemStack stack = new ItemStack((ItemLike)this);
                if (player.getInventory().add(stack)) {
                    player.spawnAtLocation((ServerLevel)level, stack, 0.0f);
                }
            }
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (level.isClientSide()) {
            return InteractionResult.PASS;
        }
        if (player.isShiftKeyDown()) {
            ItemStack stack = this.toItemStack((BlockGetter)level, pos);
            if (stack != null) {
                if (player.getInventory().add(stack)) {
                    player.getInventory().setChanged();
                    level.removeBlock(pos, false);
                    return InteractionResult.SUCCESS;
                }
                player.displayClientMessage((Component)Component.translatable((String)(((BoxBlock)((Object)Cardboardboxes.BOX_BLOCK.get())).getDescriptionId() + ".inventoryFull")), true);
                return InteractionResult.PASS;
            }
            player.displayClientMessage((Component)Component.translatable((String)(((BoxBlock)((Object)Cardboardboxes.BOX_BLOCK.get())).getDescriptionId() + ".error.stack.null")), true);
        }
        return InteractionResult.PASS;
    }

    public ItemStack toItemStack(BlockGetter level, BlockPos pos) {
        ItemStack stack = new ItemStack((ItemLike)this);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BoxBlockEntity) {
            BoxBlockEntity blockEntity2 = (BoxBlockEntity)blockEntity;
            if (blockEntity2.getStateForPlacement() != null) {
                CompoundTag tag = new CompoundTag();
                tag.putInt(STORE_ITEM_TAG, Block.getId((BlockState)blockEntity2.getStateForPlacement()));
                blockEntity2.getDataForPlacement().ifPresent(data -> tag.put(BLOCK_ENTITY_DATA_TAG, (Tag)data));
                CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, (CompoundTag)tag);
            } else {
                System.out.println("Error: block entity does not have an ItemStack");
            }
        }
        return stack;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData, Player player) {
        return this.toItemStack((BlockGetter)level, pos);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BoxBlockEntity(pos, state);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }
}

