/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.concreteconversion;

import java.util.ServiceLoader;
import mrp_v2.concreteconversion.event.ConcreteEvents;
import mrp_v2.concreteconversion.server.ConcreteConfigCommon;
import mrp_v2.concreteconversion.util.EventHandlerCommon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcreteConversionCommon {
    public static final String ID = "concreteconversion";
    public static final Logger LOG = LoggerFactory.getLogger((String)"concreteconversion");
    public static final ConcreteConfigCommon CONFIG = ConcreteConversionCommon.load(ConcreteConfigCommon.class);

    public static void init() {
        ConcreteEvents.ITEM_TOSS.register(EventHandlerCommon::itemTossEvent);
        ConcreteEvents.SERVER_LEVEL_TICK.register(EventHandlerCommon::worldTickEvent);
    }

    public static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        LOG.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }
}

