/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.concreteconversion.datagen;

import java.util.concurrent.CompletableFuture;
import mrp_v2.concreteconversion.datagen.ConcreteLanguage;
import mrp_v2.concreteconversion.datagen.ConcreteRecipes;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.packs.VanillaRecipeProvider;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public class DataGeneration {
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator gen = event.getGenerator();
        PackOutput packOutput = gen.getPackOutput();
        gen.addProvider(true, (DataProvider)new RecipeProvider.Runner(packOutput, event.getLookupProvider()));
        gen.addProvider(true, (DataProvider)new LanguageProvider(packOutput, "en_us"));
    }

    public static class RecipeProvider
    extends VanillaRecipeProvider {
        public RecipeProvider(HolderLookup.Provider lookupProvider, RecipeOutput output) {
            super(lookupProvider, output);
        }

        protected void buildRecipes() {
            ConcreteRecipes.generatePowderFromConcreteRecipes(this.output, this::has);
        }

        protected Criterion<InventoryChangeTrigger.TriggerInstance> has(ItemLike item) {
            return net.minecraft.data.recipes.RecipeProvider.inventoryTrigger((ItemPredicate.Builder[])new ItemPredicate.Builder[]{ItemPredicate.Builder.item().of((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), new ItemLike[]{item})});
        }

        public static class Runner
        extends VanillaRecipeProvider.Runner {
            public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
                super(output, lookupProvider);
            }

            protected RecipeProvider createRecipeProvider(HolderLookup.Provider lookupProvider, RecipeOutput output) {
                return new RecipeProvider(lookupProvider, output);
            }
        }
    }

    public static class LanguageProvider
    extends net.neoforged.neoforge.common.data.LanguageProvider {
        public LanguageProvider(PackOutput output, String locale) {
            super(output, "concreteconversion", locale);
        }

        protected void addTranslations() {
            ConcreteLanguage.english((arg_0, arg_1) -> ((LanguageProvider)this).add(arg_0, arg_1));
        }
    }
}

