/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.concreteconversion.server;

import mrp_v2.concreteconversion.ConcreteConversionCommon;
import mrp_v2.concreteconversion.server.ConcreteConfigCommon;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final Config SERVER;
    public static final ModConfigSpec serverSpec;
    protected final ModConfigSpec.BooleanValue onlyPlayerThrownItems;
    protected final ModConfigSpec.IntValue conversionCheckDelay;
    protected final ModConfigSpec.IntValue conversionDelay;
    protected final ModConfigSpec.BooleanValue disableVanillaConversionMechanic;
    protected final ModConfigSpec.BooleanValue convertMud;
    protected boolean opti;
    protected int ccd;
    protected int cd;
    protected boolean dvcm;
    protected boolean cm;

    private Config(ModConfigSpec.Builder builder) {
        builder.comment(" Server configuration settings").push("server");
        this.onlyPlayerThrownItems = builder.comment(ConcreteConfigCommon.OPTI_COMMENT).translation(ConcreteConversionCommon.CONFIG.getTranslationKey("onlyPlayerThrownItems")).define("onlyPlayerThrownItems", true);
        this.conversionCheckDelay = builder.comment(ConcreteConfigCommon.CCD_COMMENT).translation(ConcreteConversionCommon.CONFIG.getTranslationKey("conversionCheckDelay")).defineInRange("conversionCheckDelay", 20, 1, 200);
        this.conversionDelay = builder.comment(ConcreteConfigCommon.CD_COMMENT).translation(ConcreteConversionCommon.CONFIG.getTranslationKey("conversionDelay")).defineInRange("conversionDelay", 0, 0, 6000);
        this.disableVanillaConversionMechanic = builder.comment(ConcreteConfigCommon.DVCM_COMMENT).translation(ConcreteConversionCommon.CONFIG.getTranslationKey("disableVanillaConversionMechanic")).define("disableVanillaConversionMechanic", false);
        this.convertMud = builder.comment(ConcreteConfigCommon.CM_COMMENT).translation(ConcreteConversionCommon.CONFIG.getTranslationKey("convertMud")).define("convertMud", false);
        builder.pop();
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Config::new);
        serverSpec = (ModConfigSpec)specPair.getRight();
        SERVER = (Config)specPair.getLeft();
    }
}

