/*
 * Decompiled with CFR 0.152.
 */
package mrp_v2.concreteconversion.util;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import mrp_v2.concreteconversion.ConcreteConversionCommon;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ConcretePowderBlock;
import net.minecraft.world.level.entity.EntityTypeTest;

public class EventHandlerCommon {
    private static final Map<ItemEntity, Integer> entities = Maps.newHashMap();
    private static int lastCheck = 0;

    public static boolean itemTossEvent(ItemEntity entity, Player player) {
        if (!entity.level().isClientSide()) {
            EventHandlerCommon.addPlayerThrownItemEntity(entity);
        }
        return true;
    }

    public static void worldTickEvent(ServerLevel level) {
        EventHandlerCommon.itemEntityCheck(level);
    }

    private static void addPlayerThrownItemEntity(ItemEntity entity) {
        if (ConcreteConversionCommon.CONFIG.getOnlyPlayerThrownItems() && (EventHandlerCommon.isConcretePowder(entity) || ConcreteConversionCommon.CONFIG.getConvertMud() && EventHandlerCommon.isValidDirt(entity))) {
            entities.putIfAbsent(entity, 0);
        }
    }

    private static boolean isConcretePowder(ItemEntity entity) {
        return Block.byItem((Item)entity.getItem().getItem()) instanceof ConcretePowderBlock;
    }

    private static boolean isValidDirt(ItemEntity entity) {
        return Block.byItem((Item)entity.getItem().getItem()).defaultBlockState().is(BlockTags.CONVERTABLE_TO_MUD);
    }

    private static void itemEntityCheck(ServerLevel level) {
        if (ConcreteConversionCommon.CONFIG.getConversionCheckDelay() <= ++lastCheck) {
            lastCheck = 0;
            if (!ConcreteConversionCommon.CONFIG.getOnlyPlayerThrownItems()) {
                for (ItemEntity entity2 : level.getEntities((EntityTypeTest)EntityType.ITEM, entity -> true)) {
                    entities.putIfAbsent(entity2, 0);
                }
            }
            Iterator<ItemEntity> iterator = entities.keySet().iterator();
            while (iterator.hasNext()) {
                ItemEntity entity2;
                entity2 = iterator.next();
                if (!entity2.isAlive()) {
                    iterator.remove();
                    continue;
                }
                if (entity2.isInWater()) {
                    if (entities.get(entity2) >= ConcreteConversionCommon.CONFIG.getConversionDelay()) {
                        EventHandlerCommon.convertEntity(entity2);
                        iterator.remove();
                        continue;
                    }
                    entities.replace(entity2, entities.get(entity2) + 1);
                    continue;
                }
                entities.replace(entity2, 0);
            }
        }
    }

    private static void convertEntity(ItemEntity entity) {
        ItemStack stack = entity.getItem();
        Block block = null;
        if (EventHandlerCommon.isConcretePowder(entity)) {
            block = EventHandlerCommon.getPowderConverted(Block.byItem((Item)stack.getItem()));
        } else if (ConcreteConversionCommon.CONFIG.getConvertMud() && EventHandlerCommon.isValidDirt(entity)) {
            block = Blocks.MUD;
        }
        if (block != null) {
            entity.setItem(new ItemStack((ItemLike)block, stack.getCount()));
        }
    }

    private static Block getPowderConverted(Block block) {
        ConcretePowderBlock concretePowderBlock;
        ConcretePowderBlock concretePowderBlock2 = concretePowderBlock = block instanceof ConcretePowderBlock ? (ConcretePowderBlock)block : null;
        if (concretePowderBlock == null) {
            return null;
        }
        return concretePowderBlock.concrete;
    }
}

