/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.api.transmission.energy;

import com.craftjakob.api.Preconditions;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Clearable;

public interface EnergyContainer
extends Clearable {
    public long getEnergy();

    public long getCapacity();

    public long getMaxInsert();

    public long getMaxExtract();

    public void setEnergy(long var1);

    public void setCapacity(long var1);

    public void setMaxInsert(long var1);

    public void setMaxExtract(long var1);

    default public long getAvailableSpace() {
        return this.getCapacity() - this.getEnergy();
    }

    default public boolean isEmpty() {
        return this.getEnergy() <= 0L;
    }

    default public boolean isFull() {
        return this.getEnergy() >= this.getCapacity();
    }

    default public boolean canInsert() {
        return this.getEnergy() < this.getCapacity() && this.getMaxInsert() > 0L;
    }

    default public boolean canExtract() {
        return this.getEnergy() > 0L && this.getMaxExtract() > 0L;
    }

    default public void clearContent() {
        this.setEnergy(0L);
    }

    default public long insert(long amount) {
        Preconditions.notNegative(amount);
        long inserted = Math.min(this.getMaxInsert(), Math.min(amount, this.getAvailableSpace()));
        if (inserted > 0L) {
            if (Long.MAX_VALUE - this.getEnergy() < inserted) {
                inserted = Long.MAX_VALUE - this.getEnergy();
            }
            this.setEnergy(this.getEnergy() + inserted);
            return inserted;
        }
        return 0L;
    }

    default public long extract(long amount) {
        Preconditions.notNegative(amount);
        long extracted = Math.min(this.getMaxExtract(), Math.min(amount, this.getEnergy()));
        if (extracted > 0L) {
            this.setEnergy(this.getEnergy() - extracted);
            return extracted;
        }
        return 0L;
    }

    default public long insert() {
        return this.insert(this.getMaxInsert());
    }

    default public long extract() {
        return this.extract(this.getMaxExtract());
    }

    default public long transferEnergy(EnergyContainer target, long amount) {
        Preconditions.notNegative(amount);
        if (target.isFull()) {
            return 0L;
        }
        long extracted = this.extract(amount);
        if (extracted > 0L) {
            return target.insert(extracted);
        }
        return 0L;
    }

    default public long transferEnergy(EnergyContainer target) {
        return this.transferEnergy(target, this.getMaxExtract());
    }

    default public void serialize(CompoundTag tag, HolderLookup.Provider provider) {
        CompoundTag energyStorageTag = new CompoundTag();
        energyStorageTag.putLong("Energy", this.getEnergy());
        tag.put("EnergyContainer", (Tag)energyStorageTag);
    }

    default public void deserialize(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.getCompound("EnergyContainer").isPresent()) {
            this.setEnergy(((CompoundTag)tag.getCompound("EnergyContainer").get()).getLongOr("Energy", 0L));
        }
    }
}

