/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.api.transmission.energy;

import com.craftjakob.api.Preconditions;
import com.craftjakob.api.transmission.energy.EnergyContainer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class EnergyStorage
implements EnergyContainer {
    public static final Codec<EnergyStorage> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("energy").forGetter(EnergyStorage::getEnergy), (App)Codec.LONG.fieldOf("capacity").forGetter(EnergyStorage::getCapacity), (App)Codec.LONG.fieldOf("maxInsert").forGetter(EnergyStorage::getMaxInsert), (App)Codec.LONG.fieldOf("maxExtract").forGetter(EnergyStorage::getMaxExtract)).apply((Applicative)instance, (energy, capacity, maxInsert, maxExtract) -> {
        EnergyStorage energyStorage = new EnergyStorage((long)capacity, (long)maxInsert, (long)maxExtract);
        energyStorage.setEnergy((long)energy);
        return energyStorage;
    }));
    public static final StreamCodec<ByteBuf, EnergyStorage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.LONG, EnergyStorage::getEnergy, (StreamCodec)ByteBufCodecs.LONG, EnergyStorage::getCapacity, (StreamCodec)ByteBufCodecs.LONG, EnergyStorage::getMaxInsert, (StreamCodec)ByteBufCodecs.LONG, EnergyStorage::getMaxExtract, (energy, capacity, maxInsert, maxExtract) -> {
        EnergyStorage energyStorage = new EnergyStorage((long)capacity, (long)maxInsert, (long)maxExtract);
        energyStorage.setEnergy((long)energy);
        return energyStorage;
    });
    public static final EnergyStorage EMPTY = new EnergyStorage(0L, 0L, 0L);
    private long energy;
    private long capacity;
    private long maxInsert;
    private long maxExtract;

    public EnergyStorage(long capacity, long maxInsert, long maxExtract) {
        this.capacity = Preconditions.notNegative(capacity);
        this.maxInsert = Preconditions.notNegative(maxInsert);
        this.maxExtract = Preconditions.notNegative(maxExtract);
    }

    @Override
    public long getEnergy() {
        return this.energy;
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public long getMaxInsert() {
        return this.maxInsert;
    }

    @Override
    public long getMaxExtract() {
        return this.maxExtract;
    }

    @Override
    public void setEnergy(long energy) {
        this.energy = Math.min(this.capacity, Math.max(0L, Preconditions.notNegative(energy)));
    }

    @Override
    public void setCapacity(long capacity) {
        this.capacity = Preconditions.notNegative(capacity);
        this.setEnergy(Math.min(this.energy, capacity));
    }

    @Override
    public void setMaxInsert(long maxInsert) {
        this.maxInsert = Preconditions.notNegative(maxInsert);
    }

    @Override
    public void setMaxExtract(long maxExtract) {
        this.maxExtract = Preconditions.notNegative(maxExtract);
    }

    public void onEnergyChanged() {
    }
}

