/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.configapi;

import com.craftjakob.configapi.client.screen.ConfigTypeSelectionScreen;
import com.craftjakob.configapi.config.Config;
import com.craftjakob.configapi.config.ConfigEvents;
import com.craftjakob.configapi.config.ConfigTracker;
import com.craftjakob.event.EventPriority;
import com.craftjakob.event.events.client.ClientLifecycleEvent;
import com.craftjakob.event.events.client.ClientPlayerEvent;
import com.craftjakob.platform.EnvironmentType;
import com.craftjakob.platform.Mod;
import com.craftjakob.platform.Platform;
import com.craftjakob.platform.annotation.Environment;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;

@Environment(value=EnvironmentType.CLIENT)
public final class ConfigAPIClient {
    private ConfigAPIClient() {
    }

    public static void registerClient() {
        ClientLifecycleEvent.CLIENT_SETUP.priority(EventPriority.HIGH).register(minecraft -> {
            ConfigEvents.onClientLoad();
            minecraft.execute(() -> Platform.getMods().forEach((modId, mod) -> {
                Map<Config.ConfigType, LinkedHashSet<Config>> modConfigs = ConfigTracker.get().getConfigsByModId().get(modId);
                if (modConfigs != null && !modConfigs.isEmpty()) {
                    String name = mod.getName();
                    Identifier logoLocation = ConfigAPIClient.getModLogoLocation(modId);
                    mod.registerConfigScreen(parentScreen -> new ConfigTypeSelectionScreen(parentScreen, logoLocation, (Component)Component.literal((String)name), modConfigs));
                }
            }));
        });
        ClientPlayerEvent.CLIENT_QUIT.priority(EventPriority.LOW).register((localPlayer, clientPacketListener, minecraft) -> {
            if (!minecraft.isLocalServer()) {
                ConfigEvents.onUnloadServer();
            }
        });
    }

    public static Identifier getModLogoLocation(String modId) {
        Mod mod = Platform.getMod(modId);
        Optional<String> logoStringPath = mod.getLogoFile(512);
        if (logoStringPath.isPresent()) {
            TextureManager tm = Minecraft.getInstance().getTextureManager();
            Path logoPath = mod.findResource(logoStringPath.get()).orElse(null);
            if (logoPath != null) {
                Identifier identifier;
                block10: {
                    InputStream inputStream = Files.newInputStream(logoPath, new OpenOption[0]);
                    try {
                        NativeImage nativeImage = NativeImage.read((InputStream)inputStream);
                        Identifier textureId = Identifier.fromNamespaceAndPath((String)modId, (String)"mod_logo");
                        tm.register(textureId, (AbstractTexture)new DynamicTexture(nativeImage.getPixels()::toString, nativeImage));
                        identifier = textureId;
                        if (inputStream == null) break block10;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Failed to get and register logo file for the mod id: " + modId, e);
                        }
                    }
                    inputStream.close();
                }
                return identifier;
            }
        }
        return Identifier.fromNamespaceAndPath((String)"configapi", (String)"textures/gui/widget/logo_background.png");
    }
}

