/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.configapi.client;

import com.craftjakob.configapi.client.screen.widget.ImageTextButton;
import com.craftjakob.configapi.config.ConfigData;
import com.craftjakob.configapi.config.ConfigValueTypes;
import com.craftjakob.configapi.example.ClientConfig;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;

public class ConfigScreenUtils {
    public static WidgetSprites RESET_BUTTON_SPRITES = new WidgetSprites(Identifier.fromNamespaceAndPath((String)"configapi", (String)"widget/reset_button"), Identifier.fromNamespaceAndPath((String)"configapi", (String)"widget/reset_button_disabled"), Identifier.fromNamespaceAndPath((String)"configapi", (String)"widget/reset_button_highlighted"));
    public static WidgetSprites EDIT_BUTTON_SPRITES = new WidgetSprites(Identifier.fromNamespaceAndPath((String)"configapi", (String)"widget/edit_button"), Identifier.fromNamespaceAndPath((String)"configapi", (String)"widget/edit_button_highlighted"));

    public static ImageButton createEditButton(Button.OnPress onPress) {
        return new ImageButton(0, 0, 20, 20, EDIT_BUTTON_SPRITES, onPress);
    }

    public static ImageTextButton createModifyButton(Button.OnPress onPress) {
        return new ImageTextButton(0, 0, 60, 20, (Component)Component.literal((String)"Modify"), Identifier.fromNamespaceAndPath((String)"configapi", (String)"textures/gui/widget/modify.png"), 20, 20, onPress);
    }

    public static ImageTextButton createSelectButton(Button.OnPress onPress) {
        return new ImageTextButton(0, 0, 60, 20, (Component)Component.literal((String)"Select"), Identifier.fromNamespaceAndPath((String)"configapi", (String)"textures/gui/widget/modify.png"), 20, 20, onPress);
    }

    public static ImageTextButton createPickWorldButton(Button.OnPress onPress) {
        return new ImageTextButton(0, 0, 80, 20, (Component)Component.literal((String)"Pick World"), Identifier.fromNamespaceAndPath((String)"configapi", (String)"textures/gui/widget/earth.png"), 20, 20, onPress);
    }

    public static ImageButton createIconResetButton(int x, int y, Button.OnPress onPress) {
        ImageButton imageButton = new ImageButton(x, y, 20, 20, RESET_BUTTON_SPRITES, onPress);
        imageButton.active = false;
        return imageButton;
    }

    public static ImageButton createIconResetButton(Button.OnPress onPress) {
        ImageButton imageButton = new ImageButton(0, 0, 20, 20, RESET_BUTTON_SPRITES, onPress);
        imageButton.active = false;
        return imageButton;
    }

    public static <T> ImageButton createIconResetButton(ConfigValueTypes.ConfigValue<T> config, AbstractWidget widget) {
        ImageButton imageButton = ConfigScreenUtils.createIconResetButton(button -> {
            config.setValue(config.getDefaultValue());
            if (widget instanceof CycleButton) {
                ((CycleButton)widget).setValue(config.getValue());
            }
            if (widget instanceof EditBox) {
                EditBox editBox = (EditBox)widget;
                editBox.setValue(String.valueOf(config.getValue()));
            }
        });
        imageButton.active = false;
        return imageButton;
    }

    public static <T> Button createResetButton(ConfigValueTypes.ConfigValue<T> config, AbstractWidget widget) {
        Button button = Button.builder((Component)Component.translatable((String)"controls.reset"), onPress -> {
            config.setValue(config.getDefaultValue());
            if (widget instanceof CycleButton) {
                ((CycleButton)widget).setValue(config.getValue());
            }
            if (widget instanceof EditBox) {
                EditBox editBox = (EditBox)widget;
                editBox.setValue(String.valueOf(config.getValue()));
            }
        }).bounds(0, 0, 20, 20).build();
        button.active = false;
        return button;
    }

    public static void highlightEntry(GuiGraphics graphics, int entryLeft, int entryRight, int entryTop, int entryHeight, boolean hovered) {
        if (((Boolean)ClientConfig.EntriesAreHighlighted.getValue()).booleanValue() && hovered) {
            int color = -2139127937;
            graphics.fill(entryLeft - 5, entryTop, entryRight, entryTop + entryHeight, color);
        }
    }

    public static String addSpaceAfterCapitalLetter(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        Object result = Character.toUpperCase(input.charAt(0)) + input.substring(1);
        result = ((String)result).replaceAll("([A-Z])", " $1");
        return ((String)result).trim();
    }

    public static Component createTooltipText(ConfigValueTypes.ConfigValue<?> config) {
        String correctDefaultValue;
        MutableComponent tooltipText = Component.literal((String)config.getKey()).withStyle((ChatFormatting)ClientConfig.KeyTooltipColor.getValue()).append("\n");
        ConfigScreenUtils.createComments((Component)tooltipText, config.getComments());
        Object obj = config.getDefaultValue();
        if (obj instanceof Enum) {
            Enum enumValue = (Enum)obj;
            v0 = enumValue.name();
        } else {
            v0 = correctDefaultValue = config.getDefaultValue().toString();
        }
        if (config.hasTranslationKey()) {
            tooltipText.getSiblings().add(Component.translatable((String)config.getTranslationKey()).withStyle(ChatFormatting.AQUA).append("\n"));
        }
        tooltipText.getSiblings().add(Component.literal((String)("Default Value: " + correctDefaultValue)).withStyle(ChatFormatting.GRAY));
        return tooltipText;
    }

    public static Component createTooltipTextForCategory(ConfigData configData, String categoryName, List<String> folderPath) {
        MutableComponent tooltipText = Component.literal((String)categoryName).withStyle((ChatFormatting)ClientConfig.KeyTooltipColor.getValue()).append("\n");
        if (configData.getCategoryComments().get(folderPath) != null) {
            List<String> comments = configData.getCategoryComments().get(folderPath);
            ConfigScreenUtils.createComments((Component)tooltipText, comments);
        }
        if (configData.getCategoryTranslationKeys().get(folderPath) != null) {
            tooltipText.getSiblings().add(Component.translatable((String)configData.getCategoryTranslationKeys().get(folderPath)).withStyle(ChatFormatting.AQUA).append("\n"));
        }
        tooltipText.getSiblings().add(Component.literal((String)folderPath.toString()).withStyle(ChatFormatting.GRAY));
        return tooltipText;
    }

    private static void createComments(Component tooltipText, List<String> comments) {
        for (String comment : comments) {
            if (comment.startsWith("Range: ") || comment.startsWith("Allowed Values: ")) {
                tooltipText.getSiblings().add(Component.literal((String)comment).withStyle((ChatFormatting)ClientConfig.PossibleValuesTooltipColor.getValue()).append("\n"));
                continue;
            }
            if (comment.startsWith("Requires World Restart") || comment.startsWith("Requires Client Restart")) {
                tooltipText.getSiblings().add(Component.literal((String)comment).withStyle(ChatFormatting.RED).append("\n"));
                continue;
            }
            if (comment.startsWith("Only for ModLoader: ") || comment.startsWith("Only for ModLoaders: ")) {
                tooltipText.getSiblings().add(Component.literal((String)comment).withStyle(ChatFormatting.RED).append("\n"));
                continue;
            }
            if (comment.startsWith("Doesn't work on ModLoader: ") || comment.startsWith("Doesn't work on ModLoaders: ")) {
                tooltipText.getSiblings().add(Component.literal((String)comment).withStyle(ChatFormatting.RED).append("\n"));
                continue;
            }
            tooltipText.getSiblings().add(Component.literal((String)comment).withStyle(ChatFormatting.WHITE).append("\n"));
        }
    }
}

