/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.configapi.client.screen;

import com.craftjakob.configapi.ConfigAPI;
import com.craftjakob.configapi.client.ConfigScreenUtils;
import com.craftjakob.configapi.client.screen.ConfigScreen;
import com.craftjakob.configapi.client.screen.ModScreen;
import com.craftjakob.configapi.client.screen.list.ModObjectSelectionList;
import com.craftjakob.configapi.client.screen.widget.ImageTextButton;
import com.craftjakob.configapi.config.Config;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.FaviconTexture;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Util;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.NonNull;

public class ConfigWorldSelectionScreen
extends ModScreen {
    private final Config config;
    private final String modDisplayName;
    private ConfigWorldSelectionList list;
    private Button openFileButton;
    private Button doneButton;

    public ConfigWorldSelectionScreen(ModScreen lastScreen, String modDisplayName, Config config) {
        super(lastScreen, (Component)Component.literal((String)"Select World"), lastScreen.getLogoId());
        this.modDisplayName = modDisplayName;
        this.config = config;
    }

    @Override
    public void init() {
        this.list = new ConfigWorldSelectionList(50);
        this.addWidget((GuiEventListener)this.list);
        this.doneButton = Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).bounds(this.width / 2, this.height - 27, 150, 20).build();
        this.addWidget((GuiEventListener)this.doneButton);
        this.openFileButton = Button.builder((Component)Component.literal((String)"Open Config File"), button -> {
            ConfigWorldSelectionList.Entry selected = (ConfigWorldSelectionList.Entry)this.list.getSelected();
            if (selected != null) {
                if (!selected.config.getConfigFile().exists()) {
                    selected.config.save();
                }
                Util.getPlatform().openFile(selected.config.getConfigFile());
            }
        }).bounds(this.width / 2 - 150, this.height - 27, 150, 20).build();
        this.addWidget((GuiEventListener)this.openFileButton);
        super.init();
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.list.render(graphics, mouseX, mouseY, partialTicks);
        this.doneButton.render(graphics, mouseX, mouseY, partialTicks);
        this.openFileButton.render(graphics, mouseX, mouseY, partialTicks);
        this.openFileButton.active = this.list.getSelected() != null;
    }

    public class ConfigWorldSelectionList
    extends ModObjectSelectionList<Entry> {
        public ConfigWorldSelectionList(int buttonSpacing) {
            super(ConfigWorldSelectionScreen.this.minecraft, ConfigWorldSelectionScreen.this.width, ConfigWorldSelectionScreen.this.height - 64, 32, buttonSpacing);
            this.constructEntries();
        }

        public void constructEntries() {
            try {
                LevelStorageSource source = Minecraft.getInstance().getLevelSource();
                ArrayList levels = new ArrayList((Collection)source.loadLevelSummaries(source.findLevelCandidates()).join());
                if (levels.size() > 6) {
                    List<LevelSummary> recent = levels.stream().sorted(Comparator.comparing(LevelSummary::getLastPlayed)).limit(3L).toList();
                    levels.removeAll(recent);
                }
                levels.stream().sorted(Comparator.comparing(LevelSummary::getLevelName)).forEach(summary -> this.addEntry((AbstractSelectionList.Entry)new Entry(ConfigWorldSelectionScreen.this.config, (LevelSummary)summary)));
            }
            catch (LevelStorageException e) {
                ConfigAPI.LOGGER.error("Could not load level list", (Throwable)e);
            }
        }

        public int getRowWidth() {
            return this.width;
        }

        public class Entry
        extends ModObjectSelectionList.Entry<Entry> {
            private final Config config;
            private final LevelSummary summary;
            private final String levelName;
            private final Path iconFile;
            private final ImageTextButton selectButton;
            private final Button resetButton;
            private final FaviconTexture icon;

            public Entry(Config config, LevelSummary summary) {
                this.config = config;
                this.summary = summary;
                this.levelName = summary.getLevelName();
                this.iconFile = summary.getIcon();
                this.config.setConfigFile(this.getServerConfigPath(this.summary.getLevelId()));
                if (this.config.getConfigData() == null) {
                    config.setConfigData(config.configureConfigData(config.getConfigurator()));
                }
                this.config.load();
                this.config.save();
                this.selectButton = ConfigScreenUtils.createSelectButton(button -> {
                    this.config.setConfigFile(this.getServerConfigPath(this.summary.getLevelId()));
                    if (this.config.getConfigData() == null) {
                        config.setConfigData(config.configureConfigData(config.getConfigurator()));
                    }
                    this.config.load();
                    this.config.save();
                    ConfigScreen configScreen = new ConfigScreen(ConfigWorldSelectionScreen.this, (Component)Component.literal((String)this.levelName), ConfigWorldSelectionScreen.this.modDisplayName, config, 0);
                    Objects.requireNonNull(ConfigWorldSelectionScreen.this.minecraft).setScreen((Screen)configScreen);
                });
                this.resetButton = ConfigScreenUtils.createIconResetButton(button -> {
                    this.config.resetAllConfigs();
                    button.active = !this.config.allConfigsOnDefault();
                });
                this.resetButton.active = !this.config.allConfigsOnDefault();
                this.icon = this.loadWorldIcon();
            }

            @Override
            public void renderContent(@NonNull GuiGraphics graphics, int mouseX, int mouseY, boolean hovered, float partialTicks) {
                super.renderContent(graphics, mouseX, mouseY, hovered, partialTicks);
                int entryWidth = this.getContentRight() - this.getContentX() + 5;
                int entryCenter = entryWidth / 2;
                graphics.blit(RenderPipelines.GUI_TEXTURED, this.icon.textureLocation(), entryCenter - 150, this.getContentY() + 1, 0.0f, 0.0f, 44, 44, 44, 44);
                this.selectButton.setPosition(entryCenter + 100, this.getContentY() + 8);
                this.selectButton.render(graphics, mouseX, mouseY, partialTicks);
                this.resetButton.setPosition(entryCenter + 160, this.getContentY() + 8);
                this.resetButton.render(graphics, mouseX, mouseY, partialTicks);
                graphics.drawString(ConfigWorldSelectionScreen.this.font, this.levelName, entryCenter - 100, this.getContentY() + 8, -1);
                graphics.drawString(ConfigWorldSelectionScreen.this.font, this.summary.getLevelId() + " (" + new SimpleDateFormat().format(new Date(this.summary.getLastPlayed())) + ")", entryCenter - 100, this.getContentY() + 18, -8355712);
                graphics.drawString(ConfigWorldSelectionScreen.this.font, this.summary.getInfo(), entryCenter - 100, this.getContentY() + 28, -8355712);
            }

            public boolean mouseClicked(@NonNull MouseButtonEvent event, boolean flag) {
                this.config.setConfigFile(this.getServerConfigPath(this.summary.getLevelId()));
                ConfigWorldSelectionList.this.setSelected((AbstractSelectionList.Entry)this);
                return this.selectButton.mouseClicked(event, flag) || this.resetButton.mouseClicked(event, flag) || super.mouseClicked(event, flag);
            }

            public boolean keyPressed(@NonNull KeyEvent event) {
                return this.selectButton.keyPressed(event) || this.resetButton.keyPressed(event) || super.keyPressed(event);
            }

            @NotNull
            public Component getNarration() {
                return Component.literal((String)this.levelName);
            }

            private FaviconTexture loadWorldIcon() {
                FaviconTexture texture = FaviconTexture.forWorld((TextureManager)Objects.requireNonNull(ConfigWorldSelectionScreen.this.minecraft).getTextureManager(), (String)this.summary.getLevelId());
                if (this.iconFile != null && Files.isRegularFile(this.iconFile, new LinkOption[0])) {
                    try (InputStream inputStream = Files.newInputStream(this.iconFile, new OpenOption[0]);){
                        texture.upload(NativeImage.read((InputStream)inputStream));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return texture;
            }

            public Path getServerConfigPath(String worldId) {
                String serverConfigFolder = "serverconfig";
                Path configDirectory = Minecraft.getInstance().getLevelSource().getLevelPath(worldId).resolve(serverConfigFolder);
                if (!Files.isDirectory(configDirectory, new LinkOption[0])) {
                    try {
                        Files.createDirectories(configDirectory, new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        ConfigAPI.LOGGER.error("Could not create serverconfig directory!", (Throwable)e);
                    }
                }
                return configDirectory;
            }
        }
    }
}

