/*
 * Decompiled with CFR 0.152.
 */
package com.craftjakob.configapi.client.screen.widget;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.NonNull;

public class CheckBoxButton
extends AbstractButton {
    private static final Identifier CHECKBOX = Identifier.fromNamespaceAndPath((String)"configapi", (String)"textures/gui/widget/checkbox.png");
    private static final Identifier CHECKBOX_HIGHLIGHTED = Identifier.fromNamespaceAndPath((String)"configapi", (String)"textures/gui/widget/checkbox_highlighted.png");
    private static final Identifier CHECKBOX_MARKED = Identifier.fromNamespaceAndPath((String)"configapi", (String)"textures/gui/widget/checkbox_marked.png");
    private static final Identifier CHECKBOX_MARKED_HIGHLIGHTED = Identifier.fromNamespaceAndPath((String)"configapi", (String)"textures/gui/widget/checkbox_marked_highlighted.png");
    private final OnPress onPress;
    private boolean isChecked;

    public CheckBoxButton(int x, int y, OnPress onPress) {
        super(x, y, 15, 15, CommonComponents.EMPTY);
        this.onPress = onPress;
        this.setTooltip(Tooltip.create((Component)Component.literal((String)"Deep Search")));
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void setChecked(boolean isChecked) {
        this.isChecked = isChecked;
    }

    public void onPress(@NonNull InputWithModifiers inputWithModifiers) {
        this.isChecked = !this.isChecked;
        this.onPress.onPress(this);
    }

    public void renderContents(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Identifier texture = this.isHovered() ? (this.isChecked() ? CHECKBOX_MARKED_HIGHLIGHTED : CHECKBOX_HIGHLIGHTED) : (this.isChecked() ? CHECKBOX_MARKED : CHECKBOX);
        graphics.blit(RenderPipelines.GUI_TEXTURED, texture, this.getX(), this.getY(), 0.0f, 0.0f, 20, 20, 20, 20);
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput narrationElementOutput) {
        this.defaultButtonNarrationText(narrationElementOutput);
    }

    public static interface OnPress {
        public void onPress(CheckBoxButton var1);
    }
}

